/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.modules;

import java.net.URI;
import java.net.URL;
import org.daisy.common.file.URLs;
import org.daisy.pipeline.modules.Module;
import org.daisy.pipeline.modules.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entity {
    private final String mPublicId;
    private final String mPath;
    private final ResourceLoader mLoader;
    private Module mModule;
    private static Logger mLogger = LoggerFactory.getLogger(Entity.class);

    public Entity(String publicId, String path, ResourceLoader loader) {
        this.mPublicId = publicId;
        this.mPath = path;
        this.mLoader = loader;
    }

    public Module getModule() {
        return this.mModule;
    }

    public void setModule(Module module) {
        this.mModule = module;
    }

    public String getPublicId() {
        return this.mPublicId;
    }

    public URI getResource() {
        try {
            mLogger.trace("Getting resource from entity " + this + ": " + this.mPath);
            URL url = this.mLoader.loadResource(this.mPath);
            if (url != null) {
                return URLs.asURI((URL)url);
            }
            return null;
        }
        catch (Exception e) {
            mLogger.debug("Resource " + this.mPath + " does not exist", (Throwable)e);
            return null;
        }
    }

    public ResourceLoader getLoader() {
        return this.mLoader;
    }
}

