/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.modules;

import java.net.URI;
import java.net.URL;
import org.daisy.common.file.URLs;
import org.daisy.pipeline.modules.Module;
import org.daisy.pipeline.modules.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Component {
    private final URI uri;
    private final String path;
    private final ResourceLoader loader;
    private Module module;
    Logger mLogger = LoggerFactory.getLogger((String)this.getClass().getName());

    public Component(URI uri, String path, ResourceLoader loader) {
        this.uri = uri;
        this.path = path;
        this.loader = loader;
    }

    public URI getURI() {
        return this.uri;
    }

    public URI getResource() {
        try {
            this.mLogger.trace("Getting resource from component " + this + ": " + this.path);
            URL url = this.loader.loadResource(this.path);
            if (url != null) {
                return URLs.asURI((URL)url);
            }
            return null;
        }
        catch (Exception e) {
            this.mLogger.debug("Resource " + this.path + " does not exist", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "[" + this.uri + "]";
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }
}

