/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.shell;

import com.google.common.base.Optional;
import java.io.File;

public class BinaryFinder {
    private static final String[] winExtensions = new String[]{".exe", ".bat", ".cmd", ".bin", ""};
    private static final String[] nixExtensions = new String[]{"", ".run", ".bin", ".sh"};

    public static Optional<String> find(String executableName) {
        String os = System.getProperty("os.name");
        String[] extensions = os != null && os.startsWith("Windows") ? winExtensions : nixExtensions;
        return BinaryFinder.find(executableName, extensions, System.getenv("PATH"), File.pathSeparator);
    }

    static Optional<String> find(String executableName, String[] extensions, String systemPath, String pathSeparator) {
        if (systemPath == null || pathSeparator == null) {
            return Optional.absent();
        }
        String[] pathDirs = systemPath.split(pathSeparator);
        for (String ext : extensions) {
            String fullname = executableName + ext;
            for (String pathDir : pathDirs) {
                File file = new File(pathDir, fullname);
                if (!file.isFile()) continue;
                return Optional.of((Object)file.getAbsolutePath());
            }
        }
        return Optional.absent();
    }
}

