/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.properties;

import org.daisy.common.properties.Property;
import org.daisy.common.properties.PropertyTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyPublisher {
    private PropertyTracker tracker;
    private static Logger logger = LoggerFactory.getLogger((String)PropertyPublisher.class.getName());

    PropertyPublisher(PropertyTracker tracker) {
        this.tracker = tracker;
    }

    public void publish(Property property) {
        if (this.tracker != null) {
            this.tracker.addProperty(property);
        } else {
            logger.warn("Trying to publish a property but the tracker is not set");
        }
    }

    public void publish(String propertyName, String value, Class origin) {
        Bundle bundle = FrameworkUtil.getBundle((Class)origin);
        if (bundle == null) {
            throw new IllegalStateException("Bundle not found for " + origin.getCanonicalName());
        }
        Property prop = new Property.Builder().withPropertyName(propertyName).withValue(value).withBundleId(bundle.getBundleId()).withBundleName(bundle.getSymbolicName()).build();
        this.publish(prop);
    }

    public void unpublish(String propertyName, Class origin) {
        if (this.tracker == null) {
            logger.warn("Trying to unpublish a property but the tracker is not set");
            return;
        }
        Bundle bundle = FrameworkUtil.getBundle((Class)origin);
        if (bundle == null) {
            throw new IllegalStateException("Bundle not found for " + origin.getCanonicalName());
        }
        Property prop = this.tracker.getProperty(propertyName, bundle.getSymbolicName());
        if (prop == null) {
            throw new IllegalStateException("Property not found for name:" + propertyName + " bundle " + bundle.getSymbolicName());
        }
        this.unpublish(prop);
    }

    public void unpublish(Property property) {
        if (this.tracker != null) {
            this.tracker.deleteProperty(property);
        } else {
            logger.warn("Trying to unpublish a property but the tracker is not set");
        }
    }

    public void setTracker(PropertyTracker tracker) {
        this.tracker = tracker;
    }

    public PropertyTracker getTracker() {
        return this.tracker;
    }
}

