/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.priority;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ForwardingBlockingQueue;
import com.google.common.util.concurrent.Monitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.daisy.common.priority.PrioritizableComparator;
import org.daisy.common.priority.PrioritizableRunnable;
import org.daisy.common.priority.SwappingPriority;
import org.daisy.common.priority.WrappingPriorityQueue;

public class UpdatablePriorityBlockingQueue<T>
extends ForwardingBlockingQueue<Runnable> {
    private WrappingPriorityQueue<PrioritizableRunnable<T>, SwappingPriority<T>> delegate;
    private Monitor monitor = new Monitor();
    private Monitor.Guard canTake = new Monitor.Guard(this.monitor){

        public boolean isSatisfied() {
            return UpdatablePriorityBlockingQueue.this.delegate.size() > 0 && !UpdatablePriorityBlockingQueue.this.updating.get();
        }
    };
    private Monitor.Guard canAdd = new Monitor.Guard(this.monitor){

        public boolean isSatisfied() {
            return !UpdatablePriorityBlockingQueue.this.updating.get();
        }
    };
    private Function<SwappingPriority<T>, PrioritizableRunnable<T>> unwrapFunction = new Function<SwappingPriority<T>, PrioritizableRunnable<T>>(){

        public PrioritizableRunnable<T> apply(SwappingPriority<T> arg) {
            return arg.getDelegate();
        }
    };
    private Function<PrioritizableRunnable<T>, SwappingPriority<T>> wrapFunction = new Function<PrioritizableRunnable<T>, SwappingPriority<T>>(){

        public SwappingPriority<T> apply(PrioritizableRunnable<T> arg) {
            return new SwappingPriority(arg);
        }
    };
    AtomicBoolean updating = new AtomicBoolean(false);

    public UpdatablePriorityBlockingQueue() {
        this.delegate = this.buildQueue();
    }

    private WrappingPriorityQueue<PrioritizableRunnable<T>, SwappingPriority<T>> buildQueue() {
        PriorityBlockingQueue queue = new PriorityBlockingQueue(20, new PrioritizableComparator());
        return new WrappingPriorityQueue<PrioritizableRunnable<T>, SwappingPriority<T>>(queue, this.wrapFunction, this.unwrapFunction);
    }

    private void enterUpdate() {
        this.monitor.enter();
        this.updating.set(true);
    }

    private void leaveUpdate() {
        this.doUpdate();
        this.updating.set(false);
        this.monitor.leave();
    }

    private void doUpdate() {
        LinkedList aux = Lists.newLinkedList(this.delegate.wrapped());
        this.delegate.clear();
        this.delegate.addAllBypass(aux);
    }

    protected Optional<SwappingPriority<T>> tryFind(final PrioritizableRunnable<T> runnable) {
        return Iterables.tryFind(this.delegate.wrapped(), (Predicate)new Predicate<SwappingPriority<T>>(){

            public boolean apply(SwappingPriority<T> e) {
                return e.getDelegate().equals(runnable);
            }
        });
    }

    public synchronized void swap(PrioritizableRunnable<T> runnable1, PrioritizableRunnable<T> runnable2) {
        this.enterUpdate();
        Optional<SwappingPriority<T>> node1 = this.tryFind(runnable1);
        Optional<SwappingPriority<T>> node2 = this.tryFind(runnable2);
        if (!node1.isPresent() || !node2.isPresent()) {
            this.leaveUpdate();
            return;
        }
        ((SwappingPriority)node1.get()).swapWith((SwappingPriority)node2.get());
        this.leaveUpdate();
    }

    public synchronized void update(Function<PrioritizableRunnable<T>, Void> function) {
        this.enterUpdate();
        Iterator<PrioritizableRunnable<T>> iterator = this.delegate.iterator();
        while (iterator.hasNext()) {
            PrioritizableRunnable<T> runnable = iterator.next();
            function.apply(runnable);
        }
        this.leaveUpdate();
    }

    public Collection<PrioritizableRunnable<T>> asOrderedCollection() {
        LinkedList list = Lists.newLinkedList(this.delegate.wrapped());
        Collections.sort(list, new PrioritizableComparator());
        return ImmutableList.copyOf((Collection)Collections2.transform((Collection)list, this.unwrapFunction));
    }

    public Collection<PrioritizableRunnable<T>> asCollection() {
        return ImmutableList.copyOf(this.delegate.unwrap());
    }

    protected BlockingQueue<Runnable> delegate() {
        return this.delegate;
    }

    public synchronized boolean offer(Runnable o) {
        try {
            this.monitor.enterWhen(this.canAdd);
        }
        catch (InterruptedException e) {
            this.monitor.leave();
            throw new RuntimeException(e);
        }
        boolean res = this.delegate.offer((PrioritizableRunnable)o);
        this.monitor.leave();
        return res;
    }

    public synchronized boolean add(Runnable element) {
        try {
            this.monitor.enterWhen(this.canAdd);
        }
        catch (InterruptedException e) {
            this.monitor.leave();
            throw new RuntimeException(e);
        }
        boolean res = this.delegate.add((PrioritizableRunnable)element);
        this.monitor.leave();
        return res;
    }

    public Runnable take() throws InterruptedException {
        this.monitor.enterWhen(this.canTake);
        Runnable res = this.delegate.poll();
        this.monitor.leave();
        return res;
    }
}

