/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.priority;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.daisy.common.priority.UpdatablePriorityBlockingQueue;
import org.daisy.common.priority.timetracking.TimeTracker;
import org.daisy.common.priority.timetracking.TimeTrackerFactory;

public class PriorityThreadPoolExecutor<T>
extends ThreadPoolExecutor {
    private TimeTracker<T> tracker;

    PriorityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, UpdatablePriorityBlockingQueue<T> workQueue, TimeTracker<T> tracker) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)((Object)workQueue));
        this.tracker = tracker;
    }

    public static <T> PriorityThreadPoolExecutor<T> newFixedSizeThreadPoolExecutor(int poolSize, TimeTrackerFactory trackerFactory) {
        UpdatablePriorityBlockingQueue queue = new UpdatablePriorityBlockingQueue();
        TimeTracker tracker = trackerFactory.newTimeTracker(queue);
        return new PriorityThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MICROSECONDS, queue, tracker);
    }

    @Override
    public void execute(Runnable runnable) {
        super.execute(runnable);
        this.tracker.executing();
    }

    public UpdatablePriorityBlockingQueue<T> getUpdatableQueue() {
        return (UpdatablePriorityBlockingQueue)((Object)this.getQueue());
    }
}

