/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.messaging;

import java.util.Date;

public class Message {
    protected Throwable throwable;
    protected String text;
    protected Level level;
    protected int line;
    protected int column;
    protected Date timeStamp;
    protected int sequence;
    protected String jobId;
    protected String file;

    protected Message(Throwable throwable, String text, Level level, int line, int column, Date timeStamp, int sequence, String jobId, String file) {
        this.throwable = throwable;
        this.text = text;
        this.level = level;
        this.line = line;
        this.column = column;
        this.timeStamp = timeStamp;
        this.sequence = sequence;
        this.jobId = jobId;
        this.file = file;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getText() {
        return this.text;
    }

    public Level getLevel() {
        return this.level;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getFile() {
        return this.file;
    }

    public static class MessageBuilder {
        Throwable throwable;
        String text;
        Level level;
        int line;
        int column;
        Date timeStamp;
        int sequence;
        String jobId;
        String file;

        public MessageBuilder withThrowable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        public MessageBuilder withText(String text) {
            this.text = text;
            return this;
        }

        public MessageBuilder withLevel(Level level) {
            this.level = level;
            return this;
        }

        public MessageBuilder withLine(int line) {
            this.line = line;
            return this;
        }

        public MessageBuilder withColumn(int column) {
            this.column = column;
            return this;
        }

        public MessageBuilder withTimeStamp(Date timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public MessageBuilder withSequence(int sequence) {
            this.sequence = sequence;
            return this;
        }

        public MessageBuilder withJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public MessageBuilder withFile(String file) {
            this.file = file;
            return this;
        }

        public Message build() {
            return new Message(this.throwable, this.text, this.level, this.line, this.column, this.timeStamp, this.sequence, this.jobId, this.file);
        }
    }

    public static enum Level {
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        TRACE;

    }
}

