/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.fuzzy;

import com.google.common.primitives.Doubles;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.daisy.common.fuzzy.FuzzySet;
import org.daisy.common.fuzzy.FuzzyVariable;

public class InferenceEngine {
    private List<FuzzyVariable> variables = new LinkedList<FuzzyVariable>();

    public InferenceEngine add(FuzzyVariable set) {
        this.variables.add(set);
        return this;
    }

    public double getScore(double ... crispValues) {
        List crispCol = Doubles.asList((double[])crispValues);
        if (crispCol.size() != this.variables.size()) {
            throw new IllegalArgumentException(String.format("The size of crisp values is different from the ammount of variables %s != %s", crispCol.size(), this.variables.size()));
        }
        double denominator = 0.0;
        double numerator = 0.0;
        Iterator crispIter = crispCol.iterator();
        Iterator<FuzzyVariable> variableIter = this.variables.iterator();
        while (crispIter.hasNext()) {
            FuzzyVariable var = variableIter.next();
            double x = (Double)crispIter.next();
            for (FuzzySet set : var.getSets()) {
                double memebership = (Double)set.getMembership().apply((Object)x);
                numerator += memebership * set.getWeight();
                denominator += memebership;
            }
        }
        return numerator / denominator;
    }
}

