/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.daisy.pipeline.client.Pipeline2Exception;
import org.daisy.pipeline.client.utils.NamespaceContextMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPath {
    public static final Map<String, String> dp2ns;
    private static Map<String, XPathExpression> expressions;
    public Map<String, String> namespaces = new HashMap<String, String>();
    private static NamespaceContextMap nsContext;

    private XPath() {
    }

    private static XPathExpression xpath(String expression, Map<String, String> ns) throws XPathExpressionException {
        XPath.updateNs(ns);
        if (expressions.containsKey(expression)) {
            return expressions.get(expression);
        }
        javax.xml.xpath.XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsContext);
        XPathExpression compiledExpression = xpath.compile(expression);
        expressions.put(expression, compiledExpression);
        return compiledExpression;
    }

    private static void updateNs(Map<String, String> ns) {
        boolean equals;
        boolean bl = equals = ns.size() == nsContext.getMap().size() - 2;
        if (equals) {
            for (String prefix : ns.keySet()) {
                if (nsContext.getMap().containsKey(prefix) && nsContext.getMap().get(prefix).equals(ns.get(prefix))) continue;
                equals = false;
                break;
            }
        }
        if (!equals) {
            nsContext = new NamespaceContextMap(ns);
            expressions.clear();
        }
    }

    public static List<Node> selectNodes(String expr, Node doc, Map<String, String> ns) throws Pipeline2Exception {
        if (doc == null || expr == null) {
            return new ArrayList<Node>();
        }
        try {
            NodeList nodeList = (NodeList)XPath.xpath(expr, ns).evaluate(doc, XPathConstants.NODESET);
            ArrayList<Node> result = new ArrayList<Node>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                result.add(nodeList.item(i));
            }
            return result;
        }
        catch (XPathExpressionException e) {
            throw new Pipeline2Exception(e);
        }
    }

    public static String selectText(String expr, Node doc, Map<String, String> ns) throws Pipeline2Exception {
        if (doc == null || expr == null) {
            return null;
        }
        try {
            if (((NodeList)XPath.xpath(expr, ns).evaluate(doc, XPathConstants.NODESET)).getLength() == 0) {
                return null;
            }
            String nodeText = (String)XPath.xpath(expr, ns).evaluate(doc, XPathConstants.STRING);
            return nodeText;
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new Pipeline2Exception(e);
        }
    }

    public static Node selectNode(String expr, Node doc, Map<String, String> ns) throws Pipeline2Exception {
        if (doc == null || expr == null) {
            return null;
        }
        try {
            NodeList nodeList = (NodeList)XPath.xpath(expr, ns).evaluate(doc, XPathConstants.NODESET);
            if (nodeList.getLength() == 0) {
                return null;
            }
            return nodeList.item(0);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new Pipeline2Exception(e);
        }
    }

    static {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        nsMap.put("d", "http://www.daisy.org/ns/pipeline/data");
        dp2ns = Collections.unmodifiableMap(nsMap);
        expressions = new HashMap<String, XPathExpression>();
        nsContext = new NamespaceContextMap(new String[0]);
    }
}

