/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.daisy.pipeline.client.Pipeline2Exception;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.utils.Files;
import org.daisy.pipeline.client.utils.XML;
import org.daisy.pipeline.client.utils.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Result
implements Comparable<Result> {
    public String href;
    public String file;
    public String mimeType;
    public String name;
    public String from;
    public String nicename;
    public Long size;
    public String filename;
    public String prettyRelativeHref;
    public String relativeHref;
    private static Pattern filenamePattern = Pattern.compile(".*/");
    private static Pattern idxPattern = Pattern.compile("^/?idx/[^/]+/");
    private static Pattern relativeHrefPattern = Pattern.compile("^.*?/jobs/[^/]+/result(.*)$");

    public static Result parseResultXml(Node resultNode) throws Pipeline2Exception {
        String parentHref = XPath.selectText("../@href", resultNode, XPath.dp2ns);
        return Result.parseResultXml(resultNode, parentHref);
    }

    public static Result parseResultXml(Node resultNode, String base) throws Pipeline2Exception {
        String sizeText;
        Matcher prettyRelativeHrefMatcher;
        Result item = new Result();
        item.href = XPath.selectText("@href", resultNode, XPath.dp2ns);
        item.file = XPath.selectText("@file", resultNode, XPath.dp2ns);
        item.mimeType = XPath.selectText("@mime-type", resultNode, XPath.dp2ns);
        item.name = XPath.selectText("@name", resultNode, XPath.dp2ns);
        item.from = XPath.selectText("@from", resultNode, XPath.dp2ns);
        item.nicename = XPath.selectText("@nicename", resultNode, XPath.dp2ns);
        if ("results".equals(resultNode.getNodeName())) {
            item.filename = "results.zip";
        } else if (item.from != null && !"".equals(item.from)) {
            item.filename = (item.name != null && !"".equals(item.name) ? item.name : item.from) + ".zip";
        } else {
            String string = item.filename = item.href == null ? null : filenamePattern.matcher(item.href).replaceAll("");
        }
        if (base != null) {
            if (base.length() >= item.href.length()) {
                item.prettyRelativeHref = "";
            } else {
                item.prettyRelativeHref = item.href == null ? null : item.href.substring(base.length() + 1);
                Matcher m = idxPattern.matcher(item.prettyRelativeHref);
                item.prettyRelativeHref = m.replaceFirst("");
            }
        }
        if ((prettyRelativeHrefMatcher = relativeHrefPattern.matcher(item.href)).matches()) {
            item.relativeHref = prettyRelativeHrefMatcher.group(1);
            if (item.relativeHref.length() > 0) {
                item.relativeHref = item.relativeHref.substring(1);
            }
        }
        if ((sizeText = XPath.selectText("@size", resultNode, XPath.dp2ns)) != null && sizeText.length() > 0) {
            item.size = Long.parseLong(sizeText);
        } else {
            item.size = 0L;
            List<Node> leafNodes = XPath.selectNodes(".//d:result[not(*)]", resultNode, XPath.dp2ns);
            for (Node leafNode : leafNodes) {
                String childSize = XPath.selectText("@size", leafNode, XPath.dp2ns);
                Result result = item;
                Long.valueOf(result.size + (childSize == null ? 0L : Long.parseLong(childSize)));
                result.size = result.size;
            }
        }
        return item;
    }

    @Override
    public int compareTo(Result other) {
        return this.href.compareTo(other.href);
    }

    public void toXml(Element resultElement) {
        if (this.href != null) {
            resultElement.setAttribute("href", this.href);
        }
        if (this.file != null) {
            resultElement.setAttribute("file", this.file);
        }
        if (this.mimeType != null) {
            resultElement.setAttribute("mime-type", this.mimeType);
        }
        if (this.name != null) {
            resultElement.setAttribute("name", this.name);
        }
        if (this.from != null) {
            resultElement.setAttribute("from", this.from);
        }
        if (this.size != null) {
            resultElement.setAttribute("size", this.size + "");
        }
    }

    public File asFile() {
        if (this.file == null) {
            return null;
        }
        try {
            URI fileUri = new URI(this.file);
            File f = new File(fileUri);
            if (f.isFile()) {
                return f;
            }
            return null;
        }
        catch (URISyntaxException e) {
            Pipeline2Logger.logger().error("Could not parse file: URL", e);
            return null;
        }
    }

    public String asText() {
        File f = this.asFile();
        if (f == null) {
            return null;
        }
        return Files.read(f);
    }

    public Document asXml() {
        String text = this.asText();
        if (text == null) {
            return null;
        }
        return XML.getXml(text);
    }
}

