/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.utils.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JobSizes {
    public String href;
    public Long total;
    public Map<String, JobSize> jobSizes = new HashMap<String, JobSize>();

    public JobSizes(Node jobSizesNode) {
        try {
            if (jobSizesNode instanceof Document) {
                jobSizesNode = XPath.selectNode("/d:jobs", jobSizesNode, XPath.dp2ns);
            }
            this.href = XPath.selectText("@href", jobSizesNode, XPath.dp2ns);
            this.total = Long.valueOf(XPath.selectText("@total", jobSizesNode, XPath.dp2ns));
            List<Node> jobSizeNodes = XPath.selectNodes("d:job", jobSizesNode, XPath.dp2ns);
            for (Node jobSizeNode : jobSizeNodes) {
                JobSize jobSize = new JobSize();
                jobSize.id = XPath.selectText("@id", jobSizeNode, XPath.dp2ns);
                jobSize.context = Long.valueOf(XPath.selectText("@context", jobSizeNode, XPath.dp2ns));
                jobSize.log = Long.valueOf(XPath.selectText("@log", jobSizeNode, XPath.dp2ns));
                jobSize.output = Long.valueOf(XPath.selectText("@output", jobSizeNode, XPath.dp2ns));
                this.jobSizes.put(jobSize.id, jobSize);
            }
        }
        catch (Exception e) {
            Pipeline2Logger.logger().error("Failed to parse the job sizes XML", e);
        }
    }

    public class JobSize {
        public String id;
        public Long context;
        public Long log;
        public Long output;
    }
}

