/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.client.models;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.daisy.pipeline.client.Pipeline2Exception;
import org.daisy.pipeline.client.Pipeline2Logger;
import org.daisy.pipeline.client.filestorage.JobStorage;
import org.daisy.pipeline.client.utils.XML;
import org.daisy.pipeline.client.utils.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Argument {
    private String name;
    private String nicename;
    private String desc;
    private Boolean required;
    private Boolean sequence;
    private List<String> mediaTypes;
    private Output output;
    private Kind kind;
    private Boolean ordered;
    private String type;
    private String defaultValue;
    private Node argumentNode;
    private boolean lazyLoaded = false;
    private List<String> values = null;

    public Argument(Node argumentNode) throws Pipeline2Exception {
        this.argumentNode = argumentNode;
    }

    private void lazyLoad() {
        if (!this.lazyLoaded && this.argumentNode != null) {
            try {
                this.name = Argument.parseTypeString(XPath.selectText("@name", this.argumentNode, XPath.dp2ns));
                this.nicename = Argument.parseTypeString(XPath.selectText("@nicename", this.argumentNode, XPath.dp2ns));
                if (this.nicename == null || "".equals(this.nicename)) {
                    this.nicename = this.name;
                }
                this.desc = XPath.selectText("@desc", this.argumentNode, XPath.dp2ns);
                if (this.desc == null) {
                    this.desc = "";
                }
                this.required = Argument.parseTypeBoolean(XPath.selectText("@required", this.argumentNode, XPath.dp2ns));
                if (this.required == null) {
                    this.required = true;
                }
                this.sequence = Argument.parseTypeBoolean(XPath.selectText("@sequence", this.argumentNode, XPath.dp2ns));
                if (this.sequence == null) {
                    this.sequence = false;
                }
                this.mediaTypes = Argument.parseTypeMediaTypes(XPath.selectText("@mediaType", this.argumentNode, XPath.dp2ns));
                try {
                    this.output = Output.valueOf(Argument.parseTypeString(XPath.selectText("@outputType", this.argumentNode, XPath.dp2ns)));
                }
                catch (IllegalArgumentException e) {
                    this.kind = null;
                }
                catch (NullPointerException e) {
                    this.kind = null;
                }
                try {
                    this.kind = Kind.valueOf(this.argumentNode.getLocalName());
                }
                catch (IllegalArgumentException e) {
                    this.kind = null;
                }
                catch (NullPointerException e) {
                    this.kind = null;
                }
                this.ordered = Argument.parseTypeBoolean(XPath.selectText("@ordered", this.argumentNode, XPath.dp2ns));
                if (this.ordered == null) {
                    this.ordered = true;
                }
                this.type = Argument.parseTypeString(XPath.selectText("@type", this.argumentNode, XPath.dp2ns));
                if (this.type == null) {
                    this.type = "string";
                }
                if (this.kind == Kind.input || this.kind == Kind.output) {
                    this.type = "anyFileURI";
                    if (this.sequence.booleanValue() && Argument.parseTypeBoolean(XPath.selectText("@required", this.argumentNode, XPath.dp2ns)) == null) {
                        this.required = false;
                    }
                    if (this.mediaTypes.size() == 0) {
                        this.mediaTypes.add("application/xml");
                    }
                }
                if (this.kind == Kind.output && this.output == null) {
                    this.output = Output.result;
                }
                this.defaultValue = XPath.selectText("@default", this.argumentNode, XPath.dp2ns);
                List<Node> valueNodes = XPath.selectNodes("d:item", this.argumentNode, XPath.dp2ns);
                if (valueNodes.isEmpty()) {
                    String value = XPath.selectText("text()", this.argumentNode, XPath.dp2ns);
                    if (value != null && !"".equals(value)) {
                        this.values = new ArrayList<String>();
                        this.values.add(this.normalizeValue(value));
                    }
                } else {
                    this.values = new ArrayList<String>();
                    for (Node valueNode : valueNodes) {
                        String value = XPath.selectText("@value", valueNode, XPath.dp2ns);
                        this.values.add(this.normalizeValue(value));
                    }
                }
            }
            catch (Pipeline2Exception e) {
                Pipeline2Logger.logger().error("Failed to parse argument node", e);
            }
            this.lazyLoaded = true;
        }
    }

    private String normalizeValue(String value) {
        if (this.type == null || value == null) {
            return null;
        }
        switch (this.type) {
            case "anyFileURI": 
            case "anyDirURI": 
            case "anyURI": {
                try {
                    URI uri = new URI(value);
                    uri = uri.normalize();
                    value = uri.toString();
                }
                catch (URISyntaxException e) {
                    Pipeline2Logger.logger().warn("Unable to parse URI", e);
                }
                break;
            }
            case "boolean": {
                value = value.toLowerCase();
            }
        }
        return value;
    }

    private static String parseTypeString(String string) {
        if (!(string instanceof String)) {
            return null;
        }
        if ("".equals(string = string.replaceAll("\"", "'").replaceAll("\\n", " "))) {
            return null;
        }
        return string;
    }

    private static Boolean parseTypeBoolean(String bool) {
        if (!(bool instanceof String)) {
            return null;
        }
        if ("false".equals(bool)) {
            return false;
        }
        if ("true".equals(bool)) {
            return true;
        }
        return null;
    }

    private static List<String> parseTypeMediaTypes(String mediaTypesString) {
        if (!(mediaTypesString instanceof String)) {
            return new ArrayList<String>();
        }
        String[] mediaTypes = ((mediaTypesString = Argument.parseTypeString(mediaTypesString)) == null ? "" : mediaTypesString).split(" ");
        ArrayList<String> mediaTypesList = new ArrayList<String>();
        for (String mediaType : mediaTypes) {
            if ("".equals(mediaType)) continue;
            if ("text/xml".equals(mediaType)) {
                mediaTypesList.add("application/xml");
                continue;
            }
            mediaTypesList.add(mediaType);
        }
        return mediaTypesList;
    }

    public int size() {
        this.lazyLoad();
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    public void unset() {
        this.lazyLoad();
        if (this.values != null) {
            this.values.clear();
        }
        this.values = null;
    }

    public boolean isDefined() {
        this.lazyLoad();
        return this.values != null;
    }

    public void clear() {
        this.lazyLoad();
        if (this.values == null) {
            this.values = new ArrayList<String>();
        } else {
            this.values.clear();
        }
    }

    public void set(int position, Integer value) {
        if (value == null) {
            this.clear();
        } else {
            this.set(position, value + "");
        }
    }

    public void set(int position, Long value) {
        if (value == null) {
            this.clear();
        } else {
            this.set(position, value + "");
        }
    }

    public void set(int position, Double value) {
        if (value == null) {
            this.clear();
        } else {
            this.set(position, value + "");
        }
    }

    public void set(int position, Boolean value) {
        if (value == null) {
            this.clear();
        } else {
            this.set(position, value + "");
        }
    }

    public void set(int position, File file, JobStorage context) {
        if (file == null) {
            this.clear();
        } else {
            context.addContextFile(file, file.getName());
            this.set(position, context.getContextFilePath(file));
        }
    }

    public void set(int position, String value) {
        if (value == null) {
            this.clear();
        } else {
            this.lazyLoad();
            if (this.values != null && this.values.size() > position) {
                this.values.set(position, value);
            }
        }
    }

    public void set(Integer value) {
        if (value == null) {
            this.clear();
        } else {
            this.set(value + "");
        }
    }

    public void set(Long value) {
        if (value == null) {
            this.clear();
        } else {
            this.set(value + "");
        }
    }

    public void set(Double value) {
        if (value == null) {
            this.clear();
        } else {
            this.set(value + "");
        }
    }

    public void set(Boolean value) {
        if (value == null) {
            this.clear();
        } else {
            this.set(value + "");
        }
    }

    public void set(File file, JobStorage context) {
        if (file == null) {
            this.clear();
        } else if (this.getOutput() != null) {
            this.set(file.toURI().toString());
        } else {
            context.addContextFile(file, file.getName());
            this.set(context.getContextFilePath(file));
        }
    }

    public void set(String value) {
        this.clear();
        if (value != null) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            this.values.add(this.normalizeValue(value));
        }
    }

    public void setAll(Collection<String> values) {
        this.clear();
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String value : values) {
            this.values.add(this.normalizeValue(value));
        }
    }

    public void add(Integer value) {
        if (value != null) {
            this.add(value + "");
        }
    }

    public void add(Long value) {
        if (value != null) {
            this.add(value + "");
        }
    }

    public void add(Double value) {
        if (value != null) {
            this.add(value + "");
        }
    }

    public void add(Boolean value) {
        if (value != null) {
            this.add(value + "");
        }
    }

    public void add(File file, JobStorage context) {
        if (file != null) {
            this.lazyLoad();
            context.addContextFile(file, file.getName());
            this.add(context.getContextFilePath(file));
        }
    }

    public void add(String value) {
        if (value != null) {
            this.lazyLoad();
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            this.values.add(this.normalizeValue(value));
        }
    }

    public void addAll(Collection<String> values) {
        if (values != null) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            for (String value : values) {
                values.add(this.normalizeValue(value));
            }
        }
    }

    public void remove(Integer value) {
        if (value != null) {
            this.remove(value + "");
        }
    }

    public void remove(Long value) {
        if (value != null) {
            this.remove(value + "");
        }
    }

    public void remove(Double value) {
        if (value != null) {
            this.remove(value + "");
        }
    }

    public void remove(Boolean value) {
        if (value != null) {
            this.remove(value + "");
        }
    }

    public void remove(File file, JobStorage context) {
        if (file != null) {
            this.remove(context.getContextFilePath(file));
        }
    }

    public void remove(String value) {
        if (value != null && this.values != null) {
            for (int i = this.values.size() - 1; i >= 0; --i) {
                if (!value.equals(this.values.get(i))) continue;
                this.values.remove(i);
            }
        }
    }

    public void removeAll(Collection<String> values) {
        if (values != null && this.values != null) {
            this.values.removeAll(values);
        }
    }

    public Integer getAsInteger() {
        this.lazyLoad();
        try {
            return Integer.parseInt(this.get());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getAsLong() {
        this.lazyLoad();
        try {
            return Long.parseLong(this.get());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Double getAsDouble() {
        this.lazyLoad();
        try {
            return Double.parseDouble(this.get());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean getAsBoolean() {
        this.lazyLoad();
        String value = this.get();
        if (value != null && ("true".equals(value.toLowerCase()) || "false".equals(value.toLowerCase()))) {
            return Boolean.parseBoolean(this.get());
        }
        return null;
    }

    public File getAsFile(JobStorage context) {
        this.lazyLoad();
        if (this.values == null || this.values.size() == 0) {
            return null;
        }
        return context.getContextFile(this.values.get(0));
    }

    public String get() {
        this.lazyLoad();
        if (this.values == null || this.values.size() == 0) {
            return null;
        }
        return this.values.get(0);
    }

    public List<String> getAsList() {
        this.lazyLoad();
        return this.values;
    }

    public List<File> getAsFileList(JobStorage context) {
        this.lazyLoad();
        if (this.values != null) {
            ArrayList<File> contextFiles = new ArrayList<File>();
            assert (contextFiles != null);
            for (String value : this.values) {
                File contextFile = context.getContextFile(value);
                contextFiles.add(contextFile);
            }
            return contextFiles;
        }
        return null;
    }

    public void moveTo(int from, int to) {
        this.lazyLoad();
        if (this.values == null) {
            return;
        }
        if (from < 0 || from >= this.values.size()) {
            return;
        }
        if (to < 0 || to >= this.values.size()) {
            return;
        }
        int shiftDistance = -1;
        if (from > to) {
            int rememberMe = from;
            from = to;
            to = rememberMe;
            shiftDistance = 1;
        }
        Collections.rotate(this.values.subList(from, to + 1), shiftDistance);
    }

    public Integer getDefaultValueAsInteger() {
        this.lazyLoad();
        try {
            return Integer.parseInt(this.getDefaultValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getDefaultValueAsLong() {
        this.lazyLoad();
        try {
            return Long.parseLong(this.getDefaultValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Double getDefaultValueAsDouble() {
        this.lazyLoad();
        try {
            return Double.parseDouble(this.getDefaultValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean getDefaultValueAsBoolean() {
        this.lazyLoad();
        String value = this.getDefaultValue();
        if (value != null && ("true".equals(value.toLowerCase()) || "false".equals(value.toLowerCase()))) {
            return Boolean.parseBoolean(this.getDefaultValue());
        }
        return null;
    }

    public File getDefaultValueAsFile(JobStorage context) {
        this.lazyLoad();
        String value = this.getDefaultValue();
        if (value == null) {
            return null;
        }
        return context.getContextFile(value);
    }

    public String getDefaultValue() {
        this.lazyLoad();
        return this.defaultValue;
    }

    public String getName() {
        this.lazyLoad();
        return this.name;
    }

    public String getNicename() {
        this.lazyLoad();
        return this.nicename;
    }

    public String getDesc() {
        this.lazyLoad();
        return this.desc;
    }

    public Boolean getRequired() {
        this.lazyLoad();
        return this.required;
    }

    public Boolean getSequence() {
        this.lazyLoad();
        return this.sequence;
    }

    public List<String> getMediaTypes() {
        this.lazyLoad();
        return this.mediaTypes;
    }

    public Output getOutput() {
        this.lazyLoad();
        return this.output;
    }

    public Kind getKind() {
        this.lazyLoad();
        return this.kind;
    }

    public Boolean getOrdered() {
        this.lazyLoad();
        return this.ordered;
    }

    public String getType() {
        this.lazyLoad();
        return this.type;
    }

    public void setName(String name) {
        this.lazyLoad();
        this.name = name;
    }

    public void setNicename(String nicename) {
        this.lazyLoad();
        this.nicename = nicename;
    }

    public void setDesc(String desc) {
        this.lazyLoad();
        this.desc = desc;
    }

    public void setRequired(Boolean required) {
        this.lazyLoad();
        this.required = required;
    }

    public void setSequence(Boolean sequence) {
        this.lazyLoad();
        this.sequence = sequence;
    }

    public void setMediaTypes(List<String> mediaTypes) {
        this.lazyLoad();
        this.mediaTypes = mediaTypes;
    }

    public void setOutput(Output output) {
        this.lazyLoad();
        this.output = output;
    }

    public void setKind(Kind kind) {
        this.lazyLoad();
        this.kind = kind;
    }

    public void setOrdered(Boolean ordered) {
        this.lazyLoad();
        this.ordered = ordered;
    }

    public void setType(String type) {
        this.lazyLoad();
        this.type = type;
    }

    public Document toXml() {
        this.lazyLoad();
        Document argDoc = XML.getXml("<" + (Object)((Object)this.kind) + " xmlns=\"http://www.daisy.org/ns/pipeline/data\"/>");
        Element argElem = argDoc.getDocumentElement();
        if (this.name != null) {
            argElem.setAttribute("name", this.name);
        }
        if (this.nicename != null) {
            argElem.setAttribute("nicename", this.nicename);
        }
        if (this.desc != null) {
            argElem.setAttribute("desc", this.desc);
        }
        if (this.required != null) {
            argElem.setAttribute("required", this.required + "");
        }
        if (this.sequence != null) {
            argElem.setAttribute("sequence", this.sequence + "");
        }
        if (this.mediaTypes != null) {
            String mediaTypesJoined = "";
            for (int i = 0; i < this.mediaTypes.size(); ++i) {
                if (i > 0) {
                    mediaTypesJoined = mediaTypesJoined + " ";
                }
                mediaTypesJoined = mediaTypesJoined + this.mediaTypes.get(i);
            }
            argElem.setAttribute("mediaType", mediaTypesJoined);
        }
        if (this.output != null) {
            argElem.setAttribute("outputType", (Object)((Object)this.output) + "");
        }
        if (this.ordered != null) {
            argElem.setAttribute("ordered", this.ordered + "");
        }
        if (this.type != null) {
            argElem.setAttribute("type", this.type);
        }
        if (this.values != null) {
            if (this.values.size() == 1 && this.values.get(0).length() > 0 && !this.sequence.booleanValue()) {
                argElem.setTextContent(this.values.get(0));
            } else {
                for (String value : this.values) {
                    Element item = argDoc.createElementNS(XPath.dp2ns.get("d"), "item");
                    item.setAttribute("value", value);
                    argElem.appendChild(item);
                }
            }
        }
        return argDoc;
    }

    public static enum Kind {
        input,
        option,
        output;

    }

    public static enum Output {
        result,
        temp;

    }
}

