/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.cyclonedx.model.formulation.common.OutputType;
import org.cyclonedx.util.serializer.AbstractDataTypeSerializer;

public class OutputTypeSerializer
extends AbstractDataTypeSerializer<OutputType> {
    private final boolean isXml;

    public OutputTypeSerializer(boolean isXml) {
        this(null, isXml);
    }

    public OutputTypeSerializer(Class<OutputType> t, boolean isXml) {
        super(t);
        this.isXml = isXml;
    }

    public void serialize(OutputType value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            xmlGenerator.writeStartObject();
            xmlGenerator.writeFieldName("input");
            this.createOutputChoice(value, (JsonGenerator)xmlGenerator);
            xmlGenerator.writeEndObject();
        } else {
            this.createOutputChoice(value, jsonGenerator);
        }
    }

    private void createOutputChoice(OutputType output, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        if (output.getResource() != null) {
            jsonGenerator.writeFieldName("resource");
            jsonGenerator.writeObject((Object)output.getResource());
        } else if (output.getEnvironmentVars() != null && !output.getEnvironmentVars().isEmpty()) {
            this.parseEnvironmentVars(jsonGenerator, output.getEnvironmentVars());
        } else if (output.getData() != null) {
            jsonGenerator.writeFieldName("data");
            jsonGenerator.writeObject((Object)output.getData());
        }
        this.writeField(jsonGenerator, "type", (Object)output.getType());
        this.writeField(jsonGenerator, "source", output.getSource());
        this.writeField(jsonGenerator, "target", output.getTarget());
        this.writeField(jsonGenerator, "properties", output.getProperties());
        jsonGenerator.writeEndObject();
    }

    public Class<OutputType> handledType() {
        return OutputType.class;
    }
}

