/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.cyclonedx.Version;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.VersionFilter;

public class HashSerializer
extends StdSerializer<Hash> {
    private final Version version;

    public HashSerializer(Version version) {
        this(Hash.class, version);
    }

    public HashSerializer(Class<Hash> t, Version version) {
        super(t);
        this.version = version;
    }

    public void serialize(Hash hash, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (!this.shouldSerializeField(hash.getAlgorithm())) {
            return;
        }
        if (gen instanceof ToXmlGenerator) {
            this.serializeXml((ToXmlGenerator)gen, hash);
        } else {
            this.serializeJson(gen, hash);
        }
    }

    private void serializeXml(ToXmlGenerator toXmlGenerator, Hash hash) throws IOException {
        toXmlGenerator.writeStartObject();
        toXmlGenerator.setNextIsAttribute(true);
        toXmlGenerator.writeFieldName("alg");
        toXmlGenerator.writeString(hash.getAlgorithm());
        toXmlGenerator.setNextIsAttribute(false);
        toXmlGenerator.setNextIsUnwrapped(true);
        toXmlGenerator.writeStringField("", hash.getValue());
        toXmlGenerator.writeEndObject();
    }

    private void serializeJson(JsonGenerator gen, Hash hash) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("alg", hash.getAlgorithm());
        gen.writeStringField("content", hash.getValue());
        gen.writeEndObject();
    }

    public Class<Hash> handledType() {
        return Hash.class;
    }

    private boolean shouldSerializeField(String value) {
        try {
            Hash.Algorithm algorithm = Hash.Algorithm.fromSpec(value);
            VersionFilter filter = ((Object)((Object)algorithm)).getClass().getField(algorithm.name()).getAnnotation(VersionFilter.class);
            return filter == null || filter.value().getVersion() <= this.version.getVersion();
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }
}

