/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.util.function.BiPredicate;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclonedx.Version;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.util.BomUtils;

public class ExternalReferenceSerializer
extends StdSerializer<ExternalReference> {
    private final Version version;

    public ExternalReferenceSerializer(Version version) {
        this(null, version);
    }

    public ExternalReferenceSerializer(Class<ExternalReference> t, Version version) {
        super(t);
        this.version = version;
    }

    public void serialize(ExternalReference extRef, JsonGenerator gen, SerializerProvider provider) throws IOException {
        BiPredicate<ExternalReference.Type, String> validateExternalReference = (type, url) -> type != null && url != null && BomUtils.validateUriString(url);
        if (!validateExternalReference.test(extRef.getType(), extRef.getUrl())) {
            return;
        }
        if (!this.shouldSerializeField((Object)extRef.getType())) {
            return;
        }
        if (gen instanceof ToXmlGenerator) {
            this.serializeXml((ToXmlGenerator)gen, extRef);
        } else {
            this.serializeJson(gen, extRef);
        }
    }

    private void serializeXml(ToXmlGenerator toXmlGenerator, ExternalReference extRef) throws IOException {
        toXmlGenerator.writeStartObject();
        toXmlGenerator.setNextIsAttribute(true);
        toXmlGenerator.writeFieldName("type");
        toXmlGenerator.writeString(extRef.getType().getTypeName());
        toXmlGenerator.setNextIsAttribute(false);
        toXmlGenerator.writeStringField("url", extRef.getUrl());
        if (extRef.getComment() != null) {
            toXmlGenerator.writeStringField("comment", extRef.getComment());
        }
        if (CollectionUtils.isNotEmpty(extRef.getHashes())) {
            toXmlGenerator.writeFieldName("hashes");
            toXmlGenerator.writeStartObject();
            for (Hash hash : extRef.getHashes()) {
                toXmlGenerator.writeFieldName("hash");
                toXmlGenerator.writeStartObject();
                toXmlGenerator.setNextIsAttribute(true);
                toXmlGenerator.writeFieldName("alg");
                toXmlGenerator.writeString(hash.getAlgorithm());
                toXmlGenerator.setNextIsAttribute(false);
                toXmlGenerator.setNextIsUnwrapped(true);
                toXmlGenerator.writeStringField("", hash.getValue());
                toXmlGenerator.writeEndObject();
            }
            toXmlGenerator.writeEndObject();
        }
        toXmlGenerator.writeEndObject();
    }

    private void serializeJson(JsonGenerator gen, ExternalReference extRef) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("type", extRef.getType().getTypeName());
        gen.writeStringField("url", extRef.getUrl());
        if (extRef.getComment() != null) {
            gen.writeStringField("comment", extRef.getComment());
        }
        if (CollectionUtils.isNotEmpty(extRef.getHashes())) {
            gen.writeFieldName("hashes");
            gen.writeStartArray();
            for (Hash hash : extRef.getHashes()) {
                gen.writeStartObject();
                gen.writeStringField("alg", hash.getAlgorithm());
                gen.writeStringField("content", hash.getValue());
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }

    private boolean shouldSerializeField(Object obj) {
        try {
            if (obj instanceof ExternalReference.Type) {
                ExternalReference.Type type = (ExternalReference.Type)((Object)obj);
                VersionFilter filter = ((Object)((Object)type)).getClass().getField(type.name()).getAnnotation(VersionFilter.class);
                return filter == null || filter.value().getVersion() <= this.version.getVersion();
            }
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public Class<ExternalReference> handledType() {
        return ExternalReference.class;
    }
}

