/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model.component.crypto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.component.crypto.enums.CertificationLevel;
import org.cyclonedx.model.component.crypto.enums.CryptoFunction;
import org.cyclonedx.model.component.crypto.enums.ExecutionEnvironment;
import org.cyclonedx.model.component.crypto.enums.ImplementationPlatform;
import org.cyclonedx.model.component.crypto.enums.Mode;
import org.cyclonedx.model.component.crypto.enums.Padding;
import org.cyclonedx.model.component.crypto.enums.Primitive;
import org.cyclonedx.util.deserializer.CertificationLevelDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"primitive", "parameterSetIdentifier", "curve", "executionEnvironment", "implementationPlatform", "certificationLevel", "mode", "padding", "cryptoFunctions", "classicalSecurityLevel", "nistQuantumSecurityLevel"})
public class AlgorithmProperties {
    private Primitive primitive;
    private String parameterSetIdentifier;
    private String curve;
    private ExecutionEnvironment executionEnvironment;
    private ImplementationPlatform implementationPlatform;
    @JsonDeserialize(using=CertificationLevelDeserializer.class)
    private CertificationLevel certificationLevel;
    private Mode mode;
    private Padding padding;
    private List<CryptoFunction> cryptoFunctions;
    private Integer classicalSecurityLevel;
    private Integer nistQuantumSecurityLevel;

    public Primitive getPrimitive() {
        return this.primitive;
    }

    public void setPrimitive(Primitive primitive) {
        this.primitive = primitive;
    }

    public String getParameterSetIdentifier() {
        return this.parameterSetIdentifier;
    }

    public void setParameterSetIdentifier(String parameterSetIdentifier) {
        this.parameterSetIdentifier = parameterSetIdentifier;
    }

    public String getCurve() {
        return this.curve;
    }

    public void setCurve(String curve) {
        this.curve = curve;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(ExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public ImplementationPlatform getImplementationPlatform() {
        return this.implementationPlatform;
    }

    public void setImplementationPlatform(ImplementationPlatform implementationPlatform) {
        this.implementationPlatform = implementationPlatform;
    }

    public CertificationLevel getCertificationLevel() {
        return this.certificationLevel;
    }

    public void setCertificationLevel(CertificationLevel certificationLevel) {
        this.certificationLevel = certificationLevel;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Padding getPadding() {
        return this.padding;
    }

    public void setPadding(Padding padding) {
        this.padding = padding;
    }

    @JacksonXmlElementWrapper(localName="cryptoFunctions")
    @JacksonXmlProperty(localName="cryptoFunction")
    public List<CryptoFunction> getCryptoFunctions() {
        return this.cryptoFunctions;
    }

    public void setCryptoFunctions(List<CryptoFunction> cryptoFunctions) {
        this.cryptoFunctions = cryptoFunctions;
    }

    public Integer getClassicalSecurityLevel() {
        return this.classicalSecurityLevel;
    }

    public void setClassicalSecurityLevel(Integer classicalSecurityLevel) {
        this.classicalSecurityLevel = classicalSecurityLevel;
    }

    public Integer getNistQuantumSecurityLevel() {
        return this.nistQuantumSecurityLevel;
    }

    public void setNistQuantumSecurityLevel(Integer nistQuantumSecurityLevel) {
        this.nistQuantumSecurityLevel = nistQuantumSecurityLevel;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AlgorithmProperties)) {
            return false;
        }
        AlgorithmProperties that = (AlgorithmProperties)object;
        return this.primitive == that.primitive && Objects.equals(this.parameterSetIdentifier, that.parameterSetIdentifier) && Objects.equals(this.curve, that.curve) && this.executionEnvironment == that.executionEnvironment && this.implementationPlatform == that.implementationPlatform && this.certificationLevel == that.certificationLevel && this.mode == that.mode && this.padding == that.padding && Objects.equals(this.cryptoFunctions, that.cryptoFunctions) && Objects.equals(this.classicalSecurityLevel, that.classicalSecurityLevel) && Objects.equals(this.nistQuantumSecurityLevel, that.nistQuantumSecurityLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.primitive, this.parameterSetIdentifier, this.curve, this.executionEnvironment, this.implementationPlatform, this.certificationLevel, this.mode, this.padding, this.cryptoFunctions, this.classicalSecurityLevel, this.nistQuantumSecurityLevel});
    }
}

