/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.github.packageurl.PackageURL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Pedigree;

public class Component {
    private String bomRef;
    private String publisher;
    private String group;
    private String name;
    private String version;
    private String description;
    private Scope scope;
    private List<Hash> hashes;
    private LicenseChoice licenseChoice;
    private String copyright;
    private String cpe;
    private String purl;
    private boolean modified;
    private Pedigree pedigree;
    private List<ExternalReference> externalReferences;
    private List<Component> components;
    private Type type;

    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public List<Hash> getHashes() {
        return this.hashes;
    }

    public void setHashes(List<Hash> hashes) {
        this.hashes = hashes;
    }

    public void addHash(Hash hash) {
        if (this.hashes == null) {
            this.hashes = new ArrayList<Hash>();
        }
        this.hashes.add(hash);
    }

    public LicenseChoice getLicenseChoice() {
        return this.licenseChoice;
    }

    public void setLicenseChoice(LicenseChoice licenseChoice) {
        this.licenseChoice = licenseChoice;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    @Deprecated
    public String getCpe() {
        return this.cpe;
    }

    @Deprecated
    public void setCpe(String cpe) {
        this.cpe = cpe;
    }

    public String getPurl() {
        return this.purl;
    }

    public void setPurl(String purl) {
        this.purl = purl;
    }

    public void setPurl(PackageURL purl) {
        this.purl = purl.canonicalize();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public Pedigree getPedigree() {
        return this.pedigree;
    }

    public void setPedigree(Pedigree pedigree) {
        this.pedigree = pedigree;
    }

    public List<ExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public void addExternalReference(ExternalReference externalReference) {
        if (this.externalReferences == null) {
            this.externalReferences = new ArrayList<ExternalReference>();
        }
        this.externalReferences.add(externalReference);
    }

    public void setExternalReferences(List<ExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void addComponent(Component component) {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        this.components.add(component);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.publisher, this.group, this.name, this.version, this.description, this.scope, this.hashes, this.licenseChoice, this.copyright, this.cpe, this.purl, this.modified, this.components, this.type});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        return this.modified == component.modified && Objects.equals(this.publisher, component.publisher) && Objects.equals(this.group, component.group) && Objects.equals(this.name, component.name) && Objects.equals(this.version, component.version) && Objects.equals(this.description, component.description) && Objects.equals((Object)this.scope, (Object)component.scope) && Objects.equals(this.hashes, component.hashes) && Objects.equals(this.licenseChoice, component.licenseChoice) && Objects.equals(this.copyright, component.copyright) && Objects.equals(this.cpe, component.cpe) && Objects.equals(this.purl, component.purl) && Objects.equals(this.components, component.components) && Objects.equals((Object)this.type, (Object)component.type);
    }

    public static enum Scope {
        REQUIRED("required"),
        OPTIONAL("optional"),
        EXCLUDED("excluded");

        private String name;

        public String getScopeName() {
            return this.name;
        }

        private Scope(String name) {
            this.name = name;
        }
    }

    public static enum Type {
        APPLICATION("application"),
        FRAMEWORK("framework"),
        LIBRARY("library"),
        OPERATING_SYSTEM("operating-system"),
        DEVICE("device"),
        FILE("file");

        private String name;

        public String getTypeName() {
            return this.name;
        }

        private Type(String name) {
            this.name = name;
        }
    }
}

