/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.parsers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.Version;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.model.Bom;
import org.cyclonedx.parsers.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParser
extends CycloneDxSchema
implements Parser {
    private final ObjectMapper mapper = new XmlMapper();
    private static final Map<String, String> NAMESPACE_TO_VERSION_MAP = new HashMap<String, String>();

    @Override
    public Bom parse(File file) throws ParseException {
        try {
            String schemaVersion = this.identifySchemaVersion(new InputSource(Files.newInputStream(file.toPath(), new OpenOption[0])));
            return this.injectSchemaVersion((Bom)this.mapper.readValue(file, Bom.class), schemaVersion);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public Bom parse(byte[] bomBytes) throws ParseException {
        try {
            String schemaVersion = this.identifySchemaVersion(new InputSource(new ByteArrayInputStream(bomBytes)));
            return this.injectSchemaVersion((Bom)this.mapper.readValue(bomBytes, Bom.class), schemaVersion);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public Bom parse(InputStream inputStream) throws ParseException {
        try {
            return (Bom)this.mapper.readValue(inputStream, Bom.class);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public Bom parse(Reader reader) throws ParseException {
        try {
            return (Bom)this.mapper.readValue(reader, Bom.class);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    private Bom injectSchemaVersion(Bom bom, String schemaVersion) {
        try {
            Field field = Bom.class.getDeclaredField("specVersion");
            field.setAccessible(true);
            field.set(bom, schemaVersion);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return bom;
    }

    @Override
    public List<ParseException> validate(File file) throws IOException {
        return this.validate(file, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(File file, Version schemaVersion) throws IOException {
        StreamSource source = new StreamSource(file);
        return this.validate(source, schemaVersion);
    }

    @Override
    public List<ParseException> validate(byte[] bomBytes) throws IOException {
        return this.validate(bomBytes, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(byte[] bomBytes, Version schemaVersion) throws IOException {
        StreamSource source = new StreamSource(new ByteArrayInputStream(bomBytes));
        return this.validate(source, schemaVersion);
    }

    @Override
    public List<ParseException> validate(Reader reader) throws IOException {
        return this.validate(reader, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(Reader reader, Version schemaVersion) throws IOException {
        StreamSource source = new StreamSource(reader);
        return this.validate(source, schemaVersion);
    }

    @Override
    public List<ParseException> validate(InputStream inputStream) throws IOException {
        return this.validate(inputStream, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(InputStream inputStream, Version schemaVersion) throws IOException {
        StreamSource source = new StreamSource(inputStream);
        return this.validate(source, schemaVersion);
    }

    public List<ParseException> validate(Source source, Version schemaVersion) throws IOException {
        final LinkedList<ParseException> exceptions = new LinkedList<ParseException>();
        try {
            Schema schema = this.getXmlSchema(schemaVersion);
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) {
                    exceptions.add(new ParseException(e.getMessage(), e));
                }

                @Override
                public void fatalError(SAXParseException e) {
                    exceptions.add(new ParseException(e.getMessage(), e));
                }

                @Override
                public void error(SAXParseException e) {
                    exceptions.add(new ParseException(e.getMessage(), e));
                }
            });
            validator.validate(source);
        }
        catch (SAXException e) {
            exceptions.add(new ParseException(e.getMessage(), e));
        }
        return exceptions;
    }

    @Override
    public boolean isValid(File file) throws IOException {
        return this.validate(file).isEmpty();
    }

    @Override
    public boolean isValid(File file, Version schemaVersion) throws IOException {
        return this.validate(file, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes) throws IOException {
        return this.validate(bomBytes).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes, Version schemaVersion) throws IOException {
        return this.validate(bomBytes, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader) throws IOException {
        return this.validate(reader).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader, Version schemaVersion) throws IOException {
        return this.validate(reader, schemaVersion).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream) throws IOException {
        return this.validate(inputStream).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream, Version schemaVersion) throws IOException {
        return this.validate(inputStream, schemaVersion).isEmpty();
    }

    private String identifySchemaVersion(InputSource in) throws ParserConfigurationException, IOException, SAXException {
        List<String> namespaces = this.extractAllNamespaceDeclarations(in);
        for (String namespaceUri : namespaces) {
            String versionString = NAMESPACE_TO_VERSION_MAP.get(namespaceUri);
            if (versionString == null) continue;
            return versionString;
        }
        return null;
    }

    private List<String> extractAllNamespaceDeclarations(InputSource in) throws ParserConfigurationException, IOException, SAXException {
        Document doc = this.createSecureDocument(in);
        ArrayList<String> namespaces = new ArrayList<String>();
        this.extractNamespaces(doc.getDocumentElement(), namespaces);
        return namespaces;
    }

    private void extractNamespaces(Node node, List<String> namespaces) {
        int i;
        if (node.getNodeType() == 1) {
            NamedNodeMap attributes = node.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                if (!attr.getNodeName().equals("xmlns")) continue;
                namespaces.add(attr.getNodeValue());
            }
        }
        NodeList children = node.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            this.extractNamespaces(children.item(i), namespaces);
        }
    }

    private Document createSecureDocument(InputSource in) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
        df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        df.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        df.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder builder = df.newDocumentBuilder();
        return builder.parse(in);
    }

    static {
        for (Version version : Version.values()) {
            NAMESPACE_TO_VERSION_MAP.put(version.getNamespace(), version.getVersionString());
        }
    }
}

