/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclonedx.Version;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.license.Acknowledgement;
import org.cyclonedx.model.license.Expression;
import org.cyclonedx.util.serializer.ExtensibleTypesSerializer;
import org.cyclonedx.util.serializer.SerializerUtils;

public class LicenseChoiceSerializer
extends StdSerializer<LicenseChoice> {
    private final boolean isXml;
    private final Version version;

    public LicenseChoiceSerializer(boolean isXml, Version version) {
        this(LicenseChoice.class, isXml, version);
    }

    public LicenseChoiceSerializer(Class<LicenseChoice> t, boolean isXml, Version version) {
        super(t);
        this.isXml = isXml;
        this.version = version;
    }

    public void serialize(LicenseChoice licenseChoice, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (licenseChoice == null) {
            return;
        }
        if (this.isXml && gen instanceof ToXmlGenerator) {
            ToXmlGenerator toXmlGenerator = (ToXmlGenerator)gen;
            this.serializeXml(toXmlGenerator, licenseChoice, provider);
        } else {
            this.serializeJson(licenseChoice, gen, provider);
        }
    }

    private void serializeXml(ToXmlGenerator toXmlGenerator, LicenseChoice lc, SerializerProvider provider) throws IOException {
        if (CollectionUtils.isNotEmpty(lc.getLicenses())) {
            toXmlGenerator.writeStartObject();
            toXmlGenerator.writeFieldName("license");
            toXmlGenerator.writeStartArray();
            for (License l : lc.getLicenses()) {
                this.serializeXmlAttributes(toXmlGenerator, l.getBomRef(), l.getAcknowledgement(), l);
                if (StringUtils.isNotBlank((CharSequence)l.getId())) {
                    toXmlGenerator.writeStringField("id", l.getId());
                } else if (StringUtils.isNotBlank((CharSequence)l.getName())) {
                    toXmlGenerator.writeStringField("name", l.getName());
                }
                if (l.getLicensing() != null && SerializerUtils.shouldSerializeField(l, this.version, "licensing")) {
                    toXmlGenerator.writeObjectField("licensing", (Object)l.getLicensing());
                }
                if (l.getAttachmentText() != null) {
                    toXmlGenerator.writeObjectField("text", (Object)l.getAttachmentText());
                }
                if (StringUtils.isNotBlank((CharSequence)l.getUrl())) {
                    toXmlGenerator.writeStringField("url", l.getUrl());
                }
                if (CollectionUtils.isNotEmpty(l.getProperties()) && SerializerUtils.shouldSerializeField(l, this.version, "properties")) {
                    toXmlGenerator.writeFieldName("properties");
                    toXmlGenerator.writeStartObject();
                    for (Property property : l.getProperties()) {
                        toXmlGenerator.writeObjectField("property", (Object)property);
                    }
                    toXmlGenerator.writeEndObject();
                }
                if (CollectionUtils.isNotEmpty(l.getExtensibleTypes())) {
                    new ExtensibleTypesSerializer().serialize(l.getExtensibleTypes(), (JsonGenerator)toXmlGenerator, provider);
                }
                toXmlGenerator.writeEndObject();
            }
            toXmlGenerator.writeEndArray();
            toXmlGenerator.writeEndObject();
        } else if (lc.getExpression() != null) {
            this.serializeExpressionToXml(lc, toXmlGenerator);
        } else {
            toXmlGenerator.writeStartArray();
            toXmlGenerator.writeEndArray();
        }
    }

    private void serializeXmlAttributes(ToXmlGenerator toXmlGenerator, String bomRef, Acknowledgement acknowledgement, Object object) throws IOException {
        toXmlGenerator.writeStartObject();
        if (StringUtils.isNotBlank((CharSequence)bomRef) && SerializerUtils.shouldSerializeField(object, this.version, "bomRef")) {
            toXmlGenerator.setNextIsAttribute(true);
            toXmlGenerator.writeFieldName("bom-ref");
            toXmlGenerator.writeString(bomRef);
            toXmlGenerator.setNextIsAttribute(false);
        }
        if (acknowledgement != null && SerializerUtils.shouldSerializeField(object, this.version, "acknowledgement")) {
            toXmlGenerator.setNextIsAttribute(true);
            toXmlGenerator.writeFieldName("acknowledgement");
            toXmlGenerator.writeString(acknowledgement.getValue());
            toXmlGenerator.setNextIsAttribute(false);
        }
    }

    private void serializeJson(LicenseChoice licenseChoice, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (CollectionUtils.isNotEmpty(licenseChoice.getLicenses())) {
            this.serializeLicensesToJsonArray(licenseChoice, gen, provider);
        } else if (licenseChoice.getExpression() != null && StringUtils.isNotBlank((CharSequence)licenseChoice.getExpression().getValue())) {
            this.serializeExpressionToJson(licenseChoice, gen);
        } else {
            gen.writeStartArray();
            gen.writeEndArray();
        }
    }

    private void serializeExpressionToXml(LicenseChoice licenseChoice, ToXmlGenerator toXmlGenerator) throws IOException {
        toXmlGenerator.writeStartObject();
        Expression expression = licenseChoice.getExpression();
        toXmlGenerator.writeFieldName("expression");
        this.serializeXmlAttributes(toXmlGenerator, expression.getBomRef(), expression.getAcknowledgement(), expression);
        toXmlGenerator.setNextIsUnwrapped(true);
        toXmlGenerator.writeStringField("", expression.getValue());
        toXmlGenerator.writeEndObject();
        toXmlGenerator.writeEndObject();
    }

    private void serializeLicensesToJsonArray(LicenseChoice licenseChoice, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartArray();
        for (License license : licenseChoice.getLicenses()) {
            gen.writeStartObject();
            provider.defaultSerializeField("license", (Object)license, gen);
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    private void serializeExpressionToJson(LicenseChoice licenseChoice, JsonGenerator gen) throws IOException {
        Expression expression = licenseChoice.getExpression();
        gen.writeStartArray();
        gen.writeStartObject();
        gen.writeStringField("expression", expression.getValue());
        if (expression.getAcknowledgement() != null && SerializerUtils.shouldSerializeField(expression, this.version, "acknowledgement")) {
            gen.writeStringField("acknowledgement", expression.getAcknowledgement().getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)expression.getBomRef()) && SerializerUtils.shouldSerializeField(expression, this.version, "bomRef")) {
            gen.writeStringField("bom-ref", expression.getBomRef());
        }
        gen.writeEndObject();
        gen.writeEndArray();
    }
}

