/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.Version;
import org.cyclonedx.model.Copyright;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.model.component.evidence.Callstack;
import org.cyclonedx.model.component.evidence.Identity;
import org.cyclonedx.model.component.evidence.Occurrence;
import org.cyclonedx.util.deserializer.IdentityDeserializer;
import org.cyclonedx.util.deserializer.LicenseDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"identity", "occurrences", "callstack", "licenses", "copyright"})
public class Evidence
extends ExtensibleElement {
    private LicenseChoice licenses;
    private List<Copyright> copyright;
    @VersionFilter(value=Version.VERSION_15)
    private List<Identity> identities;
    @VersionFilter(value=Version.VERSION_15)
    private List<Occurrence> occurrences;
    @VersionFilter(value=Version.VERSION_15)
    private Callstack callstack;

    @Deprecated
    public LicenseChoice getLicenseChoice() {
        return this.getLicenses();
    }

    @Deprecated
    @JsonIgnore
    public void setLicenseChoice(LicenseChoice licenseChoice) {
        this.setLicenses(licenseChoice);
    }

    @JsonDeserialize(using=LicenseDeserializer.class)
    public LicenseChoice getLicenses() {
        return this.licenses;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    public void setLicenses(LicenseChoice licenses) {
        this.licenses = licenses;
    }

    @JacksonXmlElementWrapper(localName="copyright")
    @JacksonXmlProperty(localName="text")
    @JsonProperty(value="copyright")
    public List<Copyright> getCopyright() {
        return this.copyright;
    }

    public void setCopyright(List<Copyright> copyright) {
        this.copyright = copyright;
    }

    public void addCopyright(Copyright copyright) {
        if (this.copyright == null) {
            this.copyright = new ArrayList<Copyright>();
        }
        this.copyright.add(copyright);
    }

    @JsonProperty(value="occurrences")
    @JacksonXmlElementWrapper(localName="occurrences")
    @JacksonXmlProperty(localName="occurrence")
    @VersionFilter(value=Version.VERSION_15)
    public List<Occurrence> getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(List<Occurrence> occurrences) {
        this.occurrences = occurrences;
    }

    public void addOccurrence(Occurrence occurrence) {
        if (this.occurrences == null) {
            this.occurrences = new ArrayList<Occurrence>();
        }
        this.occurrences.add(occurrence);
    }

    public Callstack getCallstack() {
        return this.callstack;
    }

    public void setCallstack(Callstack callstack) {
        this.callstack = callstack;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="identity")
    @JsonProperty(value="identity")
    @JsonDeserialize(using=IdentityDeserializer.class)
    @VersionFilter(value=Version.VERSION_15)
    public List<Identity> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<Identity> identities) {
        this.identities = identities;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Evidence)) {
            return false;
        }
        Evidence evidence = (Evidence)object;
        return Objects.equals(this.licenses, evidence.licenses) && Objects.equals(this.copyright, evidence.copyright) && Objects.equals(this.identities, evidence.identities) && Objects.equals(this.occurrences, evidence.occurrences) && Objects.equals(this.callstack, evidence.callstack);
    }

    public int hashCode() {
        return Objects.hash(this.licenses, this.copyright, this.identities, this.occurrences, this.callstack);
    }
}

