/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclonedx.Version;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.metadata.ToolInformation;
import org.cyclonedx.util.serializer.CustomDateSerializer;
import org.cyclonedx.util.serializer.LicenseChoiceSerializer;
import org.cyclonedx.util.serializer.LifecycleSerializer;
import org.cyclonedx.util.serializer.SerializerUtils;

public class MetadataSerializer
extends StdSerializer<Metadata> {
    private final boolean isXml;
    private final Version version;

    public MetadataSerializer(boolean isXml, Version version) {
        this(null, isXml, version);
    }

    public MetadataSerializer(Class<Metadata> t, boolean isXml, Version version) {
        super(t);
        this.isXml = isXml;
        this.version = version;
    }

    public void serialize(Metadata output, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.createMetadataInfo(output, (JsonGenerator)xmlGenerator, serializerProvider);
        } else {
            this.createMetadataInfo(output, jsonGenerator, serializerProvider);
        }
    }

    private void createMetadataInfo(Metadata metadata, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ToXmlGenerator xmlGenerator;
        jsonGenerator.writeStartObject();
        if (metadata.getTimestamp() != null && SerializerUtils.shouldSerializeField(metadata, this.version, "timestamp")) {
            jsonGenerator.writeFieldName("timestamp");
            new CustomDateSerializer().serialize(metadata.getTimestamp(), jsonGenerator, serializerProvider);
        }
        if (metadata.getLifecycles() != null && SerializerUtils.shouldSerializeField(metadata, this.version, "lifecycles")) {
            jsonGenerator.writeFieldName("lifecycles");
            new LifecycleSerializer(this.isXml).serialize(metadata.getLifecycles(), jsonGenerator, serializerProvider);
        }
        this.parseTools(metadata, jsonGenerator);
        if (metadata.getAuthors() != null && SerializerUtils.shouldSerializeField(metadata, this.version, "author")) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                this.writeArrayFieldXML(metadata.getAuthors(), xmlGenerator, "author");
            } else {
                jsonGenerator.writeObjectField("authors", metadata.getAuthors());
            }
        }
        if (metadata.getComponent() != null && SerializerUtils.shouldSerializeField(metadata, this.version, "component")) {
            jsonGenerator.writeObjectField("component", (Object)metadata.getComponent());
        }
        if (metadata.getManufacturer() != null && SerializerUtils.shouldSerializeField(metadata, this.version, "manufacturer")) {
            jsonGenerator.writeObjectField("manufacturer", (Object)metadata.getManufacturer());
        }
        if (metadata.getManufacture() != null && SerializerUtils.shouldSerializeField(metadata, this.version, "manufacture")) {
            jsonGenerator.writeObjectField("manufacture", (Object)metadata.getManufacture());
        }
        if (metadata.getSupplier() != null && SerializerUtils.shouldSerializeField(metadata, this.version, "supplier")) {
            jsonGenerator.writeObjectField("supplier", (Object)metadata.getSupplier());
        }
        if (metadata.getLicenses() != null && SerializerUtils.shouldSerializeField(metadata, this.version, "licenses")) {
            jsonGenerator.writeFieldName("licenses");
            new LicenseChoiceSerializer(this.isXml, this.version).serialize(metadata.getLicenses(), jsonGenerator, serializerProvider);
        }
        if (CollectionUtils.isNotEmpty(metadata.getProperties()) && SerializerUtils.shouldSerializeField(metadata, this.version, "properties")) {
            if (this.isXml) {
                xmlGenerator = (ToXmlGenerator)jsonGenerator;
                xmlGenerator.writeFieldName("properties");
                xmlGenerator.writeStartObject();
                for (Property property : metadata.getProperties()) {
                    xmlGenerator.writeObjectField("property", (Object)property);
                }
                xmlGenerator.writeEndObject();
            } else {
                jsonGenerator.writeObjectField("properties", metadata.getProperties());
            }
        }
        jsonGenerator.writeEndObject();
    }

    private void parseTools(Metadata metadata, JsonGenerator jsonGenerator) throws IOException {
        ToolInformation choice;
        if (metadata.getTools() != null) {
            if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
                this.writeArrayFieldXML(metadata.getTools(), (ToXmlGenerator)jsonGenerator, "tool");
            } else {
                this.writeArrayFieldJSON(jsonGenerator, "tools", metadata.getTools());
            }
        } else if (this.version.getVersion() >= Version.VERSION_15.getVersion() && (choice = metadata.getToolChoice()) != null) {
            jsonGenerator.writeFieldName("tools");
            jsonGenerator.writeStartObject();
            if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
                if (choice.getComponents() != null) {
                    this.writeArrayFieldXML(choice.getComponents(), (ToXmlGenerator)jsonGenerator, "component");
                }
                if (choice.getServices() != null) {
                    this.writeArrayFieldXML(choice.getServices(), (ToXmlGenerator)jsonGenerator, "service");
                }
            } else {
                if (choice.getComponents() != null) {
                    this.writeArrayFieldJSON(jsonGenerator, "components", choice.getComponents());
                }
                if (choice.getServices() != null) {
                    this.writeArrayFieldJSON(jsonGenerator, "services", choice.getServices());
                }
            }
            jsonGenerator.writeEndObject();
        }
    }

    private <T> void writeArrayFieldJSON(JsonGenerator jsonGenerator, String fieldName, List<T> items) throws IOException {
        if (items != null) {
            jsonGenerator.writeArrayFieldStart(fieldName);
            for (T item : items) {
                jsonGenerator.writeObject(item);
            }
            jsonGenerator.writeEndArray();
        }
    }

    private <T> void writeArrayFieldXML(List<T> items, ToXmlGenerator xmlGenerator, String fieldName) throws IOException {
        if (CollectionUtils.isNotEmpty(items)) {
            xmlGenerator.writeFieldName(fieldName + "s");
            xmlGenerator.writeStartObject();
            for (T item : items) {
                xmlGenerator.writeFieldName(fieldName);
                xmlGenerator.writeObject(item);
            }
            xmlGenerator.writeEndObject();
        }
    }

    public Class<Metadata> handledType() {
        return Metadata.class;
    }
}

