/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclonedx.Version;
import org.cyclonedx.model.Copyright;
import org.cyclonedx.model.Evidence;
import org.cyclonedx.model.component.evidence.Identity;
import org.cyclonedx.model.component.evidence.Occurrence;
import org.cyclonedx.util.serializer.LicenseChoiceSerializer;
import org.cyclonedx.util.serializer.SerializerUtils;

public class EvidenceSerializer
extends StdSerializer<Evidence> {
    private final boolean isXml;
    private final Version version;

    public EvidenceSerializer(boolean isXml, Version version) {
        this(null, isXml, version);
    }

    public EvidenceSerializer(Class<Evidence> t, boolean isXml, Version version) {
        super(t);
        this.isXml = isXml;
        this.version = version;
    }

    public void serialize(Evidence value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.serializeXml(xmlGenerator, value, serializerProvider);
        } else {
            this.serializeJson(jsonGenerator, value, serializerProvider);
        }
    }

    private void serializeXml(ToXmlGenerator xmlGenerator, Evidence evidence, SerializerProvider serializerProvider) throws IOException {
        xmlGenerator.writeStartObject();
        if (CollectionUtils.isNotEmpty(evidence.getIdentities()) && SerializerUtils.shouldSerializeField(evidence, this.version, "identities")) {
            if (this.version.getVersion() >= Version.VERSION_16.getVersion()) {
                xmlGenerator.writeFieldName("identity");
                xmlGenerator.writeStartArray();
                for (Identity identity : evidence.getIdentities()) {
                    xmlGenerator.writeObject((Object)identity);
                }
                xmlGenerator.writeEndArray();
            } else {
                xmlGenerator.writeObjectField("identity", (Object)evidence.getIdentities().get(0));
            }
        }
        if (CollectionUtils.isNotEmpty(evidence.getOccurrences()) && SerializerUtils.shouldSerializeField(evidence, this.version, "occurrences")) {
            xmlGenerator.writeFieldName("occurrences");
            xmlGenerator.writeStartObject();
            for (Occurrence occurrence : evidence.getOccurrences()) {
                xmlGenerator.writeFieldName("occurrence");
                xmlGenerator.writeObject((Object)occurrence);
            }
            xmlGenerator.writeEndObject();
        }
        this.serializeCommonInfo((JsonGenerator)xmlGenerator, evidence, serializerProvider);
        if (CollectionUtils.isNotEmpty(evidence.getCopyright()) && SerializerUtils.shouldSerializeField(evidence, this.version, "copyright")) {
            xmlGenerator.writeFieldName("copyright");
            xmlGenerator.writeStartObject();
            for (Copyright item : evidence.getCopyright()) {
                xmlGenerator.writeStringField("text", item.getText());
            }
            xmlGenerator.writeEndObject();
        }
        xmlGenerator.writeEndObject();
    }

    private void serializeJson(JsonGenerator gen, Evidence evidence, SerializerProvider serializerProvider) throws IOException {
        gen.writeStartObject();
        if (CollectionUtils.isNotEmpty(evidence.getIdentities()) && SerializerUtils.shouldSerializeField(evidence, this.version, "identities")) {
            if (this.version.getVersion() >= Version.VERSION_16.getVersion()) {
                gen.writeObjectField("identity", evidence.getIdentities());
            } else {
                gen.writeObjectField("identity", (Object)evidence.getIdentities().get(0));
            }
        }
        if (CollectionUtils.isNotEmpty(evidence.getOccurrences()) && SerializerUtils.shouldSerializeField(evidence, this.version, "occurrences")) {
            gen.writeObjectField("occurrences", evidence.getOccurrences());
        }
        this.serializeCommonInfo(gen, evidence, serializerProvider);
        if (CollectionUtils.isNotEmpty(evidence.getCopyright()) && SerializerUtils.shouldSerializeField(evidence, this.version, "copyright")) {
            gen.writeFieldName("copyright");
            gen.writeStartArray();
            for (Copyright item : evidence.getCopyright()) {
                gen.writeStartObject();
                gen.writeStringField("text", item.getText());
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }

    private void serializeCommonInfo(JsonGenerator gen, Evidence evidence, SerializerProvider serializerProvider) throws IOException {
        if (evidence.getCallstack() != null && SerializerUtils.shouldSerializeField(evidence, this.version, "callstack")) {
            gen.writeObjectField("callstack", (Object)evidence.getCallstack());
        }
        if (evidence.getLicenses() != null && SerializerUtils.shouldSerializeField(evidence, this.version, "licenses")) {
            gen.writeFieldName("licenses");
            new LicenseChoiceSerializer(this.isXml, this.version).serialize(evidence.getLicenses(), gen, serializerProvider);
        }
    }

    public Class<Evidence> handledType() {
        return Evidence.class;
    }
}

