/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.ReleaseNotes;
import org.cyclonedx.util.deserializer.DeserializerUtils;

public class NotesDeserializer
extends JsonDeserializer<List<ReleaseNotes.Notes>> {
    private final ObjectMapper mapper = new ObjectMapper();

    public List<ReleaseNotes.Notes> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        return this.parseNode(node.has("note") ? node.get("note") : node);
    }

    private List<ReleaseNotes.Notes> parseNode(JsonNode node) throws JsonProcessingException {
        if (node.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ReleaseNotes.Notes> list = new ArrayList<ReleaseNotes.Notes>();
        ArrayNode nodes = DeserializerUtils.getArrayNode(node, this.mapper);
        for (JsonNode noteNode : nodes) {
            list.add(this.parseNotes(noteNode));
        }
        return list;
    }

    private ReleaseNotes.Notes parseNotes(JsonNode node) throws JsonProcessingException {
        ReleaseNotes.Notes notes = new ReleaseNotes.Notes();
        if (node.has("locale")) {
            notes.setLocale(node.get("locale").asText());
        }
        if (node.has("text")) {
            JsonNode dataNode = node.get("text");
            AttachmentText data = (AttachmentText)this.mapper.treeToValue((TreeNode)dataNode, AttachmentText.class);
            notes.setText(data);
        }
        return notes;
    }
}

