/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.license.Expression;

public final class LicenseResolver {
    private static LicenseList licenses;

    private LicenseResolver() {
    }

    public static LicenseChoice resolve(String licenseString) {
        return LicenseResolver.resolve(licenseString, new LicenseTextSettings(true, LicenseEncoding.BASE64));
    }

    public static LicenseChoice resolve(String licenseString, boolean includeLicenseText) {
        return LicenseResolver.resolve(licenseString, new LicenseTextSettings(includeLicenseText, LicenseEncoding.BASE64));
    }

    static LicenseChoice resolve(String licenseString, boolean includeLicenseText, ObjectMapper mapper) {
        return LicenseResolver.resolve(licenseString, new LicenseTextSettings(includeLicenseText, LicenseEncoding.BASE64), mapper);
    }

    public static LicenseChoice resolve(String licenseString, LicenseTextSettings licenseTextSettings) {
        ObjectMapper mapper = new ObjectMapper();
        return LicenseResolver.resolve(licenseString, licenseTextSettings, mapper);
    }

    static LicenseChoice resolve(String licenseString, LicenseTextSettings licenseTextSettings, ObjectMapper mapper) {
        try {
            LicenseChoice licenseChoice = LicenseResolver.resolveLicenseString(licenseString, licenseTextSettings, mapper);
            if (licenseChoice == null) {
                licenseChoice = LicenseResolver.resolveFuzzyMatching(licenseString, licenseTextSettings, mapper);
            }
            return licenseChoice;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static LicenseChoice resolveLicenseString(String licenseString, LicenseTextSettings licenseTextSettings, ObjectMapper mapper) throws IOException {
        if (licenses == null) {
            InputStream is = LicenseResolver.class.getResourceAsStream("/licenses/licenses.json");
            licenses = (LicenseList)mapper.readValue(is, LicenseList.class);
        }
        if (licenses != null && LicenseResolver.licenses.licenses != null && !LicenseResolver.licenses.licenses.isEmpty()) {
            for (LicenseDetail licenseDetail : LicenseResolver.licenses.licenses) {
                String primaryLicenseUrl;
                String string = primaryLicenseUrl = licenseDetail.seeAlso != null && !licenseDetail.seeAlso.isEmpty() ? licenseDetail.seeAlso.get(0) : null;
                if (licenseString.trim().equalsIgnoreCase(licenseDetail.licenseId)) {
                    return LicenseResolver.createLicenseChoice(licenseDetail.licenseId, primaryLicenseUrl, licenseDetail.isDeprecatedLicenseId, licenseTextSettings);
                }
                if (licenseString.trim().equalsIgnoreCase(licenseDetail.name)) {
                    return LicenseResolver.createLicenseChoice(licenseDetail.licenseId, primaryLicenseUrl, licenseDetail.isDeprecatedLicenseId, licenseTextSettings);
                }
                if (licenseDetail.isDeprecatedLicenseId || licenseDetail.seeAlso == null) continue;
                for (String url : licenseDetail.seeAlso) {
                    String licenseStringModified;
                    if (url == null || !(licenseStringModified = LicenseResolver.urlNormalize(licenseString)).equalsIgnoreCase(LicenseResolver.urlNormalize(url))) continue;
                    return LicenseResolver.createLicenseChoice(licenseDetail.licenseId, url, licenseDetail.isDeprecatedLicenseId, licenseTextSettings);
                }
            }
        }
        return null;
    }

    private static LicenseChoice resolveFuzzyMatching(String licenseString, LicenseTextSettings licenseTextSettings, ObjectMapper mapper) throws IOException {
        if (licenseString == null) {
            return null;
        }
        InputStream is = LicenseResolver.class.getResourceAsStream("/license-mapping.json");
        SpdxLicenseMapping[] mappings = (SpdxLicenseMapping[])mapper.readValue(is, SpdxLicenseMapping[].class);
        if (mappings != null) {
            for (SpdxLicenseMapping licenseMapping : mappings) {
                if (licenseMapping.names == null || licenseMapping.names.isEmpty()) continue;
                for (String name : licenseMapping.names) {
                    if (!licenseString.equalsIgnoreCase(name)) continue;
                    if (licenseMapping.exp.startsWith("(") && licenseMapping.exp.endsWith(")")) {
                        LicenseChoice lc = new LicenseChoice();
                        lc.setExpression(new Expression(licenseMapping.exp));
                        return lc;
                    }
                    return LicenseResolver.createLicenseChoice(licenseMapping.exp, null, false, licenseTextSettings);
                }
            }
        }
        return null;
    }

    private static String urlNormalize(String input) {
        return input.trim().replace("https://www.", "").replace("http://www.", "").replace("https://", "").replace("http://", "");
    }

    private static LicenseChoice createLicenseChoice(String licenseId, String primaryLicenseUrl, boolean isDeprecatedLicenseId, LicenseTextSettings licenseTextSettings) throws IOException {
        InputStream is;
        LicenseChoice choice = new LicenseChoice();
        License license = new License();
        license.setId(licenseId);
        license.setUrl(primaryLicenseUrl);
        if (!isDeprecatedLicenseId && licenseTextSettings.isTextIncluded() && (is = LicenseResolver.class.getResourceAsStream("/licenses/" + licenseId + ".txt")) != null) {
            String text = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            AttachmentText attachment = new AttachmentText();
            attachment.setContentType("text/plain");
            switch (licenseTextSettings.getEncoding()) {
                case NONE: {
                    attachment.setEncoding(null);
                    attachment.setText(text);
                    break;
                }
                case BASE64: {
                    attachment.setEncoding(licenseTextSettings.getEncoding().toString());
                    attachment.setText(Base64.getEncoder().encodeToString(text.getBytes(Charset.defaultCharset())));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled License Encoding:" + licenseTextSettings.getEncoding().toString());
                }
            }
            license.setLicenseText(attachment);
        }
        choice.addLicense(license);
        return choice;
    }

    private static class SpdxLicenseMapping {
        public String exp;
        public List<String> names;

        private SpdxLicenseMapping() {
        }
    }

    private static class LicenseList {
        public String licenseListVersion;
        public List<LicenseDetail> licenses;
        public String releaseDate;

        private LicenseList() {
        }
    }

    private static class LicenseDetail {
        public String reference;
        public boolean isDeprecatedLicenseId;
        public String detailsUrl;
        public String referenceNumber;
        public String name;
        public String licenseId;
        public List<String> seeAlso;
        public boolean isOsiApproved;
        public boolean isFsfLibre;

        private LicenseDetail() {
        }
    }

    public static class LicenseTextSettings {
        public boolean isTextIncluded;
        public LicenseEncoding encoding;

        public LicenseTextSettings(boolean includeLicenseText, LicenseEncoding encoding) {
            this.isTextIncluded = includeLicenseText;
            this.encoding = encoding;
        }

        public boolean isTextIncluded() {
            return this.isTextIncluded;
        }

        public void setTextIncluded(boolean include) {
            this.isTextIncluded = include;
        }

        public LicenseEncoding getEncoding() {
            return this.encoding;
        }

        public void setEncoding(LicenseEncoding encoding) {
            this.encoding = encoding;
        }
    }

    public static enum LicenseEncoding {
        BASE64("base64"),
        NONE("none");

        private final String encodingName;

        private LicenseEncoding(String encodingName) {
            this.encodingName = encodingName;
        }

        public String toString() {
            return this.encodingName;
        }
    }
}

