/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model.formulation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.Service;
import org.cyclonedx.model.formulation.Workflow;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"bom-ref", "components", "services", "workflows", "properties"})
public class Formula
extends ExtensibleElement {
    @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
    @JsonProperty(value="bom-ref")
    private String bomRef;
    private List<Component> components;
    private List<Service> services;
    private List<Workflow> workflows;
    private List<Property> properties;

    @JacksonXmlElementWrapper(localName="components")
    @JacksonXmlProperty(localName="component")
    public List<Component> getComponents() {
        return this.components;
    }

    @JacksonXmlElementWrapper(localName="services")
    @JacksonXmlProperty(localName="service")
    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public void addService(Service service) {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.add(service);
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        this.properties.add(property);
    }

    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    @JacksonXmlElementWrapper(localName="workflows")
    @JacksonXmlProperty(localName="workflow")
    public List<Workflow> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(List<Workflow> workflows) {
        this.workflows = workflows;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Formula)) {
            return false;
        }
        Formula formula = (Formula)object;
        return Objects.equals(this.bomRef, formula.bomRef) && Objects.equals(this.components, formula.components) && Objects.equals(this.services, formula.services) && Objects.equals(this.workflows, formula.workflows) && Objects.equals(this.properties, formula.properties);
    }

    public int hashCode() {
        return Objects.hash(this.bomRef, this.components, this.services, this.workflows, this.properties);
    }
}

