/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.drive.adaptee;

import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.ctoolkit.restapi.client.Identifier;
import org.ctoolkit.restapi.client.adaptee.DeleteExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.InsertExecutorAdaptee;
import org.ctoolkit.restapi.client.adaptee.MediaProvider;
import org.ctoolkit.restapi.client.adaptee.UnderlyingClientAdaptee;
import org.ctoolkit.restapi.client.adapter.AbstractGoogleClientAdaptee;

public class FileAdaptee
extends AbstractGoogleClientAdaptee<Drive>
implements InsertExecutorAdaptee<File>,
DeleteExecutorAdaptee<File>,
UnderlyingClientAdaptee<Drive> {
    @Inject
    public FileAdaptee(Drive client) {
        super((Object)client);
    }

    public Drive.Files.Create prepareInsert(@Nonnull File resource, @Nullable Identifier parentKey, @Nullable MediaProvider provider) throws IOException {
        Preconditions.checkNotNull((Object)resource);
        Drive.Files.Create insert = provider == null ? ((Drive)this.client()).files().create(resource) : ((Drive)this.client()).files().create(resource, this.media(provider));
        return insert;
    }

    public Object executeInsert(@Nonnull Object request, @Nullable Map<String, Object> parameters, @Nullable Locale locale) throws IOException {
        return this.execute(request, parameters);
    }

    public Drive.Files.Delete prepareDelete(@Nonnull Identifier identifier) throws IOException {
        Preconditions.checkNotNull((Object)identifier);
        return ((Drive)this.client()).files().delete(identifier.getString());
    }

    public Object executeDelete(@Nonnull Object request, @Nullable Map<String, Object> parameters, @Nullable Locale locale) throws IOException {
        return this.execute(request, parameters);
    }

    public Drive getUnderlyingClient() {
        return (Drive)this.client();
    }
}

