/*
 * Decompiled with CFR 0.152.
 */
package org.ctoolkit.restapi.client.drive;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.DriveScopes;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Set;
import javax.inject.Singleton;
import org.ctoolkit.restapi.client.RemoteServerErrorException;
import org.ctoolkit.restapi.client.UnauthorizedException;
import org.ctoolkit.restapi.client.googleapis.GoogleApiCredentialFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleApiDriveModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(GoogleApiDriveModule.class);

    protected void configure() {
    }

    @Provides
    @Singleton
    Drive provideDrive(GoogleApiCredentialFactory factory) {
        Drive.Builder builder;
        Set scopes = DriveScopes.all();
        try {
            HttpRequestInitializer credential = factory.authorize((Collection)scopes, null);
            builder = new Drive.Builder(factory.getHttpTransport(), factory.getJsonFactory(), credential);
            builder.setApplicationName(factory.getApplicationName());
        }
        catch (GeneralSecurityException e) {
            logger.error("Failed. Scopes: " + scopes.toString() + " Application name: " + factory.getApplicationName() + " Service account: " + factory.getServiceAccountEmail(), (Throwable)e);
            throw new UnauthorizedException(e.getMessage());
        }
        catch (IOException e) {
            logger.error("Failed. Scopes: " + scopes.toString() + " Application name: " + factory.getApplicationName() + " Service account: " + factory.getServiceAccountEmail(), (Throwable)e);
            throw new RemoteServerErrorException(500, e.getMessage());
        }
        return builder.build();
    }
}

