/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes.workspace;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class HostPathWorkspaceVolume
extends WorkspaceVolume {
    private String hostPath;

    @DataBoundConstructor
    public HostPathWorkspaceVolume(String hostPath) {
        this.hostPath = hostPath;
    }

    @Override
    public Volume buildVolume(String volumeName) {
        return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewHostPath(this.getHostPath())).build();
    }

    public String getHostPath() {
        return this.hostPath;
    }

    @Extension
    @Symbol(value={"hostPathWorkspaceVolume"})
    public static class DescriptorImpl
    extends Descriptor<WorkspaceVolume> {
        public String getDisplayName() {
            return "Host Path Workspace Volume";
        }
    }
}

