/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Node;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.jenkinsci.plugins.workflow.steps.StepContext;

class KubernetesNodeContext {
    private static final transient String HOSTNAME_FILE = "/etc/hostname";
    private StepContext context;
    private FilePath workspace;

    KubernetesNodeContext(StepContext context) throws Exception {
        this.context = context;
        this.workspace = (FilePath)context.get(FilePath.class);
    }

    String getPodName() throws Exception {
        return this.workspace.child(HOSTNAME_FILE).readToString().trim();
    }

    public String getNamespace() throws Exception {
        return this.workspace.child("/var/run/secrets/kubernetes.io/serviceaccount/namespace").readToString().trim();
    }

    KubernetesClient connectToCloud() throws Exception {
        Node node = (Node)this.context.get(Node.class);
        if (!(node instanceof KubernetesSlave)) {
            throw new AbortException(String.format("Node is not a Kubernetes node: %s", node != null ? node.getNodeName() : null));
        }
        KubernetesSlave slave = (KubernetesSlave)node;
        KubernetesCloud cloud = slave.getKubernetesCloud();
        return cloud.connect();
    }
}

