/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentDescriptor;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class KubernetesDeclarativeAgent
extends DeclarativeAgent<KubernetesDeclarativeAgent> {
    private static final Logger LOGGER = Logger.getLogger(KubernetesDeclarativeAgent.class.getName());
    private String label;
    private String cloud;
    private String inheritFrom;
    private int idleMinutes;
    private int instanceCap;
    private String serviceAccount;
    private String nodeSelector;
    private String workingDir;
    private int activeDeadlineSeconds;
    private ContainerTemplate containerTemplate;
    private List<ContainerTemplate> containerTemplates;
    private String defaultContainer;
    private String yaml;

    @DataBoundConstructor
    public KubernetesDeclarativeAgent() {
    }

    @Deprecated
    public KubernetesDeclarativeAgent(String label, ContainerTemplate containerTemplate) {
        this.label = label;
        this.containerTemplate = containerTemplate;
    }

    public String getLabel() {
        return this.label;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = label;
    }

    public String getCloud() {
        return this.cloud;
    }

    @DataBoundSetter
    public void setCloud(String cloud) {
        this.cloud = cloud;
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    @DataBoundSetter
    public void setIdleMinutes(int idleMinutes) {
        this.idleMinutes = idleMinutes;
    }

    public String getInheritFrom() {
        return this.inheritFrom;
    }

    @DataBoundSetter
    public void setInheritFrom(String inheritFrom) {
        this.inheritFrom = inheritFrom;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    @DataBoundSetter
    public void setInstanceCap(int instanceCap) {
        this.instanceCap = instanceCap;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @DataBoundSetter
    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public String getNodeSelector() {
        return this.nodeSelector;
    }

    @DataBoundSetter
    public void setNodeSelector(String nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @DataBoundSetter
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getYaml() {
        return this.yaml;
    }

    @DataBoundSetter
    public void setYaml(String yaml) {
        this.yaml = yaml;
    }

    @Deprecated
    public ContainerTemplate getContainerTemplate() {
        return this.containerTemplate;
    }

    @DataBoundSetter
    @Restricted(value={DoNotUse.class})
    public void setContainerTemplate(ContainerTemplate containerTemplate) {
        this.containerTemplate = containerTemplate;
    }

    @NonNull
    public List<ContainerTemplate> getContainerTemplates() {
        return this.containerTemplates != null ? this.containerTemplates : Collections.emptyList();
    }

    @DataBoundSetter
    public void setContainerTemplates(List<ContainerTemplate> containerTemplates) {
        this.containerTemplates = containerTemplates;
    }

    public String getDefaultContainer() {
        return this.defaultContainer;
    }

    @DataBoundSetter
    public void setDefaultContainer(String defaultContainer) {
        this.defaultContainer = defaultContainer;
    }

    public int getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @DataBoundSetter
    public void setActiveDeadlineSeconds(int activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public Map<String, Object> getAsArgs() {
        TreeMap<String, Object> argMap = new TreeMap<String, Object>();
        argMap.put("label", this.label);
        argMap.put("name", this.label);
        List<ContainerTemplate> containerTemplates = this.getContainerTemplates();
        if (this.containerTemplate != null) {
            LOGGER.log(Level.WARNING, "containerTemplate option in declarative pipeline is deprecated, use containerTemplates");
            if (containerTemplates.isEmpty()) {
                containerTemplates = Collections.singletonList(this.containerTemplate);
            } else {
                LOGGER.log(Level.WARNING, "Ignoring containerTemplate option as containerTemplates is also defined");
            }
        }
        argMap.put("containers", containerTemplates);
        if (!StringUtils.isEmpty((String)this.yaml)) {
            argMap.put("yaml", this.yaml);
        }
        if (!StringUtils.isEmpty((String)this.cloud)) {
            argMap.put("cloud", this.cloud);
        }
        if (this.idleMinutes != 0) {
            argMap.put("idleMinutes", this.idleMinutes);
        }
        if (!StringUtils.isEmpty((String)this.inheritFrom)) {
            argMap.put("inheritFrom", this.inheritFrom);
        }
        if (!StringUtils.isEmpty((String)this.serviceAccount)) {
            argMap.put("serviceAccount", this.serviceAccount);
        }
        if (!StringUtils.isEmpty((String)this.nodeSelector)) {
            argMap.put("nodeSelector", this.nodeSelector);
        }
        if (!StringUtils.isEmpty((String)this.workingDir)) {
            argMap.put("workingDir", this.workingDir);
        }
        if (this.activeDeadlineSeconds != 0) {
            argMap.put("activeDeadlineSeconds", this.activeDeadlineSeconds);
        }
        if (this.instanceCap > 0) {
            argMap.put("instanceCap", this.instanceCap);
        }
        return argMap;
    }

    @OptionalExtension(requirePlugins={"pipeline-model-extensions"})
    @Symbol(value={"kubernetes"})
    public static class DescriptorImpl
    extends DeclarativeAgentDescriptor<KubernetesDeclarativeAgent> {
    }
}

