/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.Proc;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContainerExecProc
extends Proc
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(ContainerExecProc.class.getName());
    private final AtomicBoolean alive;
    private final CountDownLatch finished;
    private final ExecWatch watch;
    private final Callable<Integer> exitCode;

    public ContainerExecProc(ExecWatch watch, AtomicBoolean alive, CountDownLatch finished, Callable<Integer> exitCode) {
        this.watch = watch;
        this.alive = alive;
        this.finished = finished;
        this.exitCode = exitCode;
    }

    public boolean isAlive() throws IOException, InterruptedException {
        return this.alive.get();
    }

    public void kill() throws IOException, InterruptedException {
        try {
            this.watch.getInput().write(3);
            this.watch.getInput().write("exit".getBytes(StandardCharsets.UTF_8));
            this.watch.getInput().write("\n".getBytes(StandardCharsets.UTF_8));
            this.watch.getInput().flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Proc kill failed, ignoring", e);
        }
        finally {
            this.close();
        }
    }

    public int join() throws IOException, InterruptedException {
        try {
            LOGGER.log(Level.FINEST, "Waiting for websocket to close on command finish ({0})", this.finished);
            this.finished.await();
            LOGGER.log(Level.FINEST, "Command is finished ({0})", this.finished);
            int n = this.exitCode.call();
            return n;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error getting exit code", e);
            int n = -1;
            return n;
        }
        finally {
            this.close();
        }
    }

    public InputStream getStdout() {
        return this.watch.getOutput();
    }

    public InputStream getStderr() {
        return this.watch.getError();
    }

    public OutputStream getStdin() {
        return this.watch.getInput();
    }

    @Override
    public void close() throws IOException {
        try {
            this.watch.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "failed to close watch", e);
        }
    }
}

