/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.model.Computer;
import hudson.model.Node;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Response;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecProc;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.EvictingQueue;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.proc.CachedProc;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.proc.DeadProc;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;

public class ContainerExecDecorator
extends LauncherDecorator
implements Serializable,
Closeable {
    private static final long serialVersionUID = 4419929753433397655L;
    private static final long DEFAULT_CONTAINER_READY_TIMEOUT = 5L;
    private static final String CONTAINER_READY_TIMEOUT_SYSTEM_PROPERTY = ContainerExecDecorator.class.getName() + ".containerReadyTimeout";
    private static final long CONTAINER_READY_TIMEOUT = ContainerExecDecorator.containerReadyTimeout();
    private static final String COOKIE_VAR = "JENKINS_SERVER_COOKIE";
    private static final Logger LOGGER = Logger.getLogger(ContainerExecDecorator.class.getName());
    private static final String DEFAULT_SHELL = "/bin/sh";
    private transient KubernetesClient client;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private transient List<Closeable> closables;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private transient Map<Integer, ContainerExecProc> processes = new HashMap<Integer, ContainerExecProc>();
    private String podName;
    private String namespace;
    private String containerName;
    private EnvironmentExpander environmentExpander;
    private EnvVars globalVars;
    private FilePath ws;
    private EnvVars rcEnvVars;
    private String shell;

    public ContainerExecDecorator() {
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace, EnvironmentExpander environmentExpander, FilePath ws) {
        this.client = client;
        this.podName = podName;
        this.namespace = namespace;
        this.containerName = containerName;
        this.environmentExpander = environmentExpander;
        this.ws = ws;
        this.shell = DEFAULT_SHELL;
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace, EnvironmentExpander environmentExpander) {
        this(client, podName, containerName, namespace, environmentExpander, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace) {
        this(client, podName, containerName, namespace, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished, String namespace) {
        this(client, podName, containerName, namespace, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished) {
        this(client, podName, containerName, (String)null, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String path, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished) {
        this(client, podName, containerName, (String)null, null, null);
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public String getPodName() {
        return this.podName;
    }

    public void setPodName(String podName) {
        this.podName = podName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public EnvironmentExpander getEnvironmentExpander() {
        return this.environmentExpander;
    }

    public void setEnvironmentExpander(EnvironmentExpander environmentExpander) {
        this.environmentExpander = environmentExpander;
    }

    public EnvVars getGlobalVars() {
        return this.globalVars;
    }

    public void setGlobalVars(EnvVars globalVars) {
        this.globalVars = globalVars;
    }

    public void setRunContextEnvVars(EnvVars rcVars) {
        this.rcEnvVars = rcVars;
    }

    public EnvVars getRunContextEnvVars() {
        return this.rcEnvVars;
    }

    public FilePath getWs() {
        return this.ws;
    }

    public void setWs(FilePath ws) {
        this.ws = ws;
    }

    public String getShell() {
        return this.shell == null ? DEFAULT_SHELL : this.shell;
    }

    public void setShell(String shell) {
        this.shell = shell;
    }

    public Launcher decorate(final Launcher launcher, final Node node) {
        return new Launcher.DecoratedLauncher(launcher){

            public Proc launch(Launcher.ProcStarter starter) throws IOException {
                Computer computer;
                LOGGER.log(Level.FINEST, "Launch proc with environment: {0}", Arrays.toString(starter.envs()));
                String[] envVars = starter.envs();
                if (node != null && (computer = node.toComputer()) != null) {
                    ArrayList<String> resultEnvVar = new ArrayList<String>();
                    try {
                        String[] envs;
                        EnvVars environment = computer.getEnvironment();
                        for (String keyValue : envs = starter.envs()) {
                            String[] split = keyValue.split("=", 2);
                            if (split[1].equals(environment.get((Object)split[0]))) continue;
                            resultEnvVar.add(keyValue);
                        }
                        envVars = resultEnvVar.toArray(new String[resultEnvVar.size()]);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Unable to retrieve environment variables", e);
                    }
                }
                return this.doLaunch(starter.quiet(), envVars, starter.stdout(), starter.pwd(), ContainerExecDecorator.getCommands(starter));
            }

            private Proc doLaunch(boolean quiet, String[] cmdEnvs, OutputStream outputForCaller, FilePath pwd, String ... commands) throws IOException {
                ExecWatch watch;
                PrintStream printStream;
                int p;
                if (ContainerExecDecorator.this.processes == null) {
                    ContainerExecDecorator.this.processes = new HashMap();
                }
                if ((p = ContainerExecDecorator.readPidFromPsCommand(commands)) == 9999) {
                    return new DeadProc();
                }
                if (p > 0 && ContainerExecDecorator.this.processes.containsKey(p)) {
                    LOGGER.log(Level.INFO, "Retrieved process from cache with pid:[ " + p + "].");
                    return new CachedProc((ContainerExecProc)ContainerExecDecorator.this.processes.get(p));
                }
                this.waitUntilContainerIsReady();
                final CountDownLatch started = new CountDownLatch(1);
                final CountDownLatch finished = new CountDownLatch(1);
                final AtomicBoolean alive = new AtomicBoolean(false);
                PrintStream stream = printStream = launcher.getListener().getLogger();
                if (quiet) {
                    stream = new NullOutputStream();
                    printStream = new PrintStream((OutputStream)stream, false, StandardCharsets.UTF_8.toString());
                }
                ExitCodeOutputStream exitCodeOutputStream = new ExitCodeOutputStream();
                stream = new TeeOutputStream((OutputStream)exitCodeOutputStream, (OutputStream)stream);
                if (outputForCaller != null) {
                    stream = new TeeOutputStream(outputForCaller, (OutputStream)stream);
                }
                String msg = "Executing shell script inside container [" + ContainerExecDecorator.this.containerName + "] of pod [" + ContainerExecDecorator.this.podName + "]";
                LOGGER.log(Level.FINEST, msg);
                printStream.println(msg);
                Execable execable = (Execable)((TtyExecable)((TtyExecErrorable)((TtyExecOutputErrorable)((ContainerResource)((PodResource)((NonNamespaceOperation)ContainerExecDecorator.this.client.pods().inNamespace(ContainerExecDecorator.this.namespace)).withName(ContainerExecDecorator.this.podName)).inContainer((Object)ContainerExecDecorator.this.containerName)).redirectingInput()).writingOutput((Object)stream)).writingError((Object)stream)).usingListener((Object)new ExecListener(){

                    public void onOpen(Response response) {
                        alive.set(true);
                        started.countDown();
                        LOGGER.log(Level.FINEST, "onOpen : {0}", finished);
                    }

                    public void onFailure(Throwable t, Response response) {
                        alive.set(false);
                        t.printStackTrace(launcher.getListener().getLogger());
                        started.countDown();
                        LOGGER.log(Level.FINEST, "onFailure : {0}", finished);
                        if (finished.getCount() == 0L) {
                            LOGGER.log(Level.WARNING, "onFailure called but latch already finished. This may be a bug in the kubernetes-plugin");
                        }
                        finished.countDown();
                    }

                    public void onClose(int i, String s) {
                        alive.set(false);
                        started.countDown();
                        LOGGER.log(Level.FINEST, "onClose : {0}", finished);
                        if (finished.getCount() == 0L) {
                            LOGGER.log(Level.WARNING, "onClose called but latch already finished. This indicates a bug in the kubernetes-plugin");
                        }
                        finished.countDown();
                    }
                });
                try {
                    watch = (ExecWatch)execable.exec((Object[])new String[]{ContainerExecDecorator.this.getShell()});
                }
                catch (KubernetesClientException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        throw new IOException("JENKINS-40825: interrupted while starting websocket connection", e);
                    }
                    throw e;
                }
                try {
                    started.await();
                }
                catch (InterruptedException e) {
                    ContainerExecDecorator.closeWatch(watch);
                    throw new IOException("JENKINS-40825: interrupted while waiting for websocket connection", e);
                }
                try {
                    if (pwd != null) {
                        watch.getInput().write(String.format("cd \"%s\"%s", pwd, "\n").getBytes(StandardCharsets.UTF_8));
                    }
                    if (ContainerExecDecorator.this.globalVars != null) {
                        this.setupEnvironmentVariable(ContainerExecDecorator.this.globalVars, watch);
                    }
                    if (ContainerExecDecorator.this.rcEnvVars != null) {
                        this.setupEnvironmentVariable(ContainerExecDecorator.this.rcEnvVars, watch);
                    }
                    EnvVars envVars = new EnvVars();
                    if (ContainerExecDecorator.this.environmentExpander != null) {
                        ContainerExecDecorator.this.environmentExpander.expand(envVars);
                    }
                    if (cmdEnvs != null) {
                        LOGGER.log(Level.FINEST, "Launching with env vars: {0}", Arrays.toString(cmdEnvs));
                        for (String cmdEnv : cmdEnvs) {
                            envVars.addLine(cmdEnv);
                        }
                    }
                    this.setupEnvironmentVariable(envVars, watch);
                    ContainerExecDecorator.doExec(watch, printStream, commands);
                    if (ContainerExecDecorator.this.closables == null) {
                        ContainerExecDecorator.this.closables = new ArrayList();
                    }
                    int pid = ContainerExecDecorator.this.readPidFromPidFile(commands);
                    LOGGER.log(Level.INFO, "Created process inside pod: [" + ContainerExecDecorator.this.podName + "], container: [" + ContainerExecDecorator.this.containerName + "] with pid:[" + pid + "]");
                    ContainerExecProc proc = new ContainerExecProc(watch, alive, finished, exitCodeOutputStream::getExitCode);
                    ContainerExecDecorator.this.processes.put(pid, proc);
                    ContainerExecDecorator.this.closables.add(proc);
                    return proc;
                }
                catch (InterruptedException ie) {
                    throw new InterruptedIOException(ie.getMessage());
                }
                catch (Exception e) {
                    ContainerExecDecorator.closeWatch(watch);
                    throw e;
                }
            }

            public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                this.getListener().getLogger().println("Killing processes");
                String cookie = modelEnvVars.get(ContainerExecDecorator.COOKIE_VAR);
                int exitCode = this.doLaunch(true, null, null, null, "sh", "-c", "kill \\`grep -l 'JENKINS_SERVER_COOKIE=" + cookie + "' /proc/*/environ | cut -d / -f 3 \\`").join();
                this.getListener().getLogger().println("kill finished with exit code " + exitCode);
            }

            private void setupEnvironmentVariable(EnvVars vars, ExecWatch watch) throws IOException {
                for (Map.Entry entry : vars.entrySet()) {
                    if (!((String)entry.getKey()).matches("[a-zA-Z_][a-zA-Z0-9_]*")) continue;
                    watch.getInput().write(String.format("export %s='%s'%s", entry.getKey(), ((String)entry.getValue()).replace("'", "'\\''"), "\n").getBytes(StandardCharsets.UTF_8));
                }
            }

            private void waitUntilContainerIsReady() throws IOException {
                try {
                    Pod pod = (Pod)((PodResource)((NonNamespaceOperation)ContainerExecDecorator.this.client.pods().inNamespace(ContainerExecDecorator.this.namespace)).withName(ContainerExecDecorator.this.podName)).waitUntilReady(CONTAINER_READY_TIMEOUT, TimeUnit.MINUTES);
                    if (pod == null || pod.getStatus() == null || pod.getStatus().getContainerStatuses() == null) {
                        throw new IOException("Failed to execute shell script inside container [" + ContainerExecDecorator.this.containerName + "] of pod [" + ContainerExecDecorator.this.podName + "].Failed to get container status");
                    }
                    for (ContainerStatus info : pod.getStatus().getContainerStatuses()) {
                        if (!info.getName().equals(ContainerExecDecorator.this.containerName)) continue;
                        if (info.getReady().booleanValue()) {
                            return;
                        }
                        throw new IOException("container [" + ContainerExecDecorator.this.containerName + "] of pod [" + ContainerExecDecorator.this.podName + "] is not ready, state is " + info.getState());
                    }
                    throw new IOException("container [" + ContainerExecDecorator.this.containerName + "] does not exist in pod [" + ContainerExecDecorator.this.podName + "]");
                }
                catch (KubernetesClientTimeoutException | InterruptedException e) {
                    throw new IOException("Failed to execute shell script inside container [" + ContainerExecDecorator.this.containerName + "] of pod [" + ContainerExecDecorator.this.podName + "]. Timed out waiting for container to become ready!", e);
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.closables == null) {
            return;
        }
        for (Closeable closable : this.closables) {
            try {
                closable.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "failed to close {0}");
            }
        }
    }

    private static void doExec(ExecWatch watch, PrintStream out, String ... statements) {
        try {
            out.print("Executing command: ");
            StringBuilder sb = new StringBuilder();
            for (String stmt : statements) {
                String s = String.format("\"%s\" ", stmt);
                sb.append(s);
                out.print(s);
                watch.getInput().write(s.getBytes(StandardCharsets.UTF_8));
            }
            sb.append("\n");
            out.println();
            watch.getInput().write("\n".getBytes(StandardCharsets.UTF_8));
            sb.append("printf \"EXITCODE %3d\" $?; exit\n");
            out.print("printf \"EXITCODE %3d\" $?; exit\n");
            LOGGER.log(Level.FINEST, "Executing command: {0}", sb);
            watch.getInput().write("printf \"EXITCODE %3d\" $?; exit\n".getBytes(StandardCharsets.UTF_8));
            out.flush();
            watch.getInput().flush();
        }
        catch (IOException e) {
            e.printStackTrace(out);
            throw new RuntimeException(e);
        }
    }

    static int readPidFromPsCommand(String ... commands) {
        if (commands.length == 4 && "ps".equals(commands[0]) && "-o".equals(commands[1]) && commands[2].equals("pid=")) {
            return Integer.parseInt(commands[3]);
        }
        if (commands.length == 4 && "ps".equals(commands[0]) && "-o".equals(commands[1]) && commands[2].startsWith("-pid")) {
            return Integer.parseInt(commands[3]);
        }
        return -1;
    }

    private synchronized int readPidFromPidFile(String ... commands) throws IOException, InterruptedException {
        int pid = -1;
        String pidFilePath = ContainerExecDecorator.readPidFile(commands);
        if (pidFilePath == null) {
            return pid;
        }
        FilePath pidFile = this.ws.child(pidFilePath);
        for (int w = 0; w < 10 && !pidFile.exists(); ++w) {
            try {
                this.wait(1000L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        if (pidFile.exists()) {
            try {
                pid = Integer.parseInt(pidFile.readToString().trim());
            }
            catch (NumberFormatException x) {
                throw new IOException("corrupted content in " + pidFile + ": " + x, x);
            }
        }
        return pid;
    }

    @CheckForNull
    static String readPidFile(String ... commands) {
        if (commands.length >= 4 && "nohup".equals(commands[0]) && "sh".equals(commands[1]) && commands[2].equals("-c") && commands[3].startsWith("echo \\$\\$ >")) {
            return commands[3].substring(13, commands[3].indexOf(";") - 1);
        }
        return null;
    }

    static String[] getCommands(Launcher.ProcStarter starter) {
        ArrayList<String> allCommands = new ArrayList<String>();
        for (String cmd : starter.cmds()) {
            allCommands.add(cmd.replaceAll("\\$\\$", "\\\\\\$"));
        }
        return allCommands.toArray(new String[allCommands.size()]);
    }

    private static Long containerReadyTimeout() {
        String timeout = System.getProperty(CONTAINER_READY_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(5L));
        try {
            return Long.parseLong(timeout);
        }
        catch (NumberFormatException e) {
            return 5L;
        }
    }

    private static void closeWatch(ExecWatch watch) {
        try {
            watch.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "failed to close watch", e);
        }
    }

    public void setKubernetesClient(KubernetesClient client) {
        this.client = client;
    }

    static class ExitCodeOutputStream
    extends OutputStream {
        public static final String EXIT_COMMAND_TXT = "EXITCODE";
        public static final String EXIT_COMMAND = "printf \"EXITCODE %3d\" $?; exit\n";
        private EvictingQueue<Integer> queue = EvictingQueue.create(20);

        @Override
        public void write(int b) throws IOException {
            this.queue.add(b);
            byte[] bb = new byte[]{(byte)b};
            System.out.print(new String(bb, StandardCharsets.UTF_8));
        }

        public int getExitCode() {
            ByteBuffer b = ByteBuffer.allocate(this.queue.size());
            this.queue.stream().filter(Objects::nonNull).forEach(i -> b.put((byte)i.intValue()));
            int i2 = 1;
            String s = new String(b.array(), StandardCharsets.UTF_8);
            if (s.indexOf(EXIT_COMMAND_TXT) < 0) {
                LOGGER.log(Level.WARNING, "Unable to find \"{0}\" in {1}", new Object[]{EXIT_COMMAND_TXT, s});
                return i2;
            }
            int start = s.indexOf(EXIT_COMMAND_TXT) + EXIT_COMMAND_TXT.length();
            s = s.substring(start, start + 4).trim();
            try {
                i2 = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Unable to parse exit code as integer: \"{0}\" {1} / {2}", new Object[]{s, this.queue.toString(), Arrays.toString(b.array())});
            }
            return i2;
        }
    }
}

