/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.model;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.SecretKeySelectorBuilder;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class SecretEnvVar
extends TemplateEnvVar {
    private static final long serialVersionUID = -7481523353781581248L;
    private String secretName;
    private String secretKey;

    @DataBoundConstructor
    public SecretEnvVar(String key, String secretName, String secretKey) {
        super(key);
        this.secretName = secretName;
        this.secretKey = secretKey;
    }

    @Override
    public EnvVar buildEnvVar() {
        return ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(this.getKey())).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withSecretKeyRef(((SecretKeySelectorBuilder)((SecretKeySelectorBuilder)new SecretKeySelectorBuilder().withKey(this.secretKey)).withName(this.secretName)).build())).build())).build();
    }

    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public String toString() {
        return "SecretEnvVar [secretName=" + this.secretName + ", secretKey=" + this.secretKey + ", getKey()=" + this.getKey() + "]";
    }

    @Extension
    @Symbol(value={"secretEnvVar"})
    public static class DescriptorImpl
    extends Descriptor<TemplateEnvVar> {
        public String getDisplayName() {
            return "Environment Variable from Secret";
        }
    }
}

