/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes.workspace;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class NfsWorkspaceVolume
extends WorkspaceVolume {
    private String serverAddress;
    private String serverPath;
    @CheckForNull
    private Boolean readOnly;

    @DataBoundConstructor
    public NfsWorkspaceVolume(String serverAddress, String serverPath, Boolean readOnly) {
        this.serverAddress = serverAddress;
        this.serverPath = serverPath;
        this.readOnly = readOnly;
    }

    @Override
    public Volume buildVolume(String volumeName, String podName) {
        return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewNfs(this.getServerPath(), this.getReadOnly(), this.getServerAddress())).build();
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServerPath() {
        return this.serverPath;
    }

    @Nonnull
    public Boolean getReadOnly() {
        return this.readOnly != null && this.readOnly != false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NfsWorkspaceVolume that = (NfsWorkspaceVolume)o;
        return Objects.equals(this.serverAddress, that.serverAddress) && Objects.equals(this.serverPath, that.serverPath) && Objects.equals(this.readOnly, that.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.serverAddress, this.serverPath, this.readOnly);
    }

    @Extension
    @Symbol(value={"nfsWorkspaceVolume"})
    public static class DescriptorImpl
    extends Descriptor<WorkspaceVolume> {
        public String getDisplayName() {
            return "NFS Workspace Volume";
        }
    }
}

