/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.slaves.NodeProvisioner;
import java.io.IOException;
import java.util.concurrent.Future;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PlannedNodeBuilder;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;

public class StandardPlannedNodeBuilder
extends PlannedNodeBuilder {
    @Override
    public NodeProvisioner.PlannedNode build() {
        ListenableFuture f;
        String displayName;
        KubernetesCloud cloud = this.getCloud();
        PodTemplate t = this.getTemplate();
        try {
            KubernetesSlave agent = KubernetesSlave.builder().podTemplate(cloud.getUnwrappedTemplate(t)).cloud(cloud).build();
            displayName = agent.getDisplayName();
            f = Futures.immediateFuture((Object)((Object)agent));
        }
        catch (Descriptor.FormException | IOException e) {
            displayName = null;
            f = Futures.immediateFailedFuture((Throwable)e);
        }
        return new NodeProvisioner.PlannedNode(Util.fixNull(displayName), (Future)f, this.getNumExecutors());
    }
}

