/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Queue;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public final class PodUtils {
    private static final Logger LOGGER = Logger.getLogger(PodUtils.class.getName());
    public static final Predicate<ContainerStatus> CONTAINER_IS_TERMINATED = cs -> cs.getState().getTerminated() != null;
    public static final Predicate<ContainerStatus> CONTAINER_IS_WAITING = cs -> cs.getState().getWaiting() != null;

    @NonNull
    public static List<ContainerStatus> getTerminatedContainers(Pod pod) {
        return PodUtils.getContainers(pod, CONTAINER_IS_TERMINATED);
    }

    public static List<ContainerStatus> getWaitingContainers(Pod pod) {
        return PodUtils.getContainers(pod, CONTAINER_IS_WAITING);
    }

    public static List<ContainerStatus> getContainerStatus(Pod pod) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return Collections.emptyList();
        }
        return podStatus.getContainerStatuses();
    }

    public static List<ContainerStatus> getContainers(Pod pod, Predicate<ContainerStatus> predicate) {
        return PodUtils.getContainerStatus(pod).stream().filter(predicate).collect(Collectors.toList());
    }

    public static void cancelQueueItemFor(Pod pod, String reason) {
        Queue q = Jenkins.get().getQueue();
        boolean cancelled = false;
        for (Queue.Item item : q.getItems()) {
            Queue.Task task = item.task;
            if (!task.getUrl().equals(pod.getMetadata().getAnnotations().get("runUrl"))) continue;
            LOGGER.log(Level.FINE, "Cancelling queue item: \"{0}\"\n{1}", new Object[]{task.getDisplayName(), !StringUtils.isBlank((String)reason) ? "due to " + reason : ""});
            q.cancel(item);
            cancelled = true;
            break;
        }
        if (!cancelled) {
            LOGGER.log(Level.FINE, "No queue item found for pod: {0}/{1}", new Object[]{pod.getMetadata().getNamespace(), pod.getMetadata().getName()});
        }
    }
}

