/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class PodLabel
extends AbstractDescribableImpl<PodLabel>
implements Serializable {
    private static final long serialVersionUID = -5667326362260252552L;
    private String key;
    private String value;

    @DataBoundConstructor
    public PodLabel(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Nonnull
    static Map<String, String> toMap(@Nonnull Iterable<PodLabel> labels) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PodLabel podLabel : labels) {
            builder.put((Object)podLabel.getKey(), (Object)PodTemplateUtils.substituteEnv(podLabel.getValue()));
        }
        return builder.build();
    }

    @Nonnull
    static List<PodLabel> fromMap(@Nonnull Map<String, String> labels) {
        ArrayList<PodLabel> list = new ArrayList<PodLabel>();
        for (Map.Entry<String, String> label : labels.entrySet()) {
            list.add(new PodLabel(label.getKey(), label.getValue()));
        }
        return list;
    }

    static List<PodLabel> listOf(String ... keyValue) {
        Validate.isTrue((keyValue.length % 2 == 0 ? 1 : 0) != 0, (String)"Expecting an even number of arguments");
        ArrayList<PodLabel> labels = new ArrayList<PodLabel>();
        for (int i = 0; i < keyValue.length / 2; ++i) {
            labels.add(new PodLabel(keyValue[2 * i], keyValue[2 * i + 1]));
        }
        return labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodLabel that = (PodLabel)o;
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return "PodLabel(" + this.key + " = \"" + this.value + "\")";
    }

    @Extension
    @Symbol(value={"podLabel"})
    public static class DescriptorImpl
    extends Descriptor<PodLabel> {
        @Nonnull
        public String getDisplayName() {
            return "Pod Label";
        }
    }
}

