/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.slaves.Cloud;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class KubernetesFolderProperty
extends AbstractFolderProperty<AbstractFolder<?>> {
    private static final Logger LOGGER = Logger.getLogger(KubernetesFolderProperty.class.getName());
    private Set<String> permittedClouds = new HashSet<String>();
    private static String PREFIX_USAGE_PERMISSION = "usage-permission-";

    @DataBoundConstructor
    public KubernetesFolderProperty() {
    }

    private Set<String> getPermittedClouds() {
        return this.permittedClouds;
    }

    private Set<String> getInheritedClouds() {
        HashSet<String> inheritedPermissions = new HashSet<String>();
        KubernetesFolderProperty.collectAllowedClouds(inheritedPermissions, this.getOwner().getParent());
        return inheritedPermissions;
    }

    @Restricted(value={DoNotUse.class})
    public List<UsagePermission> getEffectivePermissions() {
        List<UsagePermission> ps = KubernetesFolderProperty.buildPermissions();
        Set<String> inheritedClouds = this.getInheritedClouds();
        for (UsagePermission p : ps) {
            if (inheritedClouds.contains(p.name)) {
                p.setGranted(true);
                p.setInherited(true);
            }
            if (!this.getPermittedClouds().contains(p.name)) continue;
            p.setGranted(true);
        }
        if (!KubernetesFolderProperty.userHasAdministerPermission()) {
            ps = ps.stream().filter(UsagePermission::isGranted).collect(Collectors.toList());
        }
        return ps;
    }

    private static List<UsagePermission> buildPermissions() {
        ArrayList<UsagePermission> ps = new ArrayList<UsagePermission>();
        for (KubernetesCloud kubernetesCloud : KubernetesFolderProperty.getUsageRestrictedKubernetesClouds()) {
            UsagePermission p = new UsagePermission();
            p.setName(kubernetesCloud.name);
            ps.add(p);
        }
        return ps;
    }

    public AbstractFolderProperty<?> reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        if (form == null) {
            return null;
        }
        if (!KubernetesFolderProperty.userHasAdministerPermission()) {
            return this;
        }
        try {
            HashSet<String> inheritedGrants = new HashSet<String>();
            KubernetesFolderProperty.collectAllowedClouds(inheritedGrants, this.getOwner().getParent());
            HashSet<String> permittedClouds = new HashSet<String>();
            JSONArray names = form.names();
            if (names != null) {
                for (Object name : names) {
                    String strName = (String)name;
                    if (!strName.startsWith(PREFIX_USAGE_PERMISSION) || !form.getBoolean(strName)) continue;
                    String cloud = StringUtils.replaceOnce((String)strName, (String)PREFIX_USAGE_PERMISSION, (String)"");
                    if (!KubernetesFolderProperty.isUsageRestrictedKubernetesCloud(Jenkins.get().getCloud(cloud)) || inheritedGrants.contains(cloud)) continue;
                    permittedClouds.add(cloud);
                }
            }
            this.permittedClouds.clear();
            this.permittedClouds.addAll(permittedClouds);
        }
        catch (JSONException e) {
            LOGGER.log(Level.SEVERE, e, () -> "reconfigure failed: " + e.getMessage());
        }
        return this;
    }

    public static void collectAllowedClouds(Set<String> allowedClouds, ItemGroup<?> itemGroup) {
        if (itemGroup instanceof AbstractFolder) {
            AbstractFolder folder = (AbstractFolder)itemGroup;
            KubernetesFolderProperty kubernetesFolderProperty = (KubernetesFolderProperty)folder.getProperties().get(KubernetesFolderProperty.class);
            if (kubernetesFolderProperty != null) {
                allowedClouds.addAll(kubernetesFolderProperty.getPermittedClouds());
            }
            KubernetesFolderProperty.collectAllowedClouds(allowedClouds, folder.getParent());
        }
    }

    private static List<KubernetesCloud> getUsageRestrictedKubernetesClouds() {
        List<KubernetesCloud> clouds = Jenkins.get().clouds.getAll(KubernetesCloud.class).stream().filter(KubernetesCloud::isUsageRestricted).collect(Collectors.toList());
        Collections.sort(clouds, Comparator.comparing(o -> o.name));
        return clouds;
    }

    private static boolean userHasAdministerPermission() {
        return Jenkins.get().hasPermission(Jenkins.ADMINISTER);
    }

    private static boolean isUsageRestrictedKubernetesCloud(Cloud cloud) {
        if (cloud instanceof KubernetesCloud) {
            return ((KubernetesCloud)cloud).isUsageRestricted();
        }
        return false;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        @Nonnull
        public String getDisplayName() {
            return Messages.KubernetesFolderProperty_displayName();
        }
    }

    public static class UsagePermission {
        private boolean granted;
        private boolean inherited;
        private String name;

        private void setInherited(boolean inherited) {
            this.inherited = inherited;
        }

        public boolean isInherited() {
            return this.inherited;
        }

        private void setGranted(boolean granted) {
            this.granted = granted;
        }

        public boolean isGranted() {
            return this.granted;
        }

        private void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name + (this.isInherited() ? " (inherited)" : "");
        }

        public String getFormName() {
            return PREFIX_USAGE_PERMISSION + this.getName();
        }

        public boolean isReadonly() {
            return !KubernetesFolderProperty.userHasAdministerPermission() || this.isInherited();
        }
    }
}

