/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.AbortException;
import hudson.model.Node;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.io.Serializable;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.jenkinsci.plugins.workflow.steps.StepContext;

class KubernetesNodeContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StepContext context;
    private String podName;
    private String namespace;

    KubernetesNodeContext(StepContext context) throws Exception {
        this.context = context;
        KubernetesSlave agent = this.getKubernetesSlave();
        this.podName = agent.getPodName();
        this.namespace = agent.getNamespace();
    }

    String getPodName() throws Exception {
        return this.podName;
    }

    public String getNamespace() throws Exception {
        return this.namespace;
    }

    KubernetesClient connectToCloud() throws Exception {
        return this.getKubernetesSlave().getKubernetesCloud().connect();
    }

    private KubernetesSlave getKubernetesSlave() throws IOException, InterruptedException {
        Node node = (Node)this.context.get(Node.class);
        if (!(node instanceof KubernetesSlave)) {
            throw new AbortException(String.format("Node is not a Kubernetes node: %s", node != null ? node.getNodeName() : null));
        }
        return (KubernetesSlave)node;
    }
}

