/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.LauncherDecorator;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.util.DescribableList;
import java.io.Closeable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecDecorator;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerStep;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.KubernetesNodeContext;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.Resources;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class ContainerStepExecution
extends StepExecution {
    private static final long serialVersionUID = 7634132798345235774L;
    private static final transient Logger LOGGER = Logger.getLogger(ContainerStepExecution.class.getName());
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private final transient ContainerStep step;
    private ContainerExecDecorator decorator;

    ContainerStepExecution(ContainerStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        LOGGER.log(Level.FINE, "Starting container step.");
        String containerName = this.step.getName();
        String shell = this.step.getShell();
        KubernetesNodeContext nodeContext = new KubernetesNodeContext(this.getContext());
        EnvironmentExpander env = (EnvironmentExpander)this.getContext().get(EnvironmentExpander.class);
        EnvVars globalVars = null;
        Jenkins instance = Jenkins.getInstance();
        DescribableList globalNodeProperties = instance.getGlobalNodeProperties();
        List envVarsNodePropertyList = globalNodeProperties.getAll(EnvironmentVariablesNodeProperty.class);
        if (envVarsNodePropertyList != null && envVarsNodePropertyList.size() != 0) {
            globalVars = ((EnvironmentVariablesNodeProperty)envVarsNodePropertyList.get(0)).getEnvVars();
        }
        EnvVars rcEnvVars = null;
        Run run = (Run)this.getContext().get(Run.class);
        TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
        if (run != null && taskListener != null) {
            rcEnvVars = run.getEnvironment(taskListener);
        }
        this.decorator = new ContainerExecDecorator();
        this.decorator.setNodeContext(nodeContext);
        this.decorator.setContainerName(containerName);
        this.decorator.setEnvironmentExpander(env);
        this.decorator.setWs((FilePath)this.getContext().get(FilePath.class));
        this.decorator.setGlobalVars(globalVars);
        this.decorator.setRunContextEnvVars(rcEnvVars);
        this.decorator.setShell(shell);
        this.getContext().newBodyInvoker().withContext((Object)BodyInvoker.mergeLauncherDecorators((LauncherDecorator)((LauncherDecorator)this.getContext().get(LauncherDecorator.class)), (LauncherDecorator)this.decorator)).withCallback((BodyExecutionCallback)new ContainerExecCallback(new Closeable[]{this.decorator})).start();
        return false;
    }

    public void stop(@Nonnull Throwable cause) throws Exception {
        LOGGER.log(Level.FINE, "Stopping container step.");
        Resources.closeQuietly(this.getContext(), this.decorator);
    }

    private static class ContainerExecCallback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 6385838254761750483L;
        private final Closeable[] closeables;

        private ContainerExecCallback(Closeable ... closeables) {
            this.closeables = closeables;
        }

        public void finished(StepContext context) {
            Resources.closeQuietly(context, this.closeables);
        }
    }
}

