/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.model.Computer;
import hudson.model.Node;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecable;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Response;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecProc;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.KubernetesNodeContext;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;

public class ContainerExecDecorator
extends LauncherDecorator
implements Serializable,
Closeable {
    private static final long serialVersionUID = 4419929753433397655L;
    private static final long DEFAULT_CONTAINER_READY_TIMEOUT = 5L;
    private static final String CONTAINER_READY_TIMEOUT_SYSTEM_PROPERTY = ContainerExecDecorator.class.getName() + ".containerReadyTimeout";
    private static final String WEBSOCKET_CONNECTION_TIMEOUT_SYSTEM_PROPERTY = ContainerExecDecorator.class.getName() + ".websocketConnectionTimeout";
    private static final int WEBSOCKET_CONNECTION_TIMEOUT = Integer.getInteger(WEBSOCKET_CONNECTION_TIMEOUT_SYSTEM_PROPERTY, 30);
    private static final long CONTAINER_READY_TIMEOUT = ContainerExecDecorator.containerReadyTimeout();
    private static final String COOKIE_VAR = "JENKINS_SERVER_COOKIE";
    private static final Logger LOGGER = Logger.getLogger(ContainerExecDecorator.class.getName());
    private static final int STDIN_BUFFER_SIZE = Integer.getInteger(ContainerExecDecorator.class.getName() + ".stdinBufferSize", 16384);
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private transient List<Closeable> closables;
    private String containerName;
    private EnvironmentExpander environmentExpander;
    private EnvVars globalVars;
    @Deprecated
    private FilePath ws;
    private EnvVars rcEnvVars;
    private String shell;
    private KubernetesNodeContext nodeContext;

    public ContainerExecDecorator() {
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace, EnvironmentExpander environmentExpander, FilePath ws) {
        this.containerName = containerName;
        this.environmentExpander = environmentExpander;
        this.ws = ws;
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace, EnvironmentExpander environmentExpander) {
        this(client, podName, containerName, namespace, environmentExpander, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace) {
        this(client, podName, containerName, namespace, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished, String namespace) {
        this(client, podName, containerName, namespace, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished) {
        this(client, podName, containerName, (String)null, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String path, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished) {
        this(client, podName, containerName, (String)null, null, null);
    }

    @Deprecated
    public KubernetesClient getClient() {
        try {
            return this.nodeContext.connectToCloud();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setClient(KubernetesClient client) {
    }

    @Deprecated
    public String getPodName() {
        try {
            return this.getNodeContext().getPodName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setPodName(String podName) {
    }

    @Deprecated
    public String getNamespace() {
        try {
            return this.getNodeContext().getNamespace();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setNamespace(String namespace) {
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public EnvironmentExpander getEnvironmentExpander() {
        return this.environmentExpander;
    }

    public void setEnvironmentExpander(EnvironmentExpander environmentExpander) {
        this.environmentExpander = environmentExpander;
    }

    public EnvVars getGlobalVars() {
        return this.globalVars;
    }

    public void setGlobalVars(EnvVars globalVars) {
        this.globalVars = globalVars;
    }

    public void setRunContextEnvVars(EnvVars rcVars) {
        this.rcEnvVars = rcVars;
    }

    public EnvVars getRunContextEnvVars() {
        return this.rcEnvVars;
    }

    @Deprecated
    public FilePath getWs() {
        return this.ws;
    }

    public void setWs(FilePath ws) {
        this.ws = ws;
    }

    public void setShell(String shell) {
        this.shell = shell;
    }

    public KubernetesNodeContext getNodeContext() {
        return this.nodeContext;
    }

    public void setNodeContext(KubernetesNodeContext nodeContext) {
        this.nodeContext = nodeContext;
    }

    public Launcher decorate(final Launcher launcher, final Node node) {
        return new Launcher.DecoratedLauncher(launcher){

            public Proc launch(Launcher.ProcStarter starter) throws IOException {
                Computer computer;
                LOGGER.log(Level.FINEST, "Launch proc with environment: {0}", Arrays.toString(starter.envs()));
                KubernetesSlave slave = (KubernetesSlave)node;
                FilePath containerWorkingDirFilePath = starter.pwd();
                String containerWorkingDirFilePathStr = containerWorkingDirFilePath != null ? containerWorkingDirFilePath.getRemote() : "/home/jenkins/agent";
                String containerWorkingDirStr = "/home/jenkins/agent";
                if (slave != null && slave.getPod().isPresent() && ContainerExecDecorator.this.containerName != null) {
                    Optional<Container> container = slave.getPod().get().getSpec().getContainers().stream().filter(container1 -> container1.getName().equals(ContainerExecDecorator.this.containerName)).findAny();
                    Optional<Object> containerWorkingDir = Optional.empty();
                    if (container.isPresent() && container.get().getWorkingDir() != null) {
                        containerWorkingDir = Optional.of(container.get().getWorkingDir());
                    }
                    if (containerWorkingDir.isPresent()) {
                        containerWorkingDirStr = (String)containerWorkingDir.get();
                    }
                    if (containerWorkingDir.isPresent() && containerWorkingDirFilePath != null && !containerWorkingDirFilePath.getRemote().startsWith(containerWorkingDirStr)) {
                        containerWorkingDirFilePathStr = containerWorkingDirFilePath.getRemote().replaceFirst("/home/jenkins/agent", containerWorkingDirStr);
                        containerWorkingDirFilePath = new FilePath(containerWorkingDirFilePath.getChannel(), containerWorkingDirFilePathStr);
                        LOGGER.log(Level.FINEST, "Modified the pwd to match {0} containers workspace directory : {1}", new String[]{ContainerExecDecorator.this.containerName, containerWorkingDirFilePathStr});
                    }
                }
                String[] envVars = starter.envs();
                if (!containerWorkingDirStr.equals("/home/jenkins/agent")) {
                    for (int i = 0; i < envVars.length; ++i) {
                        String keyValue = envVars[i];
                        String[] split = keyValue.split("=", 2);
                        if (!split[1].startsWith("/home/jenkins/agent")) continue;
                        split[1] = split[1].replaceFirst("/home/jenkins/agent", containerWorkingDirStr);
                        envVars[i] = split[0] + "=" + split[1];
                        LOGGER.log(Level.FINEST, "Updated the starter environment variable, key: {0}, Value: {1}", new String[]{split[0], split[1]});
                    }
                }
                if (node != null && (computer = node.toComputer()) != null) {
                    ArrayList<String> resultEnvVar = new ArrayList<String>();
                    try {
                        EnvVars environment = computer.getEnvironment();
                        if (environment != null) {
                            HashSet<String> overriddenKeys = new HashSet<String>();
                            for (String keyValue : envVars) {
                                String[] split = keyValue.split("=", 2);
                                if (split[1].equals(environment.get((Object)split[0]))) continue;
                                resultEnvVar.add(keyValue);
                                overriddenKeys.add(split[0]);
                            }
                            if (!containerWorkingDirStr.equals("/home/jenkins/agent")) {
                                for (Map.Entry entry : environment.entrySet()) {
                                    String keyValue;
                                    if (!((String)entry.getValue()).startsWith("/home/jenkins/agent") || overriddenKeys.contains(entry.getKey())) continue;
                                    String newValue = ((String)entry.getValue()).replaceFirst("/home/jenkins/agent", containerWorkingDirStr);
                                    keyValue = (String)entry.getKey() + "=" + newValue;
                                    LOGGER.log(Level.FINEST, "Updated the value for envVar, key: {0}, Value: {1}", new String[]{(String)entry.getKey(), newValue});
                                    resultEnvVar.add(keyValue);
                                }
                            }
                            envVars = resultEnvVar.toArray(new String[resultEnvVar.size()]);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Unable to retrieve environment variables", e);
                    }
                }
                return this.doLaunch(starter.quiet(), envVars, starter.stdout(), containerWorkingDirFilePath, starter.masks(), ContainerExecDecorator.getCommands(starter, containerWorkingDirFilePathStr));
            }

            private Proc doLaunch(boolean quiet, String[] cmdEnvs, OutputStream outputForCaller, FilePath pwd, boolean[] masks, String ... commands) throws IOException {
                ExecWatch watch;
                PrintStream printStream;
                final CountDownLatch started = new CountDownLatch(1);
                final CountDownLatch finished = new CountDownLatch(1);
                final AtomicBoolean alive = new AtomicBoolean(false);
                final AtomicLong startAlive = new AtomicLong();
                long startMethod = System.nanoTime();
                PrintStream stream = printStream = launcher.getListener().getLogger();
                if (quiet) {
                    stream = new NullOutputStream();
                    printStream = new PrintStream((OutputStream)stream, false, StandardCharsets.UTF_8.toString());
                }
                if (outputForCaller != null && !outputForCaller.equals(stream)) {
                    stream = new TeeOutputStream(outputForCaller, (OutputStream)stream);
                }
                ByteArrayOutputStream error = new ByteArrayOutputStream();
                String sh = ContainerExecDecorator.this.shell != null ? ContainerExecDecorator.this.shell : (launcher.isUnix() ? "sh" : "cmd");
                String msg = "Executing " + sh + " script inside container " + ContainerExecDecorator.this.containerName + " of pod " + ContainerExecDecorator.this.getPodName();
                LOGGER.log(Level.FINEST, msg);
                printStream.println(msg);
                if (ContainerExecDecorator.this.closables == null) {
                    ContainerExecDecorator.this.closables = new ArrayList();
                }
                Execable execable = (Execable)((TtyExecable)((TtyExecErrorChannelable)((TtyExecErrorable)((TtyExecOutputErrorable)((ContainerResource)((PodResource)((NonNamespaceOperation)ContainerExecDecorator.this.getClient().pods().inNamespace(ContainerExecDecorator.this.getNamespace())).withName(ContainerExecDecorator.this.getPodName())).inContainer((Object)ContainerExecDecorator.this.containerName)).redirectingInput(Integer.valueOf(STDIN_BUFFER_SIZE))).writingOutput((Object)stream)).writingError((Object)stream)).writingErrorChannel((Object)error)).usingListener((Object)new ExecListener(){

                    public void onOpen(Response response) {
                        alive.set(true);
                        started.countDown();
                        startAlive.set(System.nanoTime());
                        LOGGER.log(Level.FINEST, "onOpen : {0}", finished);
                    }

                    public void onFailure(Throwable t, Response response) {
                        alive.set(false);
                        t.printStackTrace(launcher.getListener().getLogger());
                        started.countDown();
                        LOGGER.log(Level.FINEST, "onFailure : {0}", finished);
                        if (finished.getCount() == 0L) {
                            LOGGER.log(Level.WARNING, "onFailure called but latch already finished. This may be a bug in the kubernetes-plugin");
                        }
                        finished.countDown();
                    }

                    public void onClose(int i, String s) {
                        alive.set(false);
                        started.countDown();
                        LOGGER.log(Level.FINEST, "onClose : {0} [{1} ms]", new Object[]{finished, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startAlive.get())});
                        if (finished.getCount() == 0L) {
                            LOGGER.log(Level.WARNING, "onClose called but latch already finished. This indicates a bug in the kubernetes-plugin");
                        }
                        finished.countDown();
                    }
                });
                try {
                    watch = (ExecWatch)execable.exec((Object[])new String[]{sh});
                }
                catch (KubernetesClientException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        throw new IOException("Interrupted while starting websocket connection, you should increase the Max connections to Kubernetes API", e);
                    }
                    throw e;
                }
                catch (RejectedExecutionException e) {
                    throw new IOException("Connection was rejected, you should increase the Max connections to Kubernetes API", e);
                }
                boolean hasStarted = false;
                try {
                    hasStarted = started.await(WEBSOCKET_CONNECTION_TIMEOUT, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    ContainerExecDecorator.closeWatch(watch);
                    throw new IOException("Interrupted while waiting for websocket connection, you should increase the Max connections to Kubernetes API", e);
                }
                if (!hasStarted) {
                    ContainerExecDecorator.closeWatch(watch);
                    throw new IOException("Timed out waiting for websocket connection. You should increase the value of system property " + WEBSOCKET_CONNECTION_TIMEOUT_SYSTEM_PROPERTY + " currently set at " + WEBSOCKET_CONNECTION_TIMEOUT + " seconds");
                }
                try {
                    OutputStream stdin = watch.getInput();
                    PrintStream in = new PrintStream(stdin, true, StandardCharsets.UTF_8.name());
                    if (pwd != null) {
                        in.println(String.format("cd \"%s\"", pwd));
                    }
                    EnvVars envVars = new EnvVars();
                    if (ContainerExecDecorator.this.globalVars != null) {
                        envVars.overrideAll((Map)ContainerExecDecorator.this.globalVars);
                    }
                    if (ContainerExecDecorator.this.rcEnvVars != null) {
                        envVars.overrideAll((Map)ContainerExecDecorator.this.rcEnvVars);
                    }
                    if (ContainerExecDecorator.this.environmentExpander != null) {
                        ContainerExecDecorator.this.environmentExpander.expand(envVars);
                    }
                    if (cmdEnvs != null) {
                        for (String cmdEnv : cmdEnvs) {
                            envVars.addLine(cmdEnv);
                        }
                    }
                    LOGGER.log(Level.FINEST, "Launching with env vars: {0}", envVars.toString());
                    this.setupEnvironmentVariable(envVars, in, sh.equals("cmd"));
                    ContainerExecDecorator.doExec(in, printStream, masks, commands);
                    LOGGER.log(Level.INFO, "Created process inside pod: [" + ContainerExecDecorator.this.getPodName() + "], container: [" + ContainerExecDecorator.this.containerName + "][" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startMethod) + " ms]");
                    ContainerExecProc proc = new ContainerExecProc(watch, alive, finished, stdin, error);
                    ContainerExecDecorator.this.closables.add(proc);
                    return proc;
                }
                catch (InterruptedException ie) {
                    throw new InterruptedIOException(ie.getMessage());
                }
                catch (Exception e) {
                    ContainerExecDecorator.closeWatch(watch);
                    throw e;
                }
            }

            public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                this.getListener().getLogger().println("Killing processes");
                String cookie = modelEnvVars.get(ContainerExecDecorator.COOKIE_VAR);
                int exitCode = this.doLaunch(true, null, null, null, null, "sh", "-c", "kill \\`grep -l 'JENKINS_SERVER_COOKIE=" + cookie + "' /proc/*/environ | cut -d / -f 3 \\`").join();
                this.getListener().getLogger().println("kill finished with exit code " + exitCode);
            }

            private void setupEnvironmentVariable(EnvVars vars, PrintStream out, boolean windows) throws IOException {
                for (Map.Entry entry : vars.entrySet()) {
                    if (!((String)entry.getKey()).matches("[a-zA-Z_][a-zA-Z0-9_]*")) continue;
                    out.println(String.format(windows ? "set %s=%s" : "export %s='%s'", entry.getKey(), windows ? entry.getValue() : ((String)entry.getValue()).replace("'", "'\\''")));
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.closables == null) {
            return;
        }
        for (Closeable closable : this.closables) {
            try {
                closable.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "failed to close {0}");
            }
        }
    }

    private static void doExec(PrintStream in, PrintStream out, boolean[] masks, String ... statements) {
        long start = System.nanoTime();
        ByteArrayOutputStream loggingOutput = new ByteArrayOutputStream();
        TeeOutputStream teeOutput = new TeeOutputStream((OutputStream)out, (OutputStream)loggingOutput);
        MaskOutputStream maskedOutput = new MaskOutputStream((OutputStream)teeOutput, masks);
        PrintStream tee = null;
        try {
            String encoding = StandardCharsets.UTF_8.name();
            tee = new PrintStream((OutputStream)new TeeOutputStream((OutputStream)in, (OutputStream)maskedOutput), false, encoding);
            PrintStream unmasked = new PrintStream((OutputStream)teeOutput, false, encoding);
            unmasked.print("Executing command: ");
            for (int i = 0; i < statements.length; ++i) {
                tee.append("\"").append(statements[i]).append("\" ");
            }
            tee.println();
            LOGGER.log(Level.FINEST, loggingOutput.toString(encoding) + "[" + TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - start) + " \u03bcs.]");
            tee.println("exit");
            tee.flush();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    static String[] getCommands(Launcher.ProcStarter starter, String containerWorkingDirStr) {
        ArrayList<String> allCommands = new ArrayList<String>();
        for (String cmd : starter.cmds()) {
            String fixedCommand = cmd.replaceAll("\\$\\$", "\\\\\\$");
            String oldRemoteDir = null;
            FilePath oldRemoteDirFilepath = starter.pwd();
            if (oldRemoteDirFilepath != null) {
                oldRemoteDir = oldRemoteDirFilepath.getRemote();
            }
            if (oldRemoteDir != null && !oldRemoteDir.isEmpty() && !oldRemoteDir.equals(containerWorkingDirStr) && fixedCommand.contains(oldRemoteDir)) {
                fixedCommand = fixedCommand.replaceAll(oldRemoteDir, containerWorkingDirStr);
            }
            allCommands.add(fixedCommand);
        }
        return allCommands.toArray(new String[allCommands.size()]);
    }

    private static Long containerReadyTimeout() {
        String timeout = System.getProperty(CONTAINER_READY_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(5L));
        try {
            return Long.parseLong(timeout);
        }
        catch (NumberFormatException e) {
            return 5L;
        }
    }

    private static void closeWatch(ExecWatch watch) {
        try {
            watch.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "failed to close watch", e);
        }
    }

    @Deprecated
    public void setKubernetesClient(KubernetesClient client) {
    }

    private static class MaskOutputStream
    extends FilterOutputStream {
        private static final String MASK_STRING = "********";
        private final boolean[] masks;
        private static final char SEPARATOR = ' ';
        private int index;
        private boolean wrote;

        public MaskOutputStream(OutputStream out, boolean[] masks) {
            super(out);
            this.masks = masks;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.masks == null || this.index >= this.masks.length) {
                this.out.write(b);
            } else if (this.isSeparator(b)) {
                this.out.write(b);
                ++this.index;
                this.wrote = false;
            } else if (this.masks[this.index]) {
                if (!this.wrote) {
                    this.wrote = true;
                    for (char c : MASK_STRING.toCharArray()) {
                        this.out.write(c);
                    }
                }
            } else {
                this.out.write(b);
            }
        }

        private boolean isSeparator(int b) {
            return b == 32;
        }
    }
}

