/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.TcpSlaveAgentListener;
import hudson.slaves.SlaveComputer;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerLivenessProbe;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateStepExecution;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class PodTemplateBuilder {
    private static final Logger LOGGER = Logger.getLogger(PodTemplateBuilder.class.getName());
    private static final Pattern SPLIT_IN_SPACES = Pattern.compile("([^\"]\\S*|\".+?\")\\s*");
    private static final String WORKSPACE_VOLUME_NAME = "workspace-volume";
    @VisibleForTesting
    static final String DEFAULT_JNLP_IMAGE = System.getProperty(PodTemplateStepExecution.class.getName() + ".defaultImage", "jenkins/inbound-agent:4.3-4");
    static final String DEFAULT_JNLP_CONTAINER_MEMORY_REQUEST = System.getProperty(PodTemplateStepExecution.class.getName() + ".defaultContainer.defaultMemoryRequest", "256Mi");
    static final String DEFAULT_JNLP_CONTAINER_CPU_REQUEST = System.getProperty(PodTemplateStepExecution.class.getName() + ".defaultContainer.defaultCpuRequest", "100m");
    private static final String JNLPMAC_REF = "\\$\\{computer.jnlpmac\\}";
    private static final String NAME_REF = "\\$\\{computer.name\\}";
    private PodTemplate template;
    @CheckForNull
    private KubernetesSlave slave;

    public PodTemplateBuilder(PodTemplate template) {
        this.template = template;
    }

    public PodTemplateBuilder withSlave(KubernetesSlave slave) {
        this.slave = slave;
        return this;
    }

    @Deprecated
    public Pod build(KubernetesSlave slave) {
        LOGGER.log(Level.WARNING, "This method is deprecated and does nothing");
        return this.build();
    }

    public Pod build() {
        Pod pod;
        Map<String, String> nodeSelector;
        List imagePullSecrets;
        Map<String, String> annotations;
        HashMap<String, Volume> volumes = new HashMap<String, Volume>();
        HashMap<String, VolumeMount> volumeMounts = new HashMap<String, VolumeMount>();
        int i = 0;
        for (PodVolume podVolume : this.template.getVolumes()) {
            String volumeName = "volume-" + i;
            String mountPath = PodTemplateUtils.substituteEnv(Paths.get(podVolume.getMountPath(), new String[0]).normalize().toString().replace("\\", "/"));
            if (volumeMounts.containsKey(mountPath)) continue;
            volumeMounts.put(mountPath, ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(mountPath)).withName(volumeName)).withReadOnly(Boolean.valueOf(false))).build());
            volumes.put(volumeName, podVolume.buildVolume(volumeName));
            ++i;
        }
        volumes.put(WORKSPACE_VOLUME_NAME, this.template.getWorkspaceVolume().buildVolume(WORKSPACE_VOLUME_NAME, this.slave != null ? this.slave.getPodName() : null));
        HashMap<String, Container> containers = new HashMap<String, Container>();
        for (ContainerTemplate containerTemplate : this.template.getContainers()) {
            containers.put(containerTemplate.getName(), this.createContainer(containerTemplate, this.template.getEnvVars(), volumeMounts.values()));
        }
        PodFluent.MetadataNested metadataNested = new PodBuilder().withNewMetadata();
        if (this.slave != null) {
            metadataNested.withName(this.slave.getPodName());
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        if (this.slave != null) {
            labels.putAll(this.slave.getKubernetesCloud().getPodLabelsMap());
        }
        labels.putAll(this.template.getLabelsMap());
        if (!labels.isEmpty()) {
            metadataNested.withLabels(labels);
        }
        if (!(annotations = this.getAnnotationsMap(this.template.getAnnotations())).isEmpty()) {
            metadataNested.withAnnotations(annotations);
        }
        PodFluent.SpecNested builder = ((PodBuilder)metadataNested.endMetadata()).withNewSpec();
        if (this.template.getActiveDeadlineSeconds() > 0) {
            builder = (PodFluent.SpecNested)builder.withActiveDeadlineSeconds(Long.valueOf(this.template.getActiveDeadlineSeconds()));
        }
        if (!volumes.isEmpty()) {
            builder.withVolumes(volumes.values().toArray(new Volume[volumes.size()]));
        }
        if (this.template.getServiceAccount() != null) {
            builder.withServiceAccount(PodTemplateUtils.substituteEnv(this.template.getServiceAccount()));
        }
        if (!(imagePullSecrets = this.template.getImagePullSecrets().stream().map(x -> x.toLocalObjectReference()).collect(Collectors.toList())).isEmpty()) {
            builder.withImagePullSecrets(imagePullSecrets);
        }
        if (!(nodeSelector = this.getNodeSelectorMap(this.template.getNodeSelector())).isEmpty()) {
            builder.withNodeSelector(nodeSelector);
        }
        if (this.template.getTerminationGracePeriodSeconds() != null) {
            builder.withTerminationGracePeriodSeconds(this.template.getTerminationGracePeriodSeconds());
        }
        builder.withContainers(containers.values().toArray(new Container[containers.size()]));
        Long runAsUser = this.template.getRunAsUserAsLong();
        Long runAsGroup = this.template.getRunAsGroupAsLong();
        String supplementalGroups = this.template.getSupplementalGroups();
        if (runAsUser != null || runAsGroup != null || supplementalGroups != null) {
            PodSpecFluent.SecurityContextNested securityContext = builder.editOrNewSecurityContext();
            if (runAsUser != null) {
                securityContext.withRunAsUser(runAsUser);
            }
            if (runAsGroup != null) {
                securityContext.withRunAsGroup(runAsGroup);
            }
            if (supplementalGroups != null) {
                securityContext.withSupplementalGroups(this.parseSupplementalGroupList(supplementalGroups));
            }
            securityContext.endSecurityContext();
        }
        if (this.template.isHostNetworkSet()) {
            builder.withHostNetwork(Boolean.valueOf(this.template.isHostNetwork()));
        }
        if (StringUtils.isBlank((String)(pod = PodTemplateUtils.combine(this.template.getYamlsPod(), ((PodBuilder)builder.endSpec()).build())).getSpec().getRestartPolicy())) {
            pod.getSpec().setRestartPolicy("Never");
        }
        if (!(pod.getSpec().getNodeSelector() != null && !pod.getSpec().getNodeSelector().isEmpty() || pod.getSpec().getAffinity() != null && pod.getSpec().getAffinity().getNodeAffinity() != null)) {
            pod.getSpec().setNodeSelector(Collections.singletonMap("kubernetes.io/os", "linux"));
        }
        Optional<Container> jnlpOpt = pod.getSpec().getContainers().stream().filter(c -> "jnlp".equals(c.getName())).findFirst();
        Container jnlp = jnlpOpt.orElse(((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("jnlp")).withVolumeMounts(volumeMounts.values().toArray(new VolumeMount[volumeMounts.values().size()]))).build());
        if (!jnlpOpt.isPresent()) {
            pod.getSpec().getContainers().add(jnlp);
        }
        pod.getSpec().getContainers().stream().filter(c -> c.getWorkingDir() == null).forEach(c -> c.setWorkingDir(jnlp.getWorkingDir()));
        if (StringUtils.isBlank((String)jnlp.getImage())) {
            jnlp.setImage(DEFAULT_JNLP_IMAGE);
        }
        HashMap<String, Object> envVars = new HashMap<String, Object>();
        envVars.putAll(this.jnlpEnvVars(jnlp.getWorkingDir()));
        envVars.putAll(this.defaultEnvVars(this.template.getEnvVars()));
        envVars.putAll(jnlp.getEnv().stream().collect(Collectors.toMap(EnvVar::getName, Function.identity())));
        jnlp.setEnv(new ArrayList(envVars.values()));
        if (jnlp.getResources() == null) {
            jnlp.setResources(((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)new ContainerBuilder().editOrNewResources().addToRequests("cpu", new Quantity(DEFAULT_JNLP_CONTAINER_CPU_REQUEST))).addToRequests("memory", new Quantity(DEFAULT_JNLP_CONTAINER_MEMORY_REQUEST))).endResources()).build().getResources());
        }
        pod.getSpec().getContainers().stream().filter(c -> c.getVolumeMounts() == null).forEach(c -> c.setVolumeMounts(new ArrayList()));
        if (pod.getSpec().getVolumes().stream().noneMatch(v -> WORKSPACE_VOLUME_NAME.equals(v.getName()))) {
            pod.getSpec().getVolumes().add(((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(WORKSPACE_VOLUME_NAME)).withNewEmptyDir().endEmptyDir()).build());
        }
        pod.getSpec().getContainers().stream().filter(c -> c.getVolumeMounts().stream().noneMatch(vm -> vm.getMountPath().equals(c.getWorkingDir() != null ? c.getWorkingDir() : "/home/jenkins/agent"))).forEach(c -> c.getVolumeMounts().add(this.getDefaultVolumeMount(c.getWorkingDir())));
        LOGGER.finest(() -> "Pod built: " + Serialization.asYaml((Object)pod));
        return pod;
    }

    private Map<String, EnvVar> defaultEnvVars(Collection<TemplateEnvVar> globalEnvVars) {
        KubernetesCloud cloud;
        HashMap<String, String> env = new HashMap<String, String>();
        if (this.slave != null && (cloud = this.slave.getKubernetesCloud()).isAddMasterProxyEnvVars()) {
            String httpProxy;
            String noProxy = System.getenv("no_proxy");
            if (!StringUtils.isBlank((String)noProxy)) {
                env.put("no_proxy", noProxy);
            }
            if (!StringUtils.isBlank((String)(httpProxy = System.getenv("http_proxy")))) {
                env.put("http_proxy", httpProxy);
            }
        }
        HashMap<String, EnvVar> envVarsMap = new HashMap<String, EnvVar>();
        env.entrySet().forEach(item -> envVarsMap.put((String)item.getKey(), new EnvVar((String)item.getKey(), (String)item.getValue(), null)));
        if (globalEnvVars != null) {
            globalEnvVars.forEach(item -> envVarsMap.put(item.getKey(), item.buildEnvVar()));
        }
        return envVarsMap;
    }

    private Map<String, EnvVar> jnlpEnvVars(String workingDir) {
        if (workingDir == null) {
            workingDir = "/home/jenkins/agent";
        }
        HashMap<String, String> env = new HashMap<String, String>();
        if (this.slave != null) {
            SlaveComputer computer = this.slave.getComputer();
            if (computer != null) {
                env.put("JENKINS_SECRET", computer.getJnlpMac());
                env.put("JENKINS_NAME", computer.getName());
                env.put("JENKINS_AGENT_NAME", computer.getName());
            } else {
                LOGGER.log(Level.INFO, "Computer is null for agent: {0}", this.slave.getNodeName());
            }
            env.put("JENKINS_AGENT_WORKDIR", workingDir);
            KubernetesCloud cloud = this.slave.getKubernetesCloud();
            if (!StringUtils.isBlank((String)cloud.getJenkinsTunnel())) {
                env.put("JENKINS_TUNNEL", cloud.getJenkinsTunnel());
            }
            if (!cloud.isDirectConnection()) {
                env.put("JENKINS_URL", cloud.getJenkinsUrlOrDie());
                if (cloud.isWebSocket()) {
                    env.put("JENKINS_WEB_SOCKET", "true");
                }
            } else {
                TcpSlaveAgentListener tcpSlaveAgentListener = Jenkins.get().getTcpSlaveAgentListener();
                String host = tcpSlaveAgentListener.getAdvertisedHost();
                int port = tcpSlaveAgentListener.getAdvertisedPort();
                env.put("JENKINS_DIRECT_CONNECTION", host + ":" + port);
                env.put("JENKINS_PROTOCOLS", "JNLP4-connect");
                env.put("JENKINS_INSTANCE_IDENTITY", tcpSlaveAgentListener.getIdentityPublicKey());
            }
        }
        HashMap<String, EnvVar> envVarsMap = new HashMap<String, EnvVar>();
        env.entrySet().forEach(item -> envVarsMap.put((String)item.getKey(), new EnvVar((String)item.getKey(), (String)item.getValue(), null)));
        return envVarsMap;
    }

    private Container createContainer(ContainerTemplate containerTemplate, Collection<TemplateEnvVar> globalEnvVars, Collection<VolumeMount> volumeMounts) {
        SlaveComputer computer;
        HashMap<String, EnvVar> envVarsMap = new HashMap<String, EnvVar>();
        String workingDir = PodTemplateUtils.substituteEnv(containerTemplate.getWorkingDir());
        if ("jnlp".equals(containerTemplate.getName())) {
            envVarsMap.putAll(this.jnlpEnvVars(workingDir));
        }
        envVarsMap.putAll(this.defaultEnvVars(globalEnvVars));
        if (containerTemplate.getEnvVars() != null) {
            containerTemplate.getEnvVars().forEach(item -> envVarsMap.put(item.getKey(), item.buildEnvVar()));
        }
        EnvVar[] envVars = (EnvVar[])envVarsMap.values().stream().toArray(EnvVar[]::new);
        String cmd = containerTemplate.getArgs();
        if (this.slave != null && cmd != null && (computer = this.slave.getComputer()) != null) {
            cmd = cmd.replaceAll(JNLPMAC_REF, computer.getJnlpMac()).replaceAll(NAME_REF, computer.getName());
        }
        List<Object> arguments = Strings.isNullOrEmpty((String)containerTemplate.getArgs()) ? Collections.emptyList() : PodTemplateBuilder.parseDockerCommand(cmd);
        ContainerPort[] ports = (ContainerPort[])containerTemplate.getPorts().stream().map(entry -> entry.toPort()).toArray(ContainerPort[]::new);
        List<VolumeMount> containerMounts = this.getContainerVolumeMounts(volumeMounts, workingDir);
        ContainerLivenessProbe clp = containerTemplate.getLivenessProbe();
        Probe livenessProbe = null;
        if (clp != null && PodTemplateBuilder.parseLivenessProbe(clp.getExecArgs()) != null) {
            livenessProbe = ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withExec(new ExecAction(PodTemplateBuilder.parseLivenessProbe(clp.getExecArgs())))).withInitialDelaySeconds(Integer.valueOf(clp.getInitialDelaySeconds()))).withTimeoutSeconds(Integer.valueOf(clp.getTimeoutSeconds()))).withFailureThreshold(Integer.valueOf(clp.getFailureThreshold()))).withPeriodSeconds(Integer.valueOf(clp.getPeriodSeconds()))).withSuccessThreshold(Integer.valueOf(clp.getSuccessThreshold()))).build();
        }
        ContainerBuilder containerBuilder = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(PodTemplateUtils.substituteEnv(containerTemplate.getName()))).withImage(PodTemplateUtils.substituteEnv(containerTemplate.getImage()))).withImagePullPolicy(containerTemplate.isAlwaysPullImage() ? "Always" : "IfNotPresent");
        if (containerTemplate.isPrivileged() || containerTemplate.getRunAsUserAsLong() != null || containerTemplate.getRunAsGroupAsLong() != null) {
            containerBuilder = (ContainerBuilder)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)containerBuilder.withNewSecurityContext().withPrivileged(Boolean.valueOf(containerTemplate.isPrivileged()))).withRunAsUser(containerTemplate.getRunAsUserAsLong())).withRunAsGroup(containerTemplate.getRunAsGroupAsLong())).endSecurityContext();
        }
        return ((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)containerBuilder.withWorkingDir(workingDir)).withVolumeMounts(containerMounts.toArray(new VolumeMount[containerMounts.size()]))).addToEnv(envVars)).addToPorts(ports)).withCommand(PodTemplateBuilder.parseDockerCommand(containerTemplate.getCommand()))).withArgs(arguments)).withLivenessProbe(livenessProbe)).withTty(Boolean.valueOf(containerTemplate.isTtyEnabled()))).withNewResources().withRequests(this.getResourcesMap(containerTemplate.getResourceRequestMemory(), containerTemplate.getResourceRequestCpu()))).withLimits(this.getResourcesMap(containerTemplate.getResourceLimitMemory(), containerTemplate.getResourceLimitCpu()))).endResources()).build();
    }

    private VolumeMount getDefaultVolumeMount(@CheckForNull String workingDir) {
        String wd = workingDir;
        if (wd == null) {
            wd = "/home/jenkins/agent";
            LOGGER.log(Level.FINE, "Container workingDir is null, defaulting to {0}", wd);
        }
        return ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(wd)).withName(WORKSPACE_VOLUME_NAME)).withReadOnly(Boolean.valueOf(false))).build();
    }

    private List<VolumeMount> getContainerVolumeMounts(Collection<VolumeMount> volumeMounts, String workingDir) {
        ArrayList<VolumeMount> containerMounts = new ArrayList<VolumeMount>(volumeMounts);
        if (!Strings.isNullOrEmpty((String)workingDir) && !PodVolume.volumeMountExists(workingDir, volumeMounts)) {
            containerMounts.add(this.getDefaultVolumeMount(workingDir));
        }
        return containerMounts;
    }

    @Restricted(value={NoExternalUse.class})
    static List<String> parseDockerCommand(String dockerCommand) {
        if (dockerCommand == null || dockerCommand.isEmpty()) {
            return null;
        }
        Matcher m = SPLIT_IN_SPACES.matcher(dockerCommand);
        ArrayList<String> commands = new ArrayList<String>();
        while (m.find()) {
            commands.add(PodTemplateUtils.substituteEnv(m.group(1).replace("\"", "")));
        }
        return commands;
    }

    @Restricted(value={NoExternalUse.class})
    static List<String> parseLivenessProbe(String livenessProbeExec) {
        if (StringUtils.isBlank((String)livenessProbeExec)) {
            return null;
        }
        Matcher m = SPLIT_IN_SPACES.matcher(livenessProbeExec);
        ArrayList<String> commands = new ArrayList<String>();
        while (m.find()) {
            commands.add(PodTemplateUtils.substituteEnv(m.group(1).replace("\"", "").replace("?:\\\"", "")));
        }
        return commands;
    }

    private Map<String, Quantity> getResourcesMap(String memory, String cpu) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String actualMemory = PodTemplateUtils.substituteEnv(memory);
        String actualCpu = PodTemplateUtils.substituteEnv(cpu);
        if (StringUtils.isNotBlank((String)actualMemory)) {
            Quantity memoryQuantity = new Quantity(actualMemory);
            builder.put((Object)"memory", (Object)memoryQuantity);
        }
        if (StringUtils.isNotBlank((String)actualCpu)) {
            Quantity cpuQuantity = new Quantity(actualCpu);
            builder.put((Object)"cpu", (Object)cpuQuantity);
        }
        return builder.build();
    }

    private Map<String, String> getAnnotationsMap(List<PodAnnotation> annotations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (annotations != null) {
            for (PodAnnotation podAnnotation : annotations) {
                builder.put((Object)podAnnotation.getKey(), (Object)PodTemplateUtils.substituteEnv(podAnnotation.getValue()));
            }
        }
        return builder.build();
    }

    private Map<String, String> getNodeSelectorMap(String selectors) {
        if (Strings.isNullOrEmpty((String)selectors)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String selector : selectors.split(",")) {
            String[] parts = selector.split("=");
            if (parts.length == 2 && !parts[0].isEmpty() && !parts[1].isEmpty()) {
                builder = builder.put((Object)parts[0], (Object)PodTemplateUtils.substituteEnv(parts[1]));
                continue;
            }
            LOGGER.log(Level.WARNING, "Ignoring selector '" + selector + "'. Selectors must be in the format 'label1=value1,label2=value2'.");
        }
        return builder.build();
    }

    private List<Long> parseSupplementalGroupList(String gids) {
        if (Strings.isNullOrEmpty((String)gids)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String gid : gids.split(",")) {
            try {
                if (!Strings.isNullOrEmpty((String)gid)) {
                    builder = builder.add((Object)Long.parseLong(gid));
                    continue;
                }
                LOGGER.log(Level.WARNING, "Ignoring GID '{0}'. Group ID's cannot be empty or null.", gid);
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.WARNING, "Ignoring GID '{0}'. Group ID's must be valid longs.", gid);
            }
        }
        return builder.build();
    }
}

