/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.TaskListener;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.AllContainersRunningPodWatcher;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodUtils;
import org.csanchez.jenkins.plugins.kubernetes.TaskListenerEventWatcher;
import org.kohsuke.stapler.DataBoundConstructor;

public class KubernetesLauncher
extends JNLPLauncher {
    private static final long REPORT_INTERVAL = TimeUnit.SECONDS.toMillis(30L);
    @CheckForNull
    private transient AllContainersRunningPodWatcher watcher;
    private static final Logger LOGGER = Logger.getLogger(KubernetesLauncher.class.getName());
    private boolean launched;
    @CheckForNull
    private transient Throwable problem;

    @DataBoundConstructor
    public KubernetesLauncher(String tunnel, String vmargs) {
        super(tunnel, vmargs);
    }

    public KubernetesLauncher() {
    }

    public boolean isLaunchSupported() {
        return !this.launched;
    }

    @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="This is fine")
    public synchronized void launch(SlaveComputer computer, TaskListener listener) {
        if (!(computer instanceof KubernetesComputer)) {
            throw new IllegalArgumentException("This Launcher can be used only with KubernetesComputer");
        }
        KubernetesComputer kubernetesComputer = (KubernetesComputer)computer;
        computer.setAcceptingTasks(false);
        KubernetesSlave slave = (KubernetesSlave)kubernetesComputer.getNode();
        if (slave == null) {
            throw new IllegalStateException("Node has been removed, cannot launch " + computer.getName());
        }
        if (this.launched) {
            LOGGER.log(Level.INFO, "Agent has already been launched, activating: {0}", slave.getNodeName());
            computer.setAcceptingTasks(true);
            return;
        }
        PodTemplate template = slave.getTemplate();
        try {
            int waitedForSlave;
            KubernetesClient client = slave.getKubernetesCloud().connect();
            Pod pod = template.build(slave);
            slave.assignPod(pod);
            String podName = pod.getMetadata().getName();
            String namespace = Arrays.asList(pod.getMetadata().getNamespace(), template.getNamespace(), client.getNamespace()).stream().filter(s -> StringUtils.isNotBlank((String)s)).findFirst().orElse(null);
            slave.setNamespace(namespace);
            TaskListener runListener = template.getListener();
            LOGGER.log(Level.FINE, "Creating Pod: {0}/{1}", new Object[]{namespace, podName});
            try {
                pod = (Pod)((NonNamespaceOperation)client.pods().inNamespace(namespace)).create((Object)pod);
            }
            catch (KubernetesClientException e) {
                int httpCode = e.getCode();
                if (400 <= httpCode && httpCode < 500) {
                    runListener.getLogger().printf("ERROR: Unable to create pod %s/%s.%n%s%n", namespace, pod.getMetadata().getName(), e.getMessage());
                    PodUtils.cancelQueueItemFor(pod, e.getMessage());
                } else if (500 <= httpCode && httpCode < 600) {
                    LOGGER.log(Level.FINE, "Kubernetes returned HTTP code {0} {1}. Retrying...", new Object[]{e.getCode(), e.getStatus()});
                } else {
                    LOGGER.log(Level.WARNING, "Kubernetes returned unhandled HTTP code {0} {1}", new Object[]{e.getCode(), e.getStatus()});
                }
                throw e;
            }
            LOGGER.log(Level.INFO, "Created Pod: {0}/{1}", new Object[]{namespace, podName});
            listener.getLogger().printf("Created Pod: %s/%s%n", namespace, podName);
            runListener.getLogger().printf("Created Pod: %s/%s%n", namespace, podName);
            template.getWorkspaceVolume().createVolume(client, pod.getMetadata());
            this.watcher = new AllContainersRunningPodWatcher(client, pod, runListener);
            try (Watch w1 = (Watch)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).watch((Object)this.watcher);
                 Watch w2 = this.eventWatch(client, podName, namespace, runListener);){
                assert (this.watcher != null);
                this.watcher.await(template.getSlaveConnectTimeout(), TimeUnit.SECONDS);
            }
            LOGGER.log(Level.INFO, "Pod is running: {0}/{1}", new Object[]{namespace, podName});
            ImmutableList validStates = ImmutableList.of((Object)"Running");
            int waitForSlaveToConnect = template.getSlaveConnectTimeout();
            SlaveComputer slaveComputer = null;
            String status = null;
            List containerStatuses = null;
            long lastReportTimestamp = System.currentTimeMillis();
            for (waitedForSlave = 0; waitedForSlave < waitForSlaveToConnect; ++waitedForSlave) {
                slaveComputer = slave.getComputer();
                if (slaveComputer == null) {
                    throw new IllegalStateException("Node was deleted, computer is null");
                }
                if (slaveComputer.isOnline()) break;
                pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).get();
                if (pod == null) {
                    throw new IllegalStateException("Pod no longer exists: " + podName);
                }
                status = pod.getStatus().getPhase();
                if (!validStates.contains(status)) break;
                containerStatuses = pod.getStatus().getContainerStatuses();
                ArrayList<ContainerStatus> terminatedContainers = new ArrayList<ContainerStatus>();
                for (ContainerStatus info : containerStatuses) {
                    if (info == null || info.getState().getTerminated() == null) continue;
                    LOGGER.log(Level.INFO, "Container is terminated {0} [{2}]: {1}", new Object[]{podName, info.getState().getTerminated(), info.getName()});
                    listener.getLogger().printf("Container is terminated %1$s [%3$s]: %2$s%n", podName, info.getState().getTerminated(), info.getName());
                    terminatedContainers.add(info);
                }
                this.checkTerminatedContainers(terminatedContainers, podName, namespace, slave, client);
                if (lastReportTimestamp + REPORT_INTERVAL < System.currentTimeMillis()) {
                    LOGGER.log(Level.INFO, "Waiting for agent to connect ({1}/{2}): {0}", new Object[]{podName, waitedForSlave, waitForSlaveToConnect});
                    listener.getLogger().printf("Waiting for agent to connect (%2$s/%3$s): %1$s%n", podName, waitedForSlave, waitForSlaveToConnect);
                    lastReportTimestamp = System.currentTimeMillis();
                }
                Thread.sleep(1000L);
            }
            if (slaveComputer == null || slaveComputer.isOffline()) {
                this.logLastLines(containerStatuses, podName, namespace, slave, null, client);
                throw new IllegalStateException("Agent is not connected after " + waitedForSlave + " seconds, status: " + status);
            }
            computer.setAcceptingTasks(true);
            this.launched = true;
            try {
                slave.save();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not save() agent: " + e.getMessage(), e);
            }
        }
        catch (Throwable ex) {
            this.setProblem(ex);
            LOGGER.log(Level.WARNING, String.format("Error in provisioning; agent=%s, template=%s", new Object[]{slave, template}), ex);
            LOGGER.log(Level.FINER, "Removing Jenkins node: {0}", slave.getNodeName());
            try {
                slave.terminate();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.WARNING, "Unable to remove Jenkins node", e);
            }
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private Watch eventWatch(KubernetesClient client, String podName, String namespace, TaskListener runListener) {
        try {
            return (Watch)((FilterWatchListDeletable)((NonNamespaceOperation)client.events().inNamespace(namespace)).withField("involvedObject.name", podName)).watch((Object)new TaskListenerEventWatcher(podName, runListener));
        }
        catch (KubernetesClientException e) {
            LOGGER.log(Level.INFO, e, () -> "Cannot watch events on " + namespace + "/" + podName);
            return () -> {};
        }
    }

    private void checkTerminatedContainers(List<ContainerStatus> terminatedContainers, String podId, String namespace, KubernetesSlave slave, KubernetesClient client) {
        if (!terminatedContainers.isEmpty()) {
            Map<String, Integer> errors = terminatedContainers.stream().collect(Collectors.toMap(ContainerStatus::getName, info -> info.getState().getTerminated().getExitCode()));
            this.logLastLines(terminatedContainers, podId, namespace, slave, errors, client);
            throw new IllegalStateException("Containers are terminated with exit codes: " + errors);
        }
    }

    private void logLastLines(@CheckForNull List<ContainerStatus> containers, String podId, String namespace, KubernetesSlave slave, Map<String, Integer> errors, KubernetesClient client) {
        if (containers != null) {
            for (ContainerStatus containerStatus : containers) {
                String containerName = containerStatus.getName();
                PrettyLoggable tailingLines = (PrettyLoggable)((ContainerResource)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podId)).inContainer((Object)containerStatus.getName())).tailingLines(30);
                String log = (String)tailingLines.getLog();
                if (StringUtils.isBlank((String)log)) continue;
                String msg = errors != null ? String.format(" exited with error %s", errors.get(containerName)) : "";
                LOGGER.log(Level.SEVERE, "Error in provisioning; agent={0}, template={1}. Container {2}{3}. Logs: {4}", new Object[]{slave, slave.getTemplate(), containerName, msg, tailingLines.getLog()});
            }
        }
    }

    @CheckForNull
    public Throwable getProblem() {
        return this.problem;
    }

    public void setProblem(@CheckForNull Throwable problem) {
        this.problem = problem;
    }

    public AllContainersRunningPodWatcher getWatcher() {
        return this.watcher;
    }
}

