/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Main;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.websocket.WebSockets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.InProvisioning;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesClientProvider;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesFactoryAdapter;
import org.csanchez.jenkins.plugins.kubernetes.PlannedNodeBuilderFactory;
import org.csanchez.jenkins.plugins.kubernetes.PodLabel;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateFilter;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateSource;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateMap;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Default;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetention;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuth;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.kubernetes.credentials.FileSystemServiceAccountCredential;
import org.jenkinsci.plugins.kubernetes.credentials.OpenShiftBearerTokenCredentialImpl;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class KubernetesCloud
extends Cloud {
    public static final int DEFAULT_MAX_REQUESTS_PER_HOST = 32;
    public static final Integer DEFAULT_WAIT_FOR_POD_SEC = 600;
    private static final Logger LOGGER = Logger.getLogger(KubernetesCloud.class.getName());
    public static final String JNLP_NAME = "jnlp";
    @Deprecated
    public static final Map<String, String> DEFAULT_POD_LABELS = ImmutableMap.of((Object)"jenkins", (Object)"slave");
    public static final int DEFAULT_RETENTION_TIMEOUT_MINUTES = 5;
    public static final int DEFAULT_READ_TIMEOUT_SECONDS = 15;
    public static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 5;
    private String defaultsProviderTemplate;
    @Nonnull
    private List<PodTemplate> templates = new ArrayList<PodTemplate>();
    private String serverUrl;
    private boolean useJenkinsProxy;
    @CheckForNull
    private String serverCertificate;
    private boolean skipTlsVerify;
    private boolean addMasterProxyEnvVars;
    private boolean capOnlyOnAlivePods;
    private String namespace;
    private boolean webSocket;
    private boolean directConnection = false;
    private String jenkinsUrl;
    @CheckForNull
    private String jenkinsTunnel;
    @CheckForNull
    private String credentialsId;
    private Integer containerCap;
    private int retentionTimeout = 5;
    private int connectTimeout = 5;
    private int readTimeout = 15;
    @Deprecated
    private transient Map<String, String> labels;
    private List<PodLabel> podLabels = new ArrayList<PodLabel>();
    private boolean usageRestricted;
    private int maxRequestsPerHost;
    private Integer waitForPodSec = DEFAULT_WAIT_FOR_POD_SEC;
    @CheckForNull
    private PodRetention podRetention = PodRetention.getKubernetesCloudDefault();

    @DataBoundConstructor
    public KubernetesCloud(String name) {
        super(name);
        this.setMaxRequestsPerHost(32);
    }

    public KubernetesCloud(@NonNull String name, @NonNull KubernetesCloud source) {
        super(name);
        XStream2 xs = new XStream2();
        xs.omitField(Cloud.class, "name");
        xs.omitField(KubernetesCloud.class, "templates");
        xs.unmarshal(XStream2.getDefaultDriver().createReader((Reader)new StringReader(xs.toXML((Object)source))), (Object)this);
        this.templates.addAll(source.templates);
    }

    @Deprecated
    public KubernetesCloud(String name, List<? extends PodTemplate> templates, String serverUrl, String namespace, String jenkinsUrl, String containerCapStr, int connectTimeout, int readTimeout, int retentionTimeout) {
        this(name);
        this.setServerUrl(serverUrl);
        this.setNamespace(namespace);
        this.setJenkinsUrl(jenkinsUrl);
        if (templates != null) {
            this.templates.addAll(templates);
        }
        this.setContainerCapStr(containerCapStr);
        this.setRetentionTimeout(retentionTimeout);
        this.setConnectTimeout(connectTimeout);
        this.setReadTimeout(readTimeout);
    }

    public boolean isUseJenkinsProxy() {
        return this.useJenkinsProxy;
    }

    @DataBoundSetter
    public void setUseJenkinsProxy(boolean useJenkinsProxy) {
        this.useJenkinsProxy = useJenkinsProxy;
    }

    public boolean isUsageRestricted() {
        return this.usageRestricted;
    }

    @DataBoundSetter
    public void setUsageRestricted(boolean usageRestricted) {
        this.usageRestricted = usageRestricted;
    }

    public int getRetentionTimeout() {
        return this.retentionTimeout;
    }

    @DataBoundSetter
    public void setRetentionTimeout(int retentionTimeout) {
        this.retentionTimeout = Math.max(5, retentionTimeout);
    }

    public String getDefaultsProviderTemplate() {
        return this.defaultsProviderTemplate;
    }

    @DataBoundSetter
    public void setDefaultsProviderTemplate(String defaultsProviderTemplate) {
        this.defaultsProviderTemplate = defaultsProviderTemplate;
    }

    @Nonnull
    public List<PodTemplate> getTemplates() {
        return this.templates;
    }

    @Nonnull
    public List<PodTemplate> getAllTemplates() {
        return PodTemplateSource.getAll(this);
    }

    @DataBoundSetter
    public void setTemplates(@Nonnull List<PodTemplate> templates) {
        this.templates = new ArrayList<PodTemplate>(templates);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(@Nonnull String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerCertificate() {
        return this.serverCertificate;
    }

    @DataBoundSetter
    public void setServerCertificate(String serverCertificate) {
        this.serverCertificate = Util.fixEmpty((String)serverCertificate);
    }

    public boolean isSkipTlsVerify() {
        return this.skipTlsVerify;
    }

    @DataBoundSetter
    public void setSkipTlsVerify(boolean skipTlsVerify) {
        this.skipTlsVerify = skipTlsVerify;
    }

    public boolean isAddMasterProxyEnvVars() {
        return this.addMasterProxyEnvVars;
    }

    @DataBoundSetter
    public void setAddMasterProxyEnvVars(boolean addMasterProxyEnvVars) {
        this.addMasterProxyEnvVars = addMasterProxyEnvVars;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(String namespace) {
        this.namespace = Util.fixEmpty((String)namespace);
    }

    @CheckForNull
    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    @DataBoundSetter
    @Deprecated
    public void setCapOnlyOnAlivePods(boolean capOnlyOnAlivePods) {
        this.capOnlyOnAlivePods = capOnlyOnAlivePods;
    }

    @Deprecated
    public boolean isCapOnlyOnAlivePods() {
        return this.capOnlyOnAlivePods;
    }

    @Nonnull
    public String getJenkinsUrlOrDie() {
        String url = this.getJenkinsUrlOrNull();
        if (url == null) {
            throw new IllegalStateException("Jenkins URL for Kubernetes is null");
        }
        return url;
    }

    @CheckForNull
    public String getJenkinsUrlOrNull() {
        JenkinsLocationConfiguration locationConfiguration = JenkinsLocationConfiguration.get();
        String url = StringUtils.defaultIfBlank((String)this.getJenkinsUrl(), (String)StringUtils.defaultIfBlank((String)System.getProperty("KUBERNETES_JENKINS_URL", System.getenv("KUBERNETES_JENKINS_URL")), (String)locationConfiguration.getUrl()));
        if (url == null) {
            return null;
        }
        url = url.endsWith("/") ? url : url + "/";
        return url;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    @DataBoundSetter
    public void setWebSocket(boolean webSocket) {
        this.webSocket = webSocket;
    }

    public boolean isDirectConnection() {
        return this.directConnection;
    }

    @DataBoundSetter
    public void setDirectConnection(boolean directConnection) {
        this.directConnection = directConnection;
    }

    @DataBoundSetter
    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = Util.fixEmptyAndTrim((String)jenkinsUrl);
    }

    public String getJenkinsTunnel() {
        return this.jenkinsTunnel;
    }

    @DataBoundSetter
    public void setJenkinsTunnel(String jenkinsTunnel) {
        this.jenkinsTunnel = Util.fixEmpty((String)jenkinsTunnel);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public int getContainerCap() {
        return this.containerCap != null ? this.containerCap : Integer.MAX_VALUE;
    }

    @DataBoundSetter
    public void setContainerCapStr(String containerCapStr) {
        this.setContainerCap(containerCapStr.equals("") ? null : Integer.valueOf(Integer.parseInt(containerCapStr)));
    }

    public void setContainerCap(Integer containerCap) {
        this.containerCap = containerCap != null && containerCap > 0 ? containerCap : null;
    }

    public String getContainerCapStr() {
        return this.containerCap == null || this.containerCap == Integer.MAX_VALUE || this.containerCap == 0 ? "" : String.valueOf(this.containerCap);
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    @DataBoundSetter
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = Math.max(15, readTimeout);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Deprecated
    public Map<String, String> getLabels() {
        return this.getPodLabelsMap();
    }

    @Deprecated
    public void setLabels(Map<String, String> labels) {
        this.setPodLabels(labels != null ? PodLabel.fromMap(labels) : Collections.emptyList());
    }

    @NonNull
    public List<PodLabel> getPodLabels() {
        return this.podLabels == null || this.podLabels.isEmpty() ? PodLabel.fromMap(DEFAULT_POD_LABELS) : this.podLabels;
    }

    @DataBoundSetter
    public void setPodLabels(@CheckForNull List<PodLabel> labels) {
        this.podLabels = new ArrayList<PodLabel>();
        if (labels != null) {
            this.podLabels.addAll(labels);
        }
    }

    Map<String, String> getPodLabelsMap() {
        return PodLabel.toMap(this.getPodLabels());
    }

    @DataBoundSetter
    public void setMaxRequestsPerHostStr(String maxRequestsPerHostStr) {
        try {
            this.setMaxRequestsPerHost(Integer.parseInt(maxRequestsPerHostStr));
        }
        catch (NumberFormatException e) {
            this.setMaxRequestsPerHost(32);
        }
    }

    @DataBoundSetter
    public void setMaxRequestsPerHost(int maxRequestsPerHost) {
        this.maxRequestsPerHost = maxRequestsPerHost < 0 ? 32 : maxRequestsPerHost;
    }

    public String getMaxRequestsPerHostStr() {
        return String.valueOf(this.maxRequestsPerHost);
    }

    public int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    @DataBoundSetter
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = Math.max(5, connectTimeout);
    }

    public PodRetention getPodRetention() {
        return this.podRetention;
    }

    @DataBoundSetter
    public void setPodRetention(PodRetention podRetention) {
        if (podRetention == null || podRetention instanceof Default) {
            podRetention = PodRetention.getKubernetesCloudDefault();
        }
        this.podRetention = podRetention;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC", "DC_DOUBLECHECK"})
    public KubernetesClient connect() throws KubernetesAuthException, IOException {
        LOGGER.log(Level.FINEST, "Building connection to Kubernetes {0} URL {1} namespace {2}", new String[]{this.getDisplayName(), this.serverUrl, this.namespace});
        KubernetesClient client = KubernetesClientProvider.createClient(this);
        LOGGER.log(Level.FINE, "Connected to Kubernetes {0} URL {1} namespace {2}", new String[]{this.getDisplayName(), client.getMasterUrl().toString(), this.namespace});
        return client;
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(@CheckForNull Label label, int excessWorkload) {
        try {
            Set<String> allInProvisioning = InProvisioning.getAllInProvisioning(label);
            LOGGER.log(Level.FINE, () -> "In provisioning : " + allInProvisioning);
            int toBeProvisioned = Math.max(0, excessWorkload - allInProvisioning.size());
            LOGGER.log(Level.INFO, "Excess workload after pending Kubernetes agents: {0}", toBeProvisioned);
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            for (PodTemplate t : this.getTemplatesFor(label)) {
                LOGGER.log(Level.INFO, "Template for label {0}: {1}", new Object[]{label, t.getName()});
                for (int i = 0; i < toBeProvisioned && this.mayAddProvisionedSlave(t, label, i); ++i) {
                    r.add(PlannedNodeBuilderFactory.createInstance().cloud(this).template(t).label(label).build());
                }
                LOGGER.log(Level.FINEST, "Planned Kubernetes agents for template \"{0}\": {1}", new Object[]{t.getName(), r.size()});
                if (r.size() <= 0) continue;
                return r;
            }
            return r;
        }
        catch (KubernetesClientException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SocketTimeoutException || cause instanceof ConnectException || cause instanceof UnknownHostException) {
                LOGGER.log(Level.WARNING, "Failed to connect to Kubernetes at {0}: {1}", new String[]{this.serverUrl, cause.getMessage()});
            } else {
                LOGGER.log(Level.WARNING, "Failed to count the # of live instances on Kubernetes", cause != null ? cause : e);
            }
        }
        catch (ConnectException e) {
            LOGGER.log(Level.WARNING, "Failed to connect to Kubernetes at {0}", this.serverUrl);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to count the # of live instances on Kubernetes", e);
        }
        return Collections.emptyList();
    }

    private boolean mayAddProvisionedSlave(@Nonnull PodTemplate template, @CheckForNull Label label, int scheduledCount) throws Exception {
        List<Pod> activeTemplateSlavePods;
        List<Pod> allActiveSlavePods;
        int containerCap = this.getContainerCap();
        KubernetesClient client = this.connect();
        String templateNamespace = template.getNamespace();
        if (Strings.isNullOrEmpty((String)templateNamespace)) {
            templateNamespace = client.getNamespace();
        }
        Map<String, String> podLabels = this.getPodLabelsMap();
        if (containerCap != Integer.MAX_VALUE && (allActiveSlavePods = this.getActiveSlavePods(client, templateNamespace, podLabels)) != null && containerCap <= allActiveSlavePods.size() + scheduledCount) {
            LOGGER.log(Level.INFO, "Maximum number of concurrently running agent pods ({0}) reached for Kubernetes Cloud {4}, not provisioning: {1} running or pending in namespace {2} with Kubernetes labels {3}", new Object[]{containerCap, allActiveSlavePods.size() + scheduledCount, templateNamespace, this.getLabels(), this.name});
            return false;
        }
        HashMap<String, String> labelsMap = new HashMap<String, String>(podLabels);
        labelsMap.putAll(template.getLabelsMap());
        if (template.getInstanceCap() != Integer.MAX_VALUE && (activeTemplateSlavePods = this.getActiveSlavePods(client, templateNamespace, labelsMap)) != null && template.getInstanceCap() <= activeTemplateSlavePods.size() + scheduledCount) {
            LOGGER.log(Level.INFO, "Maximum number of concurrently running agent pods ({0}) reached for template {1} in Kubernetes Cloud {6}, not provisioning: {2} running or pending in namespace {3} with label \"{4}\" and Kubernetes labels {5}", new Object[]{template.getInstanceCap(), template.getName(), activeTemplateSlavePods.size() + scheduledCount, templateNamespace, label == null ? "" : label.toString(), labelsMap, this.name});
            return false;
        }
        return true;
    }

    private List<Pod> getActiveSlavePods(KubernetesClient client, String templateNamespace, Map<String, String> podLabels) {
        PodList slaveList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(templateNamespace)).withLabels(podLabels)).list();
        List activeSlavePods = null;
        if (slaveList != null && slaveList.getItems() != null) {
            activeSlavePods = slaveList.getItems().stream().filter(x -> x.getStatus().getPhase().toLowerCase().matches("(running|pending)")).collect(Collectors.toList());
        }
        return activeSlavePods;
    }

    public boolean canProvision(@CheckForNull Label label) {
        return this.getTemplate(label) != null;
    }

    public PodTemplate getTemplate(@CheckForNull Label label) {
        return PodTemplateUtils.getTemplateByLabel(label, this.getAllTemplates());
    }

    @CheckForNull
    public PodTemplate getTemplateById(@Nonnull String id) {
        return this.getAllTemplates().stream().filter(t -> id.equals(t.getId())).findFirst().orElse(null);
    }

    public PodTemplate getUnwrappedTemplate(PodTemplate podTemplate) {
        return PodTemplateUtils.unwrap(podTemplate, this.getDefaultsProviderTemplate(), this.getAllTemplates());
    }

    @Deprecated
    public ArrayList<PodTemplate> getMatchingTemplates(@CheckForNull Label label) {
        return new ArrayList<PodTemplate>(this.getTemplatesFor(label));
    }

    public List<PodTemplate> getTemplatesFor(@CheckForNull Label label) {
        return PodTemplateFilter.applyAll(this, this.getAllTemplates(), label);
    }

    public void addTemplate(PodTemplate t) {
        this.templates.add(t);
    }

    public void removeTemplate(PodTemplate t) {
        this.templates.remove(t);
    }

    public void addDynamicTemplate(PodTemplate t) {
        PodTemplateMap.get().addTemplate(this, t);
    }

    public void removeDynamicTemplate(PodTemplate t) {
        PodTemplateMap.get().removeTemplate(this, t);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KubernetesCloud that = (KubernetesCloud)((Object)o);
        return this.skipTlsVerify == that.skipTlsVerify && this.addMasterProxyEnvVars == that.addMasterProxyEnvVars && this.capOnlyOnAlivePods == that.capOnlyOnAlivePods && Objects.equals(this.containerCap, that.containerCap) && this.retentionTimeout == that.retentionTimeout && this.connectTimeout == that.connectTimeout && this.readTimeout == that.readTimeout && this.usageRestricted == that.usageRestricted && this.maxRequestsPerHost == that.maxRequestsPerHost && Objects.equals(this.defaultsProviderTemplate, that.defaultsProviderTemplate) && this.templates.equals(that.templates) && Objects.equals(this.serverUrl, that.serverUrl) && Objects.equals(this.serverCertificate, that.serverCertificate) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.jenkinsUrl, that.jenkinsUrl) && Objects.equals(this.jenkinsTunnel, that.jenkinsTunnel) && Objects.equals(this.credentialsId, that.credentialsId) && Objects.equals(this.podLabels, that.podLabels) && Objects.equals((Object)this.podRetention, (Object)that.podRetention) && Objects.equals(this.waitForPodSec, that.waitForPodSec) && this.useJenkinsProxy == that.useJenkinsProxy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultsProviderTemplate, this.templates, this.serverUrl, this.serverCertificate, this.skipTlsVerify, this.addMasterProxyEnvVars, this.capOnlyOnAlivePods, this.namespace, this.jenkinsUrl, this.jenkinsTunnel, this.credentialsId, this.containerCap, this.retentionTimeout, this.connectTimeout, this.readTimeout, this.podLabels, this.usageRestricted, this.maxRequestsPerHost, this.podRetention, this.useJenkinsProxy});
    }

    public Integer getWaitForPodSec() {
        return this.waitForPodSec;
    }

    @DataBoundSetter
    public void setWaitForPodSec(Integer waitForPodSec) {
        this.waitForPodSec = waitForPodSec;
    }

    public String toString() {
        return "KubernetesCloud{defaultsProviderTemplate='" + this.defaultsProviderTemplate + '\'' + ", templates=" + this.templates + ", serverUrl='" + this.serverUrl + '\'' + ", serverCertificate='" + this.serverCertificate + '\'' + ", skipTlsVerify=" + this.skipTlsVerify + ", addMasterProxyEnvVars=" + this.addMasterProxyEnvVars + ", capOnlyOnAlivePods=" + this.capOnlyOnAlivePods + ", namespace='" + this.namespace + '\'' + ", jenkinsUrl='" + this.jenkinsUrl + '\'' + ", jenkinsTunnel='" + this.jenkinsTunnel + '\'' + ", credentialsId='" + this.credentialsId + '\'' + ", containerCap=" + this.containerCap + ", retentionTimeout=" + this.retentionTimeout + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", labels=" + this.labels + ", podLabels=" + this.podLabels + ", usageRestricted=" + this.usageRestricted + ", maxRequestsPerHost=" + this.maxRequestsPerHost + ", waitForPodSec=" + this.waitForPodSec + ", podRetention=" + (Object)((Object)this.podRetention) + ", useJenkinsProxy=" + this.useJenkinsProxy + '}';
    }

    private Object readResolve() {
        if (this.serverCertificate != null && !this.serverCertificate.trim().startsWith("-----BEGIN CERTIFICATE-----")) {
            this.serverCertificate = new String(Base64.decodeBase64((byte[])this.serverCertificate.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            LOGGER.log(Level.INFO, "Upgraded Kubernetes server certificate key: {0}", this.serverCertificate.substring(0, 80));
        }
        if (this.maxRequestsPerHost == 0) {
            this.maxRequestsPerHost = 32;
        }
        if (this.podRetention == null) {
            this.podRetention = PodRetention.getKubernetesCloudDefault();
        }
        this.setConnectTimeout(this.connectTimeout);
        this.setReadTimeout(this.readTimeout);
        this.setRetentionTimeout(this.retentionTimeout);
        if (this.waitForPodSec == null) {
            this.waitForPodSec = DEFAULT_WAIT_FOR_POD_SEC;
        }
        if (this.podLabels == null && this.labels != null) {
            this.setPodLabels(PodLabel.fromMap(this.labels));
        }
        return this;
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_LOADED)
    public static void hpiRunInit() {
        if (Main.isDevelopmentMode) {
            Jenkins jenkins = Jenkins.get();
            String hostAddress = System.getProperty("jenkins.host.address");
            if (hostAddress != null && jenkins.clouds.getAll(KubernetesCloud.class).isEmpty()) {
                KubernetesCloud cloud = new KubernetesCloud("kubernetes");
                cloud.setJenkinsUrl("http://" + hostAddress + ":8080/jenkins/");
                jenkins.clouds.add((Object)cloud);
            }
        }
    }

    @Extension
    public static class PodTemplateSourceImpl
    extends PodTemplateSource {
        @Override
        @Nonnull
        public List<PodTemplate> getList(@Nonnull KubernetesCloud cloud) {
            return cloud.getTemplates();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Kubernetes";
        }

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Jenkins.XSTREAM2.addCompatibilityAlias("org.csanchez.jenkins.plugins.kubernetes.OpenShiftBearerTokenCredentialImpl", OpenShiftBearerTokenCredentialImpl.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("org.csanchez.jenkins.plugins.kubernetes.OpenShiftTokenCredentialImpl", StringCredentialsImpl.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("org.csanchez.jenkins.plugins.kubernetes.ServiceAccountCredential", FileSystemServiceAccountCredential.class);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RequirePOST
        public FormValidation doTestConnection(@QueryParameter String name, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String serverCertificate, @QueryParameter boolean skipTlsVerify, @QueryParameter String namespace, @QueryParameter int connectionTimeout, @QueryParameter int readTimeout) throws Exception {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((String)name)) {
                return FormValidation.error((String)"name is required");
            }
            try (KubernetesClient client = new KubernetesFactoryAdapter(serverUrl, namespace, Util.fixEmpty((String)serverCertificate), Util.fixEmpty((String)credentialsId), skipTlsVerify, connectionTimeout, readTimeout).createClient();){
                client.pods().list();
                VersionInfo version = client.getVersion();
                FormValidation formValidation = FormValidation.ok((String)("Connected to Kubernetes " + version.getMajor() + "." + version.getMinor()));
                return formValidation;
            }
            catch (KubernetesClientException e) {
                LOGGER.log(Level.FINE, String.format("Error testing connection %s", serverUrl), e);
                return FormValidation.error((String)"Error testing connection %s: %s", (Object[])new Object[]{serverUrl, e.getCause() == null ? e.getMessage() : String.format("%s: %s", e.getCause().getClass().getName(), e.getCause().getMessage())});
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, String.format("Error testing connection %s", serverUrl), e);
                return FormValidation.error((String)"Error testing connection %s: %s", (Object[])new Object[]{serverUrl, e.getMessage()});
            }
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String serverUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            StandardListBoxModel result = new StandardListBoxModel();
            result.includeEmptyValue();
            result.includeMatchingAs(ACL.SYSTEM, context, StandardCredentials.class, serverUrl != null ? URIRequirementBuilder.fromUri((String)serverUrl).build() : Collections.EMPTY_LIST, CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{AuthenticationTokens.matcher(KubernetesAuth.class)}));
            return result;
        }

        @RequirePOST
        public FormValidation doCheckMaxRequestsPerHostStr(@QueryParameter String value) throws IOException, ServletException {
            return FormValidation.validatePositiveInteger((String)value);
        }

        @RequirePOST
        public FormValidation doCheckConnectTimeout(@QueryParameter String value) {
            return FormValidation.validateIntegerInRange((String)value, (int)5, (int)Integer.MAX_VALUE);
        }

        @RequirePOST
        public FormValidation doCheckReadTimeout(@QueryParameter String value) {
            return FormValidation.validateIntegerInRange((String)value, (int)15, (int)Integer.MAX_VALUE);
        }

        @RequirePOST
        public FormValidation doCheckRetentionTimeout(@QueryParameter String value) {
            return FormValidation.validateIntegerInRange((String)value, (int)5, (int)Integer.MAX_VALUE);
        }

        public FormValidation doCheckDirectConnection(@QueryParameter boolean value, @QueryParameter String jenkinsUrl, @QueryParameter boolean webSocket) throws IOException, ServletException {
            int slaveAgentPort = Jenkins.get().getSlaveAgentPort();
            if (slaveAgentPort == -1 && !webSocket) {
                return FormValidation.warning((String)"'TCP port for inbound agents' is disabled in Global Security settings. Connecting Kubernetes agents will not work without this or WebSocket mode!");
            }
            if (value) {
                if (webSocket) {
                    return FormValidation.error((String)"Direct connection and WebSocket mode are mutually exclusive");
                }
                if (!StringUtils.isEmpty((String)jenkinsUrl)) {
                    return FormValidation.warning((String)"No need to configure Jenkins URL when direct connection is enabled");
                }
                if (slaveAgentPort == 0) {
                    return FormValidation.warning((String)"A random 'TCP port for inbound agents' is configured in Global Security settings. In 'direct connection' mode agents will not be able to reconnect to a restarted master with random port!");
                }
            } else if (StringUtils.isEmpty((String)jenkinsUrl)) {
                String url = StringUtils.defaultIfBlank((String)System.getProperty("KUBERNETES_JENKINS_URL", System.getenv("KUBERNETES_JENKINS_URL")), (String)JenkinsLocationConfiguration.get().getUrl());
                if (url != null) {
                    return FormValidation.ok((String)("Will connect using " + url));
                }
                return FormValidation.warning((String)"Configure either Direct Connection or Jenkins URL");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJenkinsUrl(@QueryParameter String value, @QueryParameter boolean directConnection) throws IOException, ServletException {
            try {
                if (!StringUtils.isEmpty((String)value)) {
                    new URL(value);
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((Throwable)e, (String)"Invalid Jenkins URL");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWebSocket(@QueryParameter boolean webSocket, @QueryParameter boolean directConnection, @QueryParameter String jenkinsTunnel) {
            if (webSocket) {
                if (!WebSockets.isSupported()) {
                    return FormValidation.error((String)"WebSocket support is not enabled in this Jenkins installation");
                }
                if (Util.fixEmpty((String)jenkinsTunnel) != null) {
                    return FormValidation.error((String)"Tunneling is not currently supported in WebSocket mode");
                }
            }
            return FormValidation.ok();
        }

        public List<Descriptor<PodRetention>> getAllowedPodRetentions() {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return new ArrayList<Descriptor<PodRetention>>(0);
            }
            return DescriptorVisibilityFilter.apply((Object)((Object)this), (Iterable)jenkins.getDescriptorList(PodRetention.class));
        }

        public Descriptor getDefaultPodRetention() {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins == null) {
                return null;
            }
            return jenkins.getDescriptor(((Object)((Object)PodRetention.getKubernetesCloudDefault())).getClass());
        }

        public int getDefaultReadTimeout() {
            return 15;
        }

        public int getDefaultConnectTimeout() {
            return 5;
        }

        public int getDefaultRetentionTimeout() {
            return 5;
        }

        public int getDefaultWaitForPod() {
            return DEFAULT_WAIT_FOR_POD_SEC;
        }
    }
}

