/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class SecretVolume
extends PodVolume {
    private String mountPath;
    private String secretName;
    private String defaultMode;

    @DataBoundConstructor
    public SecretVolume(String mountPath, String secretName, String defaultMode) {
        this.mountPath = mountPath;
        this.secretName = secretName;
        this.defaultMode = defaultMode;
    }

    public SecretVolume(String mountPath, String secretName) {
        this(mountPath, secretName, null);
    }

    @Override
    public Volume buildVolume(String volumeName) {
        SecretVolumeSource secretVolumeSource = new SecretVolumeSource();
        secretVolumeSource.setSecretName(this.getSecretName());
        if (StringUtils.isNotBlank((String)this.defaultMode)) {
            secretVolumeSource.setDefaultMode(Integer.valueOf(Integer.parseInt(this.getDefaultMode())));
        }
        return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewSecretLike(secretVolumeSource).endSecret()).build();
    }

    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    public String getDefaultMode() {
        return this.defaultMode;
    }

    public String toString() {
        return "SecretVolume [mountPath=" + this.mountPath + ", secretName=" + this.secretName + ", defaultMode=" + this.defaultMode + "]";
    }

    @Extension
    @Symbol(value={"secretVolume"})
    public static class DescriptorImpl
    extends Descriptor<PodVolume> {
        public String getDisplayName() {
            return "Secret Volume";
        }
    }
}

