/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class EmptyDirVolume
extends PodVolume {
    private static final String DEFAULT_MEDIUM = "";
    private static final String MEMORY_MEDIUM = "Memory";
    private String mountPath;
    @CheckForNull
    private Boolean memory;

    @DataBoundConstructor
    public EmptyDirVolume(String mountPath, Boolean memory) {
        this.mountPath = mountPath;
        this.memory = memory;
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    public String getMedium() {
        return this.getMemory() != false ? MEMORY_MEDIUM : DEFAULT_MEDIUM;
    }

    @Nonnull
    public Boolean getMemory() {
        return this.memory != null && this.memory != false;
    }

    @Override
    public Volume buildVolume(String volumeName) {
        return ((VolumeBuilder)((VolumeFluent.EmptyDirNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewEmptyDir().withMedium(this.getMedium())).endEmptyDir()).build();
    }

    public String toString() {
        return "EmptyDirVolume [mountPath=" + this.mountPath + ", memory=" + this.memory + "]";
    }

    @Extension
    @Symbol(value={"emptyDirVolume"})
    public static class DescriptorImpl
    extends Descriptor<PodVolume> {
        public String getDisplayName() {
            return "Empty Dir Volume";
        }
    }
}

