/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pod.retention;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerListener;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;

@Extension
public class Reaper
extends ComputerListener
implements Watcher<Pod> {
    private static final Logger LOGGER = Logger.getLogger(Reaper.class.getName());
    private final AtomicBoolean activated = new AtomicBoolean();

    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        if (c instanceof KubernetesComputer && this.activated.compareAndSet(false, true)) {
            this.activate();
        }
    }

    private void activate() {
        LOGGER.fine("Activating reaper");
        for (Node n : new ArrayList(Jenkins.get().getNodes())) {
            if (!(n instanceof KubernetesSlave)) continue;
            KubernetesSlave ks = (KubernetesSlave)n;
            String ns = ks.getNamespace();
            String name = ks.getPodName();
            try {
                if (((PodResource)((NonNamespaceOperation)ks.getKubernetesCloud().connect().pods().inNamespace(ns)).withName(name)).get() == null) {
                    LOGGER.info(() -> ns + "/" + name + " seems to have been deleted, so removing corresponding Jenkins agent");
                    Jenkins.get().removeNode((Node)ks);
                    continue;
                }
                LOGGER.fine(() -> ns + "/" + name + " still seems to exist, OK");
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to do initial reap check for " + ns + "/" + name, x);
            }
        }
        for (Cloud c : Jenkins.get().clouds) {
            if (!(c instanceof KubernetesCloud)) continue;
            KubernetesCloud kc = (KubernetesCloud)c;
            try {
                KubernetesClient client = kc.connect();
                ((NonNamespaceOperation)client.pods().inNamespace(client.getNamespace())).watch((Object)this);
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to set up watcher on " + kc.getDisplayName(), x);
            }
        }
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        if (action == Watcher.Action.DELETED) {
            String ns = pod.getMetadata().getNamespace();
            String name = pod.getMetadata().getName();
            for (Node n : new ArrayList(Jenkins.get().getNodes())) {
                KubernetesSlave ks;
                if (!(n instanceof KubernetesSlave) || !(ks = (KubernetesSlave)n).getNamespace().equals(ns) || !ks.getPodName().equals(name)) continue;
                LOGGER.info(() -> ns + "/" + name + " was just deleted, so removing corresponding Jenkins agent");
                try {
                    Jenkins.get().removeNode((Node)ks);
                    return;
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "failed to reap " + ns + "/" + name, x);
                }
            }
            LOGGER.fine(() -> "received deletion notice for " + ns + "/" + name + " which does not seem to correspond to any Jenkins agent");
        }
    }

    public void onClose(KubernetesClientException cause) {
    }
}

