/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.slaves.Cloud;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang.RandomStringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesFolderProperty;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodImagePullSecret;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateContext;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class PodTemplateStepExecution
extends AbstractStepExecutionImpl {
    private static final Logger LOGGER = Logger.getLogger(PodTemplateStepExecution.class.getName());
    private static final long serialVersionUID = -6139090518333729333L;
    private static final transient String NAME_FORMAT = "%s-%s";
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private final transient PodTemplateStep step;
    private final String cloudName;
    private PodTemplate newTemplate = null;

    PodTemplateStepExecution(PodTemplateStep step, StepContext context) {
        super(context);
        this.step = step;
        this.cloudName = step.getCloud();
    }

    public boolean start() throws Exception {
        Object url;
        PodTemplateContext podTemplateContext;
        Cloud cloud = Jenkins.get().getCloud(this.cloudName);
        if (cloud == null) {
            throw new AbortException(String.format("Cloud does not exist: %s", this.cloudName));
        }
        if (!(cloud instanceof KubernetesCloud)) {
            throw new AbortException(String.format("Cloud is not a Kubernetes cloud: %s (%s)", this.cloudName, cloud.getClass().getName()));
        }
        KubernetesCloud kubernetesCloud = (KubernetesCloud)cloud;
        Run run = (Run)this.getContext().get(Run.class);
        if (kubernetesCloud.isUsageRestricted()) {
            this.checkAccess(run, kubernetesCloud);
        }
        String parentTemplates = (podTemplateContext = (PodTemplateContext)this.getContext().get(PodTemplateContext.class)) != null ? podTemplateContext.getName() : null;
        String label = this.step.getLabel();
        if (label == null) {
            label = PodTemplateStepExecution.labelify(run.getExternalizableId());
        }
        String randString = RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
        String stepName = this.step.getName();
        if (stepName == null) {
            stepName = label;
        }
        String name = String.format(NAME_FORMAT, stepName, randString);
        String namespace = this.checkNamespace(kubernetesCloud, podTemplateContext);
        this.newTemplate = new PodTemplate();
        this.newTemplate.setName(name);
        this.newTemplate.setNamespace(namespace);
        if (this.step.getInheritFrom() == null) {
            this.newTemplate.setInheritFrom(Strings.emptyToNull((String)parentTemplates));
        } else {
            this.newTemplate.setInheritFrom(Strings.emptyToNull((String)this.step.getInheritFrom()));
        }
        this.newTemplate.setInstanceCap(this.step.getInstanceCap());
        this.newTemplate.setIdleMinutes(this.step.getIdleMinutes());
        this.newTemplate.setSlaveConnectTimeout(this.step.getSlaveConnectTimeout());
        this.newTemplate.setLabel(label);
        this.newTemplate.setEnvVars(this.step.getEnvVars());
        this.newTemplate.setVolumes(this.step.getVolumes());
        if (this.step.getWorkspaceVolume() != null) {
            this.newTemplate.setWorkspaceVolume(this.step.getWorkspaceVolume());
        }
        this.newTemplate.setContainers(this.step.getContainers());
        this.newTemplate.setNodeSelector(this.step.getNodeSelector());
        this.newTemplate.setNodeUsageMode(this.step.getNodeUsageMode());
        this.newTemplate.setServiceAccount(this.step.getServiceAccount());
        if (this.step.getHostNetwork() != null) {
            this.newTemplate.setHostNetwork(this.step.getHostNetwork());
        }
        this.newTemplate.setAnnotations(this.step.getAnnotations());
        this.newTemplate.setYamlMergeStrategy(this.step.getYamlMergeStrategy());
        if (run != null && (url = ((KubernetesCloud)cloud).getJenkinsUrlOrNull()) != null) {
            this.newTemplate.getAnnotations().add(new PodAnnotation("buildUrl", (String)url + run.getUrl()));
        }
        this.newTemplate.setImagePullSecrets(this.step.getImagePullSecrets().stream().map(x -> new PodImagePullSecret((String)x)).collect(Collectors.toList()));
        this.newTemplate.setYaml(this.step.getYaml());
        if (this.step.isShowRawYamlSet()) {
            this.newTemplate.setShowRawYaml(this.step.isShowRawYaml());
        }
        this.newTemplate.setPodRetention(this.step.getPodRetention());
        if (this.step.getActiveDeadlineSeconds() != 0) {
            this.newTemplate.setActiveDeadlineSeconds(this.step.getActiveDeadlineSeconds());
        }
        for (ContainerTemplate container : this.newTemplate.getContainers()) {
            if (PodTemplateUtils.validateContainerName(container.getName())) continue;
            throw new AbortException(Messages.RFC1123_error(container.getName()));
        }
        Collection<String> errors = PodTemplateUtils.validateYamlContainerNames(this.newTemplate.getYamls());
        if (!errors.isEmpty()) {
            throw new AbortException(Messages.RFC1123_error(String.join((CharSequence)", ", errors)));
        }
        if (!PodTemplateUtils.validateLabel(this.newTemplate.getLabel())) {
            throw new AbortException(Messages.label_error(this.newTemplate.getLabel()));
        }
        kubernetesCloud.addDynamicTemplate(this.newTemplate);
        BodyInvoker invoker = this.getContext().newBodyInvoker().withContexts(new Object[]{this.step, new PodTemplateContext(namespace, name)}).withCallback((BodyExecutionCallback)new PodTemplateCallback(this.newTemplate));
        if (this.step.getLabel() == null) {
            invoker.withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)EnvironmentExpander.constant(Collections.singletonMap("POD_LABEL", label))));
        }
        invoker.start();
        return false;
    }

    static String labelify(String input) {
        int max = 57;
        if (input.length() > max) {
            input = input.substring(input.length() - max);
        }
        input = input.replaceAll("[^_.a-zA-Z0-9-]", "_").replaceFirst("^[^a-zA-Z0-9]", "x");
        String label = input + "-" + RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
        assert (PodTemplateUtils.validateLabel(label)) : label;
        return label;
    }

    private void checkAccess(Run<?, ?> run, KubernetesCloud kubernetesCloud) throws AbortException {
        Job job = run.getParent();
        ItemGroup parent = job.getParent();
        HashSet<String> allowedClouds = new HashSet<String>();
        KubernetesFolderProperty.collectAllowedClouds(allowedClouds, parent);
        if (!allowedClouds.contains(kubernetesCloud.name)) {
            throw new AbortException(String.format("Not authorized to use Kubernetes cloud: %s", this.step.getCloud()));
        }
    }

    private String checkNamespace(KubernetesCloud kubernetesCloud, @CheckForNull PodTemplateContext podTemplateContext) {
        String namespace = null;
        namespace = !Strings.isNullOrEmpty((String)this.step.getNamespace()) ? this.step.getNamespace() : (podTemplateContext != null && !Strings.isNullOrEmpty((String)podTemplateContext.getNamespace()) ? podTemplateContext.getNamespace() : kubernetesCloud.getNamespace());
        return namespace;
    }

    public void onResume() {
        super.onResume();
        Cloud cloud = Jenkins.get().getCloud(this.cloudName);
        if (cloud == null) {
            throw new RuntimeException(String.format("Cloud does not exist: %s", this.cloudName));
        }
        if (!(cloud instanceof KubernetesCloud)) {
            throw new RuntimeException(String.format("Cloud is not a Kubernetes cloud: %s (%s)", this.cloudName, cloud.getClass().getName()));
        }
        KubernetesCloud kubernetesCloud = (KubernetesCloud)cloud;
        kubernetesCloud.addDynamicTemplate(this.newTemplate);
    }

    private class PodTemplateCallback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 6043919968776851324L;
        private final PodTemplate podTemplate;

        private PodTemplateCallback(PodTemplate podTemplate) {
            this.podTemplate = podTemplate;
        }

        protected void finished(StepContext context) throws Exception {
            Cloud cloud = Jenkins.get().getCloud(PodTemplateStepExecution.this.cloudName);
            if (cloud == null) {
                LOGGER.log(Level.WARNING, "Cloud {0} no longer exists, cannot delete pod template {1}", new Object[]{PodTemplateStepExecution.this.cloudName, this.podTemplate.getName()});
                return;
            }
            if (cloud instanceof KubernetesCloud) {
                LOGGER.log(Level.INFO, "Removing pod template {1} from cloud {0}", new Object[]{cloud.name, this.podTemplate.getName()});
                KubernetesCloud kubernetesCloud = (KubernetesCloud)cloud;
                kubernetesCloud.removeDynamicTemplate(this.podTemplate);
            } else {
                LOGGER.log(Level.WARNING, "Cloud is not a KubernetesCloud: {0} {1}", new String[]{cloud.name, cloud.getClass().getName()});
            }
        }
    }
}

