/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.model.Computer;
import hudson.model.Node;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecable;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Response;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecProc;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.KubernetesNodeContext;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;

public class ContainerExecDecorator
extends LauncherDecorator
implements Serializable,
Closeable {
    private static final long serialVersionUID = 4419929753433397655L;
    private static final long DEFAULT_CONTAINER_READY_TIMEOUT = 5L;
    private static final String CONTAINER_READY_TIMEOUT_SYSTEM_PROPERTY = ContainerExecDecorator.class.getName() + ".containerReadyTimeout";
    private static final String WEBSOCKET_CONNECTION_TIMEOUT_SYSTEM_PROPERTY = ContainerExecDecorator.class.getName() + ".websocketConnectionTimeout";
    private static final int WEBSOCKET_CONNECTION_TIMEOUT = Integer.getInteger(WEBSOCKET_CONNECTION_TIMEOUT_SYSTEM_PROPERTY, 30);
    private static final long CONTAINER_READY_TIMEOUT = ContainerExecDecorator.containerReadyTimeout();
    private static final String COOKIE_VAR = "JENKINS_SERVER_COOKIE";
    private static final Logger LOGGER = Logger.getLogger(ContainerExecDecorator.class.getName());
    private static final int STDIN_BUFFER_SIZE = Integer.getInteger(ContainerExecDecorator.class.getName() + ".stdinBufferSize", 2048);
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private transient List<Closeable> closables;
    private String containerName;
    private EnvironmentExpander environmentExpander;
    private EnvVars globalVars;
    @Deprecated
    private FilePath ws;
    private EnvVars rcEnvVars;
    private String shell;
    private KubernetesNodeContext nodeContext;

    public ContainerExecDecorator() {
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace, EnvironmentExpander environmentExpander, FilePath ws) {
        this.containerName = containerName;
        this.environmentExpander = environmentExpander;
        this.ws = ws;
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace, EnvironmentExpander environmentExpander) {
        this(client, podName, containerName, namespace, environmentExpander, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String namespace) {
        this(client, podName, containerName, namespace, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished, String namespace) {
        this(client, podName, containerName, namespace, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished) {
        this(client, podName, containerName, (String)null, null, null);
    }

    @Deprecated
    public ContainerExecDecorator(KubernetesClient client, String podName, String containerName, String path, AtomicBoolean alive, CountDownLatch started, CountDownLatch finished) {
        this(client, podName, containerName, (String)null, null, null);
    }

    @Deprecated
    public KubernetesClient getClient() {
        try {
            return this.nodeContext.connectToCloud();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setClient(KubernetesClient client) {
    }

    @Deprecated
    public String getPodName() {
        try {
            return this.getNodeContext().getPodName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setPodName(String podName) {
    }

    @Deprecated
    public String getNamespace() {
        try {
            return this.getNodeContext().getNamespace();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setNamespace(String namespace) {
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public EnvironmentExpander getEnvironmentExpander() {
        return this.environmentExpander;
    }

    public void setEnvironmentExpander(EnvironmentExpander environmentExpander) {
        this.environmentExpander = environmentExpander;
    }

    public EnvVars getGlobalVars() {
        return this.globalVars;
    }

    public void setGlobalVars(EnvVars globalVars) {
        this.globalVars = globalVars;
    }

    public void setRunContextEnvVars(EnvVars rcVars) {
        this.rcEnvVars = rcVars;
    }

    public EnvVars getRunContextEnvVars() {
        return this.rcEnvVars;
    }

    @Deprecated
    public FilePath getWs() {
        return this.ws;
    }

    public void setWs(FilePath ws) {
        this.ws = ws;
    }

    public void setShell(String shell) {
        this.shell = shell;
    }

    public KubernetesNodeContext getNodeContext() {
        return this.nodeContext;
    }

    public void setNodeContext(KubernetesNodeContext nodeContext) {
        this.nodeContext = nodeContext;
    }

    public Launcher decorate(final Launcher launcher, final Node node) {
        return new Launcher.DecoratedLauncher(launcher){

            public Proc launch(Launcher.ProcStarter starter) throws IOException {
                Computer computer;
                LOGGER.log(Level.FINEST, "Launch proc with environment: {0}", Arrays.toString(starter.envs()));
                String[] envVars = starter.envs();
                if (node != null && (computer = node.toComputer()) != null) {
                    ArrayList<String> resultEnvVar = new ArrayList<String>();
                    try {
                        String[] envs;
                        EnvVars environment = computer.getEnvironment();
                        for (String keyValue : envs = starter.envs()) {
                            String[] split = keyValue.split("=", 2);
                            if (split[1].equals(environment.get((Object)split[0]))) continue;
                            resultEnvVar.add(keyValue);
                        }
                        envVars = resultEnvVar.toArray(new String[resultEnvVar.size()]);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Unable to retrieve environment variables", e);
                    }
                }
                return this.doLaunch(starter.quiet(), envVars, starter.stdout(), starter.pwd(), starter.masks(), ContainerExecDecorator.getCommands(starter));
            }

            private Proc doLaunch(boolean quiet, String[] cmdEnvs, OutputStream outputForCaller, FilePath pwd, boolean[] masks, String ... commands) throws IOException {
                ExecWatch watch;
                PrintStream printStream;
                this.waitUntilPodContainersAreReady();
                final CountDownLatch started = new CountDownLatch(1);
                final CountDownLatch finished = new CountDownLatch(1);
                final AtomicBoolean alive = new AtomicBoolean(false);
                PrintStream stream = printStream = launcher.getListener().getLogger();
                if (quiet) {
                    stream = new NullOutputStream();
                    printStream = new PrintStream((OutputStream)stream, false, StandardCharsets.UTF_8.toString());
                }
                if (outputForCaller != null && !outputForCaller.equals(stream)) {
                    stream = new TeeOutputStream(outputForCaller, (OutputStream)stream);
                }
                ByteArrayOutputStream error = new ByteArrayOutputStream();
                String sh = ContainerExecDecorator.this.shell != null ? ContainerExecDecorator.this.shell : (launcher.isUnix() ? "sh" : "cmd");
                String msg = "Executing " + sh + " script inside container " + ContainerExecDecorator.this.containerName + " of pod " + ContainerExecDecorator.this.getPodName();
                LOGGER.log(Level.FINEST, msg);
                printStream.println(msg);
                if (ContainerExecDecorator.this.closables == null) {
                    ContainerExecDecorator.this.closables = new ArrayList();
                }
                Execable execable = (Execable)((TtyExecable)((TtyExecErrorChannelable)((TtyExecErrorable)((TtyExecOutputErrorable)((ContainerResource)((PodResource)((NonNamespaceOperation)ContainerExecDecorator.this.getClient().pods().inNamespace(ContainerExecDecorator.this.getNamespace())).withName(ContainerExecDecorator.this.getPodName())).inContainer((Object)ContainerExecDecorator.this.containerName)).redirectingInput(Integer.valueOf(STDIN_BUFFER_SIZE))).writingOutput((Object)stream)).writingError((Object)stream)).writingErrorChannel((Object)error)).usingListener((Object)new ExecListener(){

                    public void onOpen(Response response) {
                        alive.set(true);
                        started.countDown();
                        LOGGER.log(Level.FINEST, "onOpen : {0}", finished);
                    }

                    public void onFailure(Throwable t, Response response) {
                        alive.set(false);
                        t.printStackTrace(launcher.getListener().getLogger());
                        started.countDown();
                        LOGGER.log(Level.FINEST, "onFailure : {0}", finished);
                        if (finished.getCount() == 0L) {
                            LOGGER.log(Level.WARNING, "onFailure called but latch already finished. This may be a bug in the kubernetes-plugin");
                        }
                        finished.countDown();
                    }

                    public void onClose(int i, String s) {
                        alive.set(false);
                        started.countDown();
                        LOGGER.log(Level.FINEST, "onClose : {0}", finished);
                        if (finished.getCount() == 0L) {
                            LOGGER.log(Level.WARNING, "onClose called but latch already finished. This indicates a bug in the kubernetes-plugin");
                        }
                        finished.countDown();
                    }
                });
                try {
                    watch = (ExecWatch)execable.exec((Object[])new String[]{sh});
                }
                catch (KubernetesClientException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        throw new IOException("Interrupted while starting websocket connection, you should increase the Max connections to Kubernetes API", e);
                    }
                    throw e;
                }
                catch (RejectedExecutionException e) {
                    throw new IOException("Connection was rejected, you should increase the Max connections to Kubernetes API", e);
                }
                boolean hasStarted = false;
                try {
                    hasStarted = started.await(WEBSOCKET_CONNECTION_TIMEOUT, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    ContainerExecDecorator.closeWatch(watch);
                    throw new IOException("Interrupted while waiting for websocket connection, you should increase the Max connections to Kubernetes API", e);
                }
                if (!hasStarted) {
                    ContainerExecDecorator.closeWatch(watch);
                    throw new IOException("Timed out waiting for websocket connection. You should increase the value of system property " + WEBSOCKET_CONNECTION_TIMEOUT_SYSTEM_PROPERTY + " currently set at " + WEBSOCKET_CONNECTION_TIMEOUT + " seconds");
                }
                try {
                    OutputStream stdin = watch.getInput();
                    if (pwd != null) {
                        stdin.write(String.format("cd \"%s\"%s", pwd, "\n").getBytes(StandardCharsets.UTF_8));
                    }
                    EnvVars envVars = new EnvVars();
                    if (ContainerExecDecorator.this.globalVars != null) {
                        envVars.overrideAll((Map)ContainerExecDecorator.this.globalVars);
                    }
                    if (ContainerExecDecorator.this.rcEnvVars != null) {
                        envVars.overrideAll((Map)ContainerExecDecorator.this.rcEnvVars);
                    }
                    if (ContainerExecDecorator.this.environmentExpander != null) {
                        ContainerExecDecorator.this.environmentExpander.expand(envVars);
                    }
                    if (cmdEnvs != null) {
                        for (String cmdEnv : cmdEnvs) {
                            envVars.addLine(cmdEnv);
                        }
                    }
                    LOGGER.log(Level.FINEST, "Launching with env vars: {0}", envVars.toString());
                    this.setupEnvironmentVariable(envVars, stdin, sh.equals("cmd"));
                    ContainerExecDecorator.doExec(stdin, printStream, masks, commands);
                    LOGGER.log(Level.INFO, "Created process inside pod: [" + ContainerExecDecorator.this.getPodName() + "], container: [" + ContainerExecDecorator.this.containerName + "]");
                    ContainerExecProc proc = new ContainerExecProc(watch, alive, finished, stdin, error);
                    ContainerExecDecorator.this.closables.add(proc);
                    return proc;
                }
                catch (InterruptedException ie) {
                    throw new InterruptedIOException(ie.getMessage());
                }
                catch (Exception e) {
                    ContainerExecDecorator.closeWatch(watch);
                    throw e;
                }
            }

            public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                this.getListener().getLogger().println("Killing processes");
                String cookie = modelEnvVars.get(ContainerExecDecorator.COOKIE_VAR);
                int exitCode = this.doLaunch(true, null, null, null, null, "sh", "-c", "kill \\`grep -l 'JENKINS_SERVER_COOKIE=" + cookie + "' /proc/*/environ | cut -d / -f 3 \\`").join();
                this.getListener().getLogger().println("kill finished with exit code " + exitCode);
            }

            private void setupEnvironmentVariable(EnvVars vars, OutputStream out, boolean windows) throws IOException {
                for (Map.Entry entry : vars.entrySet()) {
                    if (!((String)entry.getKey()).matches("[a-zA-Z_][a-zA-Z0-9_]*")) continue;
                    out.write(String.format(windows ? "set %s=%s%s" : "export %s='%s'%s", entry.getKey(), windows ? entry.getValue() : ((String)entry.getValue()).replace("'", "'\\''"), "\n").getBytes(StandardCharsets.UTF_8));
                }
            }

            private void waitUntilPodContainersAreReady() throws IOException {
                LOGGER.log(Level.FINEST, "Waiting until pod containers are ready: {0}/{1}", new String[]{ContainerExecDecorator.this.getNamespace(), ContainerExecDecorator.this.getPodName()});
                try {
                    Pod pod = (Pod)((PodResource)((NonNamespaceOperation)ContainerExecDecorator.this.getClient().pods().inNamespace(ContainerExecDecorator.this.getNamespace())).withName(ContainerExecDecorator.this.getPodName())).waitUntilReady(CONTAINER_READY_TIMEOUT, TimeUnit.MINUTES);
                    LOGGER.log(Level.FINEST, "Pod is ready: {0}/{1}", new String[]{ContainerExecDecorator.this.getNamespace(), ContainerExecDecorator.this.getPodName()});
                    if (pod == null || pod.getStatus() == null || pod.getStatus().getContainerStatuses() == null) {
                        throw new IOException("Failed to execute shell script inside container [" + ContainerExecDecorator.this.containerName + "] of pod [" + ContainerExecDecorator.this.getPodName() + "].Failed to get container status");
                    }
                    for (ContainerStatus info : pod.getStatus().getContainerStatuses()) {
                        if (!info.getName().equals(ContainerExecDecorator.this.containerName)) continue;
                        if (info.getReady().booleanValue()) {
                            return;
                        }
                        throw new IOException("container [" + ContainerExecDecorator.this.containerName + "] of pod [" + ContainerExecDecorator.this.getPodName() + "] is not ready, state is " + info.getState());
                    }
                    throw new IOException("container [" + ContainerExecDecorator.this.containerName + "] does not exist in pod [" + ContainerExecDecorator.this.getPodName() + "]");
                }
                catch (KubernetesClientTimeoutException | InterruptedException e) {
                    throw new IOException("Failed to execute shell script inside container [" + ContainerExecDecorator.this.containerName + "] of pod [" + ContainerExecDecorator.this.getPodName() + "]. Timed out waiting for container to become ready!", e);
                }
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.closables == null) {
            return;
        }
        for (Closeable closable : this.closables) {
            try {
                closable.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "failed to close {0}");
            }
        }
    }

    private static void doExec(OutputStream stdin, PrintStream out, boolean[] masks, String ... statements) {
        try {
            out.print("Executing command: ");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < statements.length; ++i) {
                String s = String.format("\"%s\" ", statements[i]);
                if (masks != null && masks[i]) {
                    sb.append("******** ");
                    out.print("******** ");
                } else {
                    sb.append(s);
                    out.print(s);
                }
                stdin.write(s.getBytes(StandardCharsets.UTF_8));
            }
            sb.append("\n");
            out.println();
            stdin.write("\n".getBytes(StandardCharsets.UTF_8));
            sb.append("exit\n");
            out.print("exit\n");
            LOGGER.log(Level.FINEST, "Executing command: {0}", sb);
            stdin.write("exit\n".getBytes(StandardCharsets.UTF_8));
            out.flush();
            stdin.flush();
        }
        catch (IOException e) {
            e.printStackTrace(out);
            throw new RuntimeException(e);
        }
    }

    static String[] getCommands(Launcher.ProcStarter starter) {
        ArrayList<String> allCommands = new ArrayList<String>();
        for (String cmd : starter.cmds()) {
            allCommands.add(cmd.replaceAll("\\$\\$", "\\\\\\$"));
        }
        return allCommands.toArray(new String[allCommands.size()]);
    }

    private static Long containerReadyTimeout() {
        String timeout = System.getProperty(CONTAINER_READY_TIMEOUT_SYSTEM_PROPERTY, String.valueOf(5L));
        try {
            return Long.parseLong(timeout);
        }
        catch (NumberFormatException e) {
            return 5L;
        }
    }

    private static void closeWatch(ExecWatch watch) {
        try {
            watch.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "failed to close watch", e);
        }
    }

    @Deprecated
    public void setKubernetesClient(KubernetesClient client) {
    }
}

