/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import hudson.Util;
import hudson.model.Label;
import hudson.model.Node;
import hudson.slaves.NodeProperty;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.ContainerTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodAnnotation;
import org.csanchez.jenkins.plugins.kubernetes.PodImagePullSecret;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateToolLocation;
import org.csanchez.jenkins.plugins.kubernetes.PortMapping;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;

public class PodTemplateUtils {
    private static final Logger LOGGER = Logger.getLogger(PodTemplateUtils.class.getName());
    private static final Pattern LABEL_VALIDATION = Pattern.compile("[a-zA-Z0-9]([_\\.\\-a-zA-Z0-9]*[a-zA-Z0-9])?");

    public static ContainerTemplate combine(@CheckForNull ContainerTemplate parent, @Nonnull ContainerTemplate template) {
        String args;
        boolean alwaysPullImage;
        String runAsGroup;
        String image;
        Preconditions.checkNotNull((Object)template, (Object)"Container template should not be null");
        if (parent == null) {
            return template;
        }
        String name = template.getName();
        String string = image = Strings.isNullOrEmpty((String)template.getImage()) ? parent.getImage() : template.getImage();
        boolean privileged = template.isPrivileged() ? template.isPrivileged() : (parent.isPrivileged() ? parent.isPrivileged() : false);
        String runAsUser = template.getRunAsUser() != null ? template.getRunAsUser() : parent.getRunAsUser();
        String string2 = runAsGroup = template.getRunAsGroup() != null ? template.getRunAsGroup() : parent.getRunAsGroup();
        boolean bl = template.isAlwaysPullImage() ? template.isAlwaysPullImage() : (alwaysPullImage = parent.isAlwaysPullImage() ? parent.isAlwaysPullImage() : false);
        String workingDir = Strings.isNullOrEmpty((String)template.getWorkingDir()) ? (Strings.isNullOrEmpty((String)parent.getWorkingDir()) ? "/home/jenkins/agent" : parent.getWorkingDir()) : template.getWorkingDir();
        String command = Strings.isNullOrEmpty((String)template.getCommand()) ? parent.getCommand() : template.getCommand();
        String string3 = args = Strings.isNullOrEmpty((String)template.getArgs()) ? parent.getArgs() : template.getArgs();
        boolean ttyEnabled = template.isTtyEnabled() ? template.isTtyEnabled() : (parent.isTtyEnabled() ? parent.isTtyEnabled() : false);
        String resourceRequestCpu = Strings.isNullOrEmpty((String)template.getResourceRequestCpu()) ? parent.getResourceRequestCpu() : template.getResourceRequestCpu();
        String resourceRequestMemory = Strings.isNullOrEmpty((String)template.getResourceRequestMemory()) ? parent.getResourceRequestMemory() : template.getResourceRequestMemory();
        String resourceLimitCpu = Strings.isNullOrEmpty((String)template.getResourceLimitCpu()) ? parent.getResourceLimitCpu() : template.getResourceLimitCpu();
        String resourceLimitMemory = Strings.isNullOrEmpty((String)template.getResourceLimitMemory()) ? parent.getResourceLimitMemory() : template.getResourceLimitMemory();
        Map ports = parent.getPorts().stream().collect(Collectors.toMap(PortMapping::getName, Function.identity()));
        template.getPorts().stream().forEach(p -> ports.put(p.getName(), p));
        ContainerTemplate combined = new ContainerTemplate(image);
        combined.setName(name);
        combined.setImage(image);
        combined.setAlwaysPullImage(alwaysPullImage);
        combined.setCommand(command);
        combined.setArgs(args);
        combined.setTtyEnabled(ttyEnabled);
        combined.setResourceLimitCpu(resourceLimitCpu);
        combined.setResourceLimitMemory(resourceLimitMemory);
        combined.setResourceRequestCpu(resourceRequestCpu);
        combined.setResourceRequestMemory(resourceRequestMemory);
        combined.setWorkingDir(workingDir);
        combined.setPrivileged(privileged);
        combined.setRunAsUser(runAsUser);
        combined.setRunAsGroup(runAsGroup);
        combined.setEnvVars(PodTemplateUtils.combineEnvVars(parent, template));
        combined.setPorts(new ArrayList<PortMapping>(ports.values()));
        return combined;
    }

    public static Container combine(@CheckForNull Container parent, @Nonnull Container template) {
        String imagePullPolicy;
        Long runAsUser;
        Boolean privileged;
        String image;
        Preconditions.checkNotNull((Object)template, (Object)"Container template should not be null");
        if (parent == null) {
            return template;
        }
        String name = template.getName();
        String string = image = Strings.isNullOrEmpty((String)template.getImage()) ? parent.getImage() : template.getImage();
        Boolean bl = template.getSecurityContext() != null && template.getSecurityContext().getPrivileged() != null ? template.getSecurityContext().getPrivileged() : (privileged = parent.getSecurityContext() != null ? parent.getSecurityContext().getPrivileged() : Boolean.FALSE);
        Long l = template.getSecurityContext() != null && template.getSecurityContext().getRunAsUser() != null ? template.getSecurityContext().getRunAsUser() : (runAsUser = parent.getSecurityContext() != null ? parent.getSecurityContext().getRunAsUser() : null);
        Long runAsGroup = template.getSecurityContext() != null && template.getSecurityContext().getRunAsGroup() != null ? template.getSecurityContext().getRunAsGroup() : (parent.getSecurityContext() != null ? parent.getSecurityContext().getRunAsGroup() : null);
        String string2 = imagePullPolicy = Strings.isNullOrEmpty((String)template.getImagePullPolicy()) ? parent.getImagePullPolicy() : template.getImagePullPolicy();
        String workingDir = Strings.isNullOrEmpty((String)template.getWorkingDir()) ? (Strings.isNullOrEmpty((String)parent.getWorkingDir()) ? "/home/jenkins/agent" : parent.getWorkingDir()) : template.getWorkingDir();
        List command = template.getCommand() == null ? parent.getCommand() : template.getCommand();
        List args = template.getArgs() == null ? parent.getArgs() : template.getArgs();
        Boolean tty = template.getTty() != null ? template.getTty() : parent.getTty();
        Map<String, Quantity> requests = PodTemplateUtils.combineResources(parent, template, ResourceRequirements::getRequests);
        Map<String, Quantity> limits = PodTemplateUtils.combineResources(parent, template, ResourceRequirements::getLimits);
        Map volumeMounts = parent.getVolumeMounts().stream().collect(Collectors.toMap(VolumeMount::getMountPath, Function.identity()));
        template.getVolumeMounts().stream().forEach(vm -> volumeMounts.put(vm.getMountPath(), vm));
        Container combined = ((ContainerBuilder)((ContainerBuilder)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)((ContainerFluent.SecurityContextNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerFluent.ResourcesNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder(parent).withImage(image)).withName(name)).withImagePullPolicy(imagePullPolicy)).withCommand(command)).withWorkingDir(workingDir)).withArgs(args)).withTty(tty)).withNewResources().withRequests((Map)ImmutableMap.copyOf(requests))).withLimits((Map)ImmutableMap.copyOf(limits))).endResources()).withEnv(PodTemplateUtils.combineEnvVars(parent, template))).withEnvFrom(PodTemplateUtils.combinedEnvFromSources(parent, template))).withNewSecurityContext().withPrivileged(privileged)).withRunAsUser(runAsUser)).withRunAsGroup(runAsGroup)).endSecurityContext()).withVolumeMounts(new ArrayList(volumeMounts.values()))).build();
        return combined;
    }

    private static Map<String, Quantity> combineResources(Container parent, Container template, Function<ResourceRequirements, Map<String, Quantity>> resourceTypeMapper) {
        return Stream.of(template.getResources(), parent.getResources()).filter(Objects::nonNull).map(resourceTypeMapper).filter(Objects::nonNull).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
    }

    public static Pod combine(List<Pod> pods) {
        Pod result = null;
        for (Pod p : pods) {
            if (result != null) {
                result = PodTemplateUtils.combine(result, p);
                continue;
            }
            result = p;
        }
        return result;
    }

    public static Pod combine(Pod parent, Pod template) {
        Preconditions.checkNotNull((Object)template, (Object)"Pod template should not be null");
        if (parent == null) {
            return template;
        }
        LOGGER.log(Level.FINE, "Combining pods, parent: {0}", parent);
        LOGGER.log(Level.FINE, "Combining pods, template: {0}", template);
        Map nodeSelector = PodTemplateUtils.mergeMaps(parent.getSpec().getNodeSelector(), template.getSpec().getNodeSelector());
        String serviceAccount = Strings.isNullOrEmpty((String)template.getSpec().getServiceAccount()) ? parent.getSpec().getServiceAccount() : template.getSpec().getServiceAccount();
        Boolean hostNetwork = template.getSpec().getHostNetwork() != null ? template.getSpec().getHostNetwork() : parent.getSpec().getHostNetwork();
        Map podAnnotations = PodTemplateUtils.mergeMaps(parent.getMetadata().getAnnotations(), template.getMetadata().getAnnotations());
        Map podLabels = PodTemplateUtils.mergeMaps(parent.getMetadata().getLabels(), template.getMetadata().getLabels());
        LinkedHashSet imagePullSecrets = new LinkedHashSet();
        imagePullSecrets.addAll(parent.getSpec().getImagePullSecrets());
        imagePullSecrets.addAll(template.getSpec().getImagePullSecrets());
        HashMap<String, Container> combinedContainers = new HashMap<String, Container>();
        Map<String, Container> parentContainers = parent.getSpec().getContainers().stream().collect(Collectors.toMap(c -> c.getName(), c -> c));
        combinedContainers.putAll(parentContainers);
        combinedContainers.putAll(template.getSpec().getContainers().stream().collect(Collectors.toMap(c -> c.getName(), c -> PodTemplateUtils.combine((Container)parentContainers.get(c.getName()), c))));
        List<Volume> combinedVolumes = PodTemplateUtils.combineVolumes(parent.getSpec().getVolumes(), template.getSpec().getVolumes());
        LinkedList combinedTolerations = Lists.newLinkedList();
        Optional.ofNullable(parent.getSpec().getTolerations()).ifPresent(combinedTolerations::addAll);
        Optional.ofNullable(template.getSpec().getTolerations()).ifPresent(combinedTolerations::addAll);
        PodFluent.MetadataNested metadataBuilder = (PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder(parent).withNewMetadataLike(parent.getMetadata()).withAnnotations(podAnnotations)).withLabels(podLabels);
        if (!Strings.isNullOrEmpty((String)template.getMetadata().getName())) {
            metadataBuilder.withName(template.getMetadata().getName());
        }
        if (!Strings.isNullOrEmpty((String)template.getMetadata().getNamespace())) {
            metadataBuilder.withNamespace(template.getMetadata().getNamespace());
        }
        PodFluent.SpecNested specBuilder = (PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)metadataBuilder.endMetadata()).withNewSpecLike(parent.getSpec()).withNodeSelector(nodeSelector)).withServiceAccount(serviceAccount)).withHostNetwork(hostNetwork)).withContainers((List)Lists.newArrayList(combinedContainers.values()))).withVolumes(combinedVolumes)).withTolerations((List)combinedTolerations)).withImagePullSecrets((List)Lists.newArrayList(imagePullSecrets));
        ((PodSpecFluent.SecurityContextNested)((PodSpecFluent.SecurityContextNested)specBuilder.editOrNewSecurityContext().withRunAsUser(template.getSpec().getSecurityContext() != null && template.getSpec().getSecurityContext().getRunAsUser() != null ? template.getSpec().getSecurityContext().getRunAsUser() : (parent.getSpec().getSecurityContext() != null && parent.getSpec().getSecurityContext().getRunAsUser() != null ? parent.getSpec().getSecurityContext().getRunAsUser() : null))).withRunAsGroup(template.getSpec().getSecurityContext() != null && template.getSpec().getSecurityContext().getRunAsGroup() != null ? template.getSpec().getSecurityContext().getRunAsGroup() : (parent.getSpec().getSecurityContext() != null && parent.getSpec().getSecurityContext().getRunAsGroup() != null ? parent.getSpec().getSecurityContext().getRunAsGroup() : null))).endSecurityContext();
        Pod pod = ((PodBuilder)specBuilder.endSpec()).build();
        LOGGER.log(Level.FINE, "Pods combined: {0}", pod);
        return pod;
    }

    private static List<Volume> combineVolumes(@Nonnull List<Volume> volumes1, @Nonnull List<Volume> volumes2) {
        Map volumesByName = volumes1.stream().collect(Collectors.toMap(Volume::getName, Function.identity()));
        volumes2.forEach(v -> volumesByName.put(v.getName(), v));
        return new ArrayList<Volume>(volumesByName.values());
    }

    public static PodTemplate combine(PodTemplate parent, PodTemplate template) {
        Preconditions.checkNotNull((Object)template, (Object)"Pod template should not be null");
        if (parent == null) {
            return template;
        }
        LOGGER.log(Level.FINEST, "Combining pod templates, parent: {0}", parent);
        LOGGER.log(Level.FINEST, "Combining pod templates, template: {0}", template);
        String name = template.getName();
        String label = template.getLabel();
        String nodeSelector = Strings.isNullOrEmpty((String)template.getNodeSelector()) ? parent.getNodeSelector() : template.getNodeSelector();
        String serviceAccount = Strings.isNullOrEmpty((String)template.getServiceAccount()) ? parent.getServiceAccount() : template.getServiceAccount();
        Node.Mode nodeUsageMode = template.getNodeUsageMode() == null ? parent.getNodeUsageMode() : template.getNodeUsageMode();
        LinkedHashSet<PodAnnotation> podAnnotations = new LinkedHashSet<PodAnnotation>();
        podAnnotations.addAll(template.getAnnotations());
        podAnnotations.addAll(parent.getAnnotations());
        LinkedHashSet<PodImagePullSecret> imagePullSecrets = new LinkedHashSet<PodImagePullSecret>();
        imagePullSecrets.addAll(parent.getImagePullSecrets());
        imagePullSecrets.addAll(template.getImagePullSecrets());
        HashMap<String, ContainerTemplate> combinedContainers = new HashMap<String, ContainerTemplate>();
        HashMap<String, PodVolume> combinedVolumes = new HashMap<String, PodVolume>();
        Map<String, ContainerTemplate> parentContainers = parent.getContainers().stream().collect(Collectors.toMap(c -> c.getName(), c -> c));
        combinedContainers.putAll(parentContainers);
        combinedContainers.putAll(template.getContainers().stream().collect(Collectors.toMap(c -> c.getName(), c -> PodTemplateUtils.combine((ContainerTemplate)parentContainers.get(c.getName()), c))));
        Map<String, PodVolume> parentVolumes = parent.getVolumes().stream().collect(Collectors.toMap(v -> v.getMountPath(), v -> v));
        combinedVolumes.putAll(parentVolumes);
        combinedVolumes.putAll(template.getVolumes().stream().collect(Collectors.toMap(v -> v.getMountPath(), v -> v)));
        WorkspaceVolume workspaceVolume = WorkspaceVolume.merge(parent.getWorkspaceVolume(), template.getWorkspaceVolume());
        PodTemplateToolLocation toolLocationNodeProperties = parent.getNodeProperties();
        toolLocationNodeProperties.addAll((Collection)((Object)template.getNodeProperties()));
        PodTemplate podTemplate = new PodTemplate();
        podTemplate.setName(name);
        podTemplate.setNamespace(!Strings.isNullOrEmpty((String)template.getNamespace()) ? template.getNamespace() : parent.getNamespace());
        podTemplate.setLabel(label);
        podTemplate.setNodeSelector(nodeSelector);
        podTemplate.setServiceAccount(serviceAccount);
        podTemplate.setEnvVars(PodTemplateUtils.combineEnvVars(parent, template));
        podTemplate.setContainers(new ArrayList<ContainerTemplate>(combinedContainers.values()));
        podTemplate.setWorkspaceVolume(workspaceVolume);
        podTemplate.setVolumes(new ArrayList<PodVolume>(combinedVolumes.values()));
        podTemplate.setImagePullSecrets(new ArrayList<PodImagePullSecret>(imagePullSecrets));
        podTemplate.setAnnotations(new ArrayList<PodAnnotation>(podAnnotations));
        podTemplate.setNodeProperties((List<? extends NodeProperty<?>>)((Object)toolLocationNodeProperties));
        podTemplate.setNodeUsageMode(nodeUsageMode);
        podTemplate.setYamlMergeStrategy(template.getYamlMergeStrategy());
        podTemplate.setInheritFrom(!Strings.isNullOrEmpty((String)template.getInheritFrom()) ? template.getInheritFrom() : parent.getInheritFrom());
        podTemplate.setInstanceCap(template.getInstanceCap() != Integer.MAX_VALUE ? template.getInstanceCap() : parent.getInstanceCap());
        podTemplate.setSlaveConnectTimeout(template.getSlaveConnectTimeout() != PodTemplate.DEFAULT_SLAVE_JENKINS_CONNECTION_TIMEOUT.intValue() ? template.getSlaveConnectTimeout() : parent.getSlaveConnectTimeout());
        podTemplate.setIdleMinutes(template.getIdleMinutes() != 0 ? template.getIdleMinutes() : parent.getIdleMinutes());
        podTemplate.setActiveDeadlineSeconds(template.getActiveDeadlineSeconds() != 0 ? template.getActiveDeadlineSeconds() : parent.getActiveDeadlineSeconds());
        podTemplate.setServiceAccount(!Strings.isNullOrEmpty((String)template.getServiceAccount()) ? template.getServiceAccount() : parent.getServiceAccount());
        podTemplate.setPodRetention(template.getPodRetention());
        podTemplate.setShowRawYaml(template.isShowRawYamlSet() ? template.isShowRawYaml() : parent.isShowRawYaml());
        podTemplate.setRunAsUser(template.getRunAsUser() != null ? template.getRunAsUser() : parent.getRunAsUser());
        podTemplate.setRunAsGroup(template.getRunAsGroup() != null ? template.getRunAsGroup() : parent.getRunAsGroup());
        podTemplate.setHostNetwork(template.isHostNetworkSet() ? template.isHostNetwork() : parent.isHostNetwork());
        ArrayList<String> yamls = new ArrayList<String>(parent.getYamls());
        yamls.addAll(template.getYamls());
        podTemplate.setYamls(yamls);
        LOGGER.log(Level.FINEST, "Pod templates combined: {0}", podTemplate);
        return podTemplate;
    }

    static PodTemplate unwrap(PodTemplate template, String defaultProviderTemplate, Collection<PodTemplate> allTemplates) {
        String inheritFrom;
        if (template == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)defaultProviderTemplate)) {
            sb.append(defaultProviderTemplate).append(" ");
        }
        if (!Strings.isNullOrEmpty((String)template.getInheritFrom())) {
            sb.append(template.getInheritFrom()).append(" ");
        }
        if (Strings.isNullOrEmpty((String)(inheritFrom = sb.toString()))) {
            return template;
        }
        String[] parentNames = inheritFrom.split("[ ]+");
        PodTemplate parent = null;
        for (String name : parentNames) {
            PodTemplate next = PodTemplateUtils.getTemplateByName(name, allTemplates);
            if (next == null) continue;
            parent = PodTemplateUtils.combine(parent, PodTemplateUtils.unwrap(next, allTemplates));
        }
        PodTemplate combined = PodTemplateUtils.combine(parent, template);
        LOGGER.log(Level.FINEST, "Combined parent + template is {0}", combined);
        return combined;
    }

    static PodTemplate unwrap(PodTemplate template, Collection<PodTemplate> allTemplates) {
        return PodTemplateUtils.unwrap(template, null, allTemplates);
    }

    public static PodTemplate getTemplateByLabel(@CheckForNull Label label, Collection<PodTemplate> templates) {
        for (PodTemplate t : templates) {
            if ((label != null || t.getNodeUsageMode() != Node.Mode.NORMAL) && (label == null || !label.matches(t.getLabelSet()))) continue;
            return t;
        }
        return null;
    }

    public static PodTemplate getTemplateByName(@CheckForNull String name, Collection<PodTemplate> templates) {
        for (PodTemplate t : templates) {
            if (name == null || !name.equals(t.getName())) continue;
            return t;
        }
        return null;
    }

    public static String substituteEnv(String s) {
        return Util.replaceMacro((String)s, System.getenv());
    }

    @Deprecated
    public static String substituteEnv(String s, String defaultValue) {
        return PodTemplateUtils.substitute(s, System.getenv(), defaultValue);
    }

    @Deprecated
    public static String substitute(String s, Map<String, String> properties) {
        return Util.replaceMacro((String)s, properties);
    }

    @Deprecated
    public static String substitute(String s, Map<String, String> properties, String defaultValue) {
        return Strings.isNullOrEmpty((String)s) ? defaultValue : Util.replaceMacro((String)s, properties);
    }

    public static Pod parseFromYaml(String yaml) {
        String s = yaml;
        try (DefaultKubernetesClient client = new DefaultKubernetesClient();){
            Pod podFromYaml;
            if (StringUtils.isBlank((String)s)) {
                LOGGER.log(Level.WARNING, "[JENKINS-57116] Trying to parse invalid yaml: \"{0}\"", yaml);
                s = "{}";
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));){
                podFromYaml = (Pod)((PodResource)client.pods().load((InputStream)is)).get();
            }
            catch (KubernetesClientException | IOException e) {
                throw new RuntimeException(String.format("Failed to parse yaml: \"%s\"", yaml), e);
            }
            LOGGER.log(Level.FINEST, "Parsed pod template from yaml: {0}", podFromYaml);
            if (podFromYaml.getMetadata() == null) {
                podFromYaml.setMetadata(new ObjectMeta());
            }
            if (podFromYaml.getSpec() == null) {
                podFromYaml.setSpec(new PodSpec());
            }
            Pod pod = podFromYaml;
            return pod;
        }
    }

    public static Collection<String> validateYamlContainerNames(List<String> yamls) {
        ArrayList<String> errors = new ArrayList<String>();
        for (String yaml : yamls) {
            errors.addAll(PodTemplateUtils.validateYamlContainerNames(yaml));
        }
        return errors;
    }

    public static Collection<String> validateYamlContainerNames(String yaml) {
        if (StringUtils.isBlank((String)yaml)) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        Pod pod = PodTemplateUtils.parseFromYaml(yaml);
        List containers = pod.getSpec().getContainers();
        if (containers != null) {
            for (Container container : containers) {
                if (PodTemplateUtils.validateContainerName(container.getName())) continue;
                errors.add(container.getName());
            }
        }
        return errors;
    }

    public static boolean validateContainerName(String name) {
        if (name != null && !name.isEmpty()) {
            Pattern p = Pattern.compile("[a-z0-9]([-a-z0-9]*[a-z0-9])?");
            Matcher m = p.matcher(name);
            return m.matches();
        }
        return true;
    }

    public static boolean validateLabel(String label) {
        return StringUtils.isBlank((String)label) ? true : label.length() <= 63 && LABEL_VALIDATION.matcher(label).matches();
    }

    private static List<EnvVar> combineEnvVars(Container parent, Container template) {
        Map<String, EnvVar> combinedEnvVars = PodTemplateUtils.mergeMaps(PodTemplateUtils.envVarstoMap(parent.getEnv()), PodTemplateUtils.envVarstoMap(template.getEnv()));
        return combinedEnvVars.entrySet().stream().filter(envVar -> !Strings.isNullOrEmpty((String)((String)envVar.getKey()))).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @VisibleForTesting
    static Map<String, EnvVar> envVarstoMap(List<EnvVar> envVarList) {
        return envVarList.stream().collect(Collectors.toMap(EnvVar::getName, Function.identity()));
    }

    private static List<TemplateEnvVar> combineEnvVars(ContainerTemplate parent, ContainerTemplate template) {
        return PodTemplateUtils.combineEnvVars(parent.getEnvVars(), template.getEnvVars());
    }

    private static List<TemplateEnvVar> combineEnvVars(PodTemplate parent, PodTemplate template) {
        return PodTemplateUtils.combineEnvVars(parent.getEnvVars(), template.getEnvVars());
    }

    private static List<TemplateEnvVar> combineEnvVars(List<TemplateEnvVar> parent, List<TemplateEnvVar> child) {
        Map<String, TemplateEnvVar> combinedEnvVars = PodTemplateUtils.mergeMaps(PodTemplateUtils.templateEnvVarstoMap(parent), PodTemplateUtils.templateEnvVarstoMap(child));
        return combinedEnvVars.entrySet().stream().filter(entry -> !Strings.isNullOrEmpty((String)((String)entry.getKey()))).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @VisibleForTesting
    static Map<String, TemplateEnvVar> templateEnvVarstoMap(List<TemplateEnvVar> envVarList) {
        return envVarList.stream().collect(Collectors.toMap(TemplateEnvVar::getKey, Function.identity(), PodTemplateUtils.throwingMerger(), LinkedHashMap::new));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private static List<EnvFromSource> combinedEnvFromSources(Container parent, Container template) {
        ArrayList combinedEnvFromSources = new ArrayList();
        combinedEnvFromSources.addAll(parent.getEnvFrom());
        combinedEnvFromSources.addAll(template.getEnvFrom());
        return combinedEnvFromSources.stream().filter(envFromSource -> envFromSource.getConfigMapRef() != null && !Strings.isNullOrEmpty((String)envFromSource.getConfigMapRef().getName()) || envFromSource.getSecretRef() != null && !Strings.isNullOrEmpty((String)envFromSource.getSecretRef().getName())).collect(Collectors.toList());
    }

    private static <K, V> Map<K, V> mergeMaps(Map<K, V> m1, Map<K, V> m2) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        if (m1 != null) {
            m.putAll(m1);
        }
        if (m2 != null) {
            m.putAll(m2);
        }
        return m;
    }

    static Long parseLong(String value) {
        String s = Util.fixEmptyAndTrim((String)value);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

